/*
 * Decompiled with CFR 0.152.
 */
package org.ironjacamar.core.connectionmanager.pool;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import javax.resource.ResourceException;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.ValidatingManagedConnectionFactory;
import org.ironjacamar.core.CoreLogger;
import org.ironjacamar.core.connectionmanager.Credential;
import org.ironjacamar.core.connectionmanager.listener.ConnectionListener;
import org.ironjacamar.core.connectionmanager.pool.ManagedConnectionPool;
import org.ironjacamar.core.connectionmanager.pool.Pool;
import org.ironjacamar.core.tracer.Tracer;

public abstract class AbstractManagedConnectionPool
implements ManagedConnectionPool {
    protected CoreLogger log;
    protected Pool pool;
    protected Credential credential;
    protected final boolean poolIsFifo;
    protected long lastIdleCheck;

    public AbstractManagedConnectionPool(Pool pool, Credential credential) {
        this.log = pool.getLogger();
        this.pool = pool;
        this.credential = credential;
        this.poolIsFifo = pool.isFIFO() && credential.equals(pool.getPrefillCredential());
        this.lastIdleCheck = System.currentTimeMillis();
    }

    @Override
    public Pool getPool() {
        return this.pool;
    }

    protected ConnectionListener validateConnectionListener(Collection<ConnectionListener> listeners, ConnectionListener cl, int newState) {
        block11: {
            ManagedConnectionFactory mcf = this.pool.getConnectionManager().getManagedConnectionFactory();
            if (mcf instanceof ValidatingManagedConnectionFactory) {
                ValidatingManagedConnectionFactory vcf = (ValidatingManagedConnectionFactory)mcf;
                try {
                    Set candidateSet = Collections.singleton(cl.getManagedConnection());
                    candidateSet = vcf.getInvalidConnections(candidateSet);
                    if (candidateSet != null && !candidateSet.isEmpty()) {
                        if (Tracer.isEnabled()) {
                            Tracer.destroyConnectionListener(this.pool.getConfiguration().getId(), this, cl, false, false, true, false, false, false, false, Tracer.isRecordCallstacks() ? new Throwable("CALLSTACK") : null);
                        }
                        this.destroyAndRemoveConnectionListener(cl, listeners);
                        break block11;
                    }
                    cl.validated();
                    if (cl.changeState(6, newState)) {
                        return cl;
                    }
                    if (Tracer.isEnabled()) {
                        Tracer.destroyConnectionListener(this.pool.getConfiguration().getId(), this, cl, false, false, true, false, false, false, false, Tracer.isRecordCallstacks() ? new Throwable("CALLSTACK") : null);
                    }
                    this.destroyAndRemoveConnectionListener(cl, listeners);
                }
                catch (ResourceException re) {
                    if (Tracer.isEnabled()) {
                        Tracer.destroyConnectionListener(this.pool.getConfiguration().getId(), this, cl, false, false, true, false, false, false, false, Tracer.isRecordCallstacks() ? new Throwable("CALLSTACK") : null);
                    }
                    this.destroyAndRemoveConnectionListener(cl, listeners);
                }
            } else {
                this.log.debug("mcf is not instance of ValidatingManagedConnectionFactory");
                if (cl.changeState(6, newState)) {
                    return cl;
                }
                if (Tracer.isEnabled()) {
                    Tracer.destroyConnectionListener(this.pool.getConfiguration().getId(), this, cl, false, false, true, false, false, false, false, Tracer.isRecordCallstacks() ? new Throwable("CALLSTACK") : null);
                }
                this.destroyAndRemoveConnectionListener(cl, listeners);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void destroyAndRemoveConnectionListener(ConnectionListener cl, Collection<ConnectionListener> listeners) {
        try {
            this.pool.destroyConnectionListener(cl);
        }
        catch (ResourceException e) {
            cl.setState(7);
        }
        finally {
            listeners.remove(cl);
        }
    }

    protected ConnectionListener findConnectionListener(ManagedConnection mc, Object c, Collection<ConnectionListener> listeners) {
        for (ConnectionListener cl : listeners) {
            if (!cl.getManagedConnection().equals(mc) || c != null && !cl.getConnections().contains(c)) continue;
            return cl;
        }
        return null;
    }

    protected ConnectionListener removeConnectionListener(boolean free, Collection<ConnectionListener> listeners) {
        if (free) {
            for (ConnectionListener cl : listeners) {
                if (!cl.changeState(1, 2)) continue;
                return cl;
            }
        } else {
            for (ConnectionListener cl : listeners) {
                if (cl.getState() != 2) continue;
                return cl;
            }
        }
        return null;
    }

    protected int getCount(int type, Collection<ConnectionListener> listeners) {
        int count = 0;
        for (ConnectionListener cl : listeners) {
            if (cl.getState() != type) continue;
            ++count;
        }
        return count;
    }
}

