/*
 * Decompiled with CFR 0.152.
 */
package org.ironjacamar.core.connectionmanager.pool;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.TransactionSupport;
import javax.security.auth.Subject;
import javax.transaction.Synchronization;
import javax.transaction.Transaction;
import javax.transaction.xa.XAResource;
import org.ironjacamar.common.api.metadata.common.FlushStrategy;
import org.ironjacamar.core.api.connectionmanager.pool.FlushMode;
import org.ironjacamar.core.api.connectionmanager.pool.PoolConfiguration;
import org.ironjacamar.core.api.connectionmanager.pool.PoolStatistics;
import org.ironjacamar.core.connectionmanager.ConnectionManager;
import org.ironjacamar.core.connectionmanager.Credential;
import org.ironjacamar.core.connectionmanager.TransactionalConnectionManager;
import org.ironjacamar.core.connectionmanager.listener.ConnectionListener;
import org.ironjacamar.core.connectionmanager.pool.Capacity;
import org.ironjacamar.core.connectionmanager.pool.Janitor;
import org.ironjacamar.core.connectionmanager.pool.ManagedConnectionPool;
import org.ironjacamar.core.connectionmanager.pool.Pool;
import org.ironjacamar.core.connectionmanager.pool.PoolStatisticsImpl;
import org.ironjacamar.core.connectionmanager.pool.SecurityActions;
import org.ironjacamar.core.connectionmanager.pool.Semaphore;
import org.ironjacamar.core.connectionmanager.pool.TransactionMapCleanup;
import org.ironjacamar.core.connectionmanager.pool.capacity.DefaultCapacity;
import org.ironjacamar.core.connectionmanager.pool.capacity.TimedOutDecrementer;
import org.ironjacamar.core.spi.transaction.ConnectableResource;
import org.ironjacamar.core.spi.transaction.TxUtils;
import org.ironjacamar.core.spi.transaction.XAResourceStatistics;
import org.ironjacamar.core.spi.transaction.local.LocalXAResource;
import org.ironjacamar.core.spi.transaction.xa.XAResourceWrapper;
import org.ironjacamar.core.tracer.Tracer;
import org.jboss.logging.Logger;

public abstract class AbstractPool
implements Pool {
    private static Logger log = Logger.getLogger(AbstractPool.class);
    protected ConnectionManager cm;
    protected PoolConfiguration poolConfiguration;
    protected ConcurrentHashMap<Credential, ManagedConnectionPool> pools;
    protected ConcurrentHashMap<Object, Map<ManagedConnectionPool, ConnectionListener>> transactionMap;
    protected Semaphore semaphore;
    private Credential prefillCredential;
    private FlushStrategy flushStrategy;
    private Capacity capacity;
    protected PoolStatisticsImpl statistics;
    protected Janitor janitor;

    public AbstractPool(ConnectionManager cm, PoolConfiguration pc) {
        this.cm = cm;
        this.poolConfiguration = pc;
        this.pools = new ConcurrentHashMap();
        this.transactionMap = new ConcurrentHashMap();
        this.statistics = new PoolStatisticsImpl(this.poolConfiguration.getMaxSize());
        this.semaphore = new Semaphore(this.poolConfiguration.getMaxSize(), this.statistics);
        this.flushStrategy = this.poolConfiguration.getFlushStrategy();
        this.capacity = null;
        this.janitor = null;
    }

    @Override
    public ConnectionManager getConnectionManager() {
        return this.cm;
    }

    @Override
    public PoolConfiguration getConfiguration() {
        return this.poolConfiguration;
    }

    @Override
    public Semaphore getPermits() {
        return this.semaphore;
    }

    @Override
    public PoolStatistics getStatistics() {
        return this.statistics;
    }

    @Override
    public PoolStatisticsImpl getInternalStatistics() {
        return this.statistics;
    }

    @Override
    public Janitor getJanitor() {
        return this.janitor;
    }

    @Override
    public void setJanitor(Janitor v) {
        this.janitor = v;
    }

    @Override
    public ConnectionListener getConnectionListener(Credential credential) throws ResourceException {
        ManagedConnectionPool mcp;
        ConnectionListener cl;
        block8: {
            log.tracef("getConnectionListener(%s)", (Object)credential);
            cl = null;
            mcp = this.getManagedConnectionPool(credential);
            if (this.isShutdown()) {
                throw new ResourceException();
            }
            if (this.cm.getTransactionSupport() == TransactionSupport.TransactionSupportLevel.LocalTransaction || this.cm.getTransactionSupport() == TransactionSupport.TransactionSupportLevel.XATransaction) {
                try {
                    HashMap<ManagedConnectionPool, ConnectionListener> map;
                    TransactionalConnectionManager txCM = (TransactionalConnectionManager)this.cm;
                    Transaction tx = txCM.getTransactionIntegration().getTransactionManager().getTransaction();
                    if (!TxUtils.isUncommitted(tx)) break block8;
                    Object id = txCM.getTransactionIntegration().getTransactionSynchronizationRegistry().getTransactionKey();
                    HashMap<ManagedConnectionPool, ConnectionListener> currentMap = this.transactionMap.get(id);
                    if (currentMap == null && (currentMap = (HashMap<ManagedConnectionPool, ConnectionListener>)this.transactionMap.putIfAbsent(id, map = new HashMap<ManagedConnectionPool, ConnectionListener>())) == null) {
                        currentMap = map;
                    }
                    if ((cl = currentMap.get(mcp)) != null) break block8;
                    if (TxUtils.isActive(tx)) {
                        cl = mcp.getConnectionListener();
                        currentMap.put(mcp, cl);
                        txCM.getTransactionIntegration().getTransactionSynchronizationRegistry().registerInterposedSynchronization((Synchronization)new TransactionMapCleanup(id, this.transactionMap));
                        break block8;
                    }
                    throw new ResourceException();
                }
                catch (ResourceException re) {
                    throw re;
                }
                catch (Exception e) {
                    throw new ResourceException((Throwable)e);
                }
            }
        }
        if (cl == null) {
            cl = mcp.getConnectionListener();
        }
        return cl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ManagedConnectionPool getManagedConnectionPool(Credential credential) {
        ManagedConnectionPool mcp = this.pools.get(credential);
        if (mcp == null) {
            AbstractPool abstractPool = this;
            synchronized (abstractPool) {
                mcp = this.pools.get(credential);
                if (mcp == null) {
                    ManagedConnectionPool newMcp = this.createManagedConnectionPool(credential);
                    mcp = this.pools.putIfAbsent(credential, newMcp);
                    if (mcp == null) {
                        mcp = newMcp;
                        if (Tracer.isEnabled()) {
                            Tracer.createManagedConnectionPool(this.poolConfiguration.getId(), mcp);
                        }
                    } else {
                        newMcp.shutdown();
                    }
                }
            }
        }
        return mcp;
    }

    @Override
    public void returnConnectionListener(ConnectionListener cl, boolean kill) throws ResourceException {
        log.tracef("returnConnectionListener(%s, %s)", (Object)cl, (Object)kill);
        ManagedConnectionPool mcp = this.pools.get(cl.getCredential());
        if (!kill) {
            boolean bl = kill = cl.getState() == 3;
        }
        if (Tracer.isEnabled()) {
            Tracer.returnConnectionListener(this.poolConfiguration.getId(), cl.getManagedConnectionPool(), cl, kill, false, Tracer.isRecordCallstacks() ? new Throwable("CALLSTACK") : null);
        }
        mcp.returnConnectionListener(cl, kill);
    }

    @Override
    public boolean isFull() {
        return this.semaphore.availablePermits() == 0;
    }

    @Override
    public synchronized void shutdown() {
        for (ManagedConnectionPool mcp : this.pools.values()) {
            mcp.shutdown();
            if (!Tracer.isEnabled()) continue;
            Tracer.destroyManagedConnectionPool(this.poolConfiguration.getId(), mcp);
        }
        this.pools.clear();
    }

    @Override
    public boolean isShutdown() {
        return this.cm.isShutdown();
    }

    protected LocalXAResource getLocalXAResource(ManagedConnection mc) throws ResourceException {
        TransactionalConnectionManager txCM = (TransactionalConnectionManager)this.cm;
        LocalXAResource xaResource = null;
        String eisProductName = null;
        String eisProductVersion = null;
        String jndiName = this.cm.getConnectionManagerConfiguration().getJndiName();
        try {
            if (mc.getMetaData() != null) {
                eisProductName = mc.getMetaData().getEISProductName();
                eisProductVersion = mc.getMetaData().getEISProductVersion();
            }
        }
        catch (ResourceException resourceException) {
            // empty catch block
        }
        if (eisProductName == null) {
            eisProductName = jndiName;
        }
        if (eisProductVersion == null) {
            eisProductVersion = jndiName;
        }
        if (this.cm.getConnectionManagerConfiguration().isConnectable()) {
            if (mc instanceof ConnectableResource) {
                ConnectableResource cr = (ConnectableResource)mc;
                xaResource = txCM.getTransactionIntegration().createConnectableLocalXAResource((org.ironjacamar.core.api.connectionmanager.ConnectionManager)this.cm, eisProductName, eisProductVersion, jndiName, cr, (XAResourceStatistics)this.statistics);
            } else if (txCM.getTransactionIntegration().isConnectableResource(mc)) {
                xaResource = txCM.getTransactionIntegration().createConnectableLocalXAResource((org.ironjacamar.core.api.connectionmanager.ConnectionManager)this.cm, eisProductName, eisProductVersion, jndiName, mc, (XAResourceStatistics)this.statistics);
            }
        }
        if (xaResource == null) {
            xaResource = txCM.getTransactionIntegration().createLocalXAResource(this.cm, eisProductName, eisProductVersion, jndiName, this.statistics);
        }
        return xaResource;
    }

    protected XAResource getXAResource(ManagedConnection mc) throws ResourceException {
        TransactionalConnectionManager txCM = (TransactionalConnectionManager)this.cm;
        XAResource xaResource = null;
        if (this.cm.getConnectionManagerConfiguration().isWrapXAResource()) {
            String eisProductName = null;
            String eisProductVersion = null;
            String jndiName = this.cm.getConnectionManagerConfiguration().getJndiName();
            boolean padXid = this.cm.getConnectionManagerConfiguration().isPadXid();
            Boolean isSameRMOverride = this.cm.getConnectionManagerConfiguration().isIsSameRMOverride();
            try {
                if (mc.getMetaData() != null) {
                    eisProductName = mc.getMetaData().getEISProductName();
                    eisProductVersion = mc.getMetaData().getEISProductVersion();
                }
            }
            catch (ResourceException resourceException) {
                // empty catch block
            }
            if (eisProductName == null) {
                eisProductName = jndiName;
            }
            if (eisProductVersion == null) {
                eisProductVersion = jndiName;
            }
            if (this.cm.getConnectionManagerConfiguration().isConnectable()) {
                if (mc instanceof ConnectableResource) {
                    ConnectableResource cr = (ConnectableResource)mc;
                    xaResource = txCM.getTransactionIntegration().createConnectableXAResourceWrapper(mc.getXAResource(), padXid, isSameRMOverride, eisProductName, eisProductVersion, jndiName, cr, (XAResourceStatistics)this.statistics);
                } else if (txCM.getTransactionIntegration().isConnectableResource(mc)) {
                    xaResource = txCM.getTransactionIntegration().createConnectableXAResourceWrapper(mc.getXAResource(), padXid, isSameRMOverride, eisProductName, eisProductVersion, jndiName, mc, (XAResourceStatistics)this.statistics);
                }
            }
            if (xaResource == null) {
                XAResource xar = mc.getXAResource();
                if (!(xar instanceof XAResourceWrapper)) {
                    boolean firstResource = txCM.getTransactionIntegration().isFirstResource(mc);
                    xaResource = txCM.getTransactionIntegration().createXAResourceWrapper(xar, padXid, isSameRMOverride, eisProductName, eisProductVersion, jndiName, firstResource, this.statistics);
                } else {
                    xaResource = xar;
                }
            }
        } else {
            xaResource = mc.getXAResource();
        }
        return xaResource;
    }

    @Override
    public void prefill() {
        if (this.isShutdown()) {
            return;
        }
        if (this.poolConfiguration.isPrefill()) {
            ManagedConnectionPool mcp = this.pools.get(this.getPrefillCredential());
            if (mcp == null) {
                this.getManagedConnectionPool(this.getPrefillCredential());
            } else {
                mcp.prefill();
            }
        }
    }

    @Override
    public Credential getPrefillCredential() {
        if (this.prefillCredential == null) {
            this.prefillCredential = this.cm.getSubjectFactory() == null || this.cm.getConnectionManagerConfiguration().getSecurityDomain() == null ? new Credential(null, null) : new Credential(SecurityActions.createSubject(this.cm.getSubjectFactory(), this.cm.getConnectionManagerConfiguration().getSecurityDomain(), this.cm.getManagedConnectionFactory()), null);
        }
        return this.prefillCredential;
    }

    @Override
    public void emptyManagedConnectionPool(ManagedConnectionPool mcp) {
        if (this.pools.values().remove(mcp)) {
            mcp.shutdown();
            if (Tracer.isEnabled()) {
                Tracer.destroyManagedConnectionPool(this.poolConfiguration.getId(), mcp);
            }
        }
    }

    @Override
    public FlushStrategy getFlushStrategy() {
        return this.flushStrategy;
    }

    @Override
    public void flush() {
        this.flush(FlushMode.IDLE);
    }

    @Override
    public synchronized void flush(FlushMode mode) {
        if (this.isShutdown()) {
            return;
        }
        for (Credential credential : this.pools.keySet()) {
            ManagedConnectionPool mcp = this.pools.get(credential);
            if (mcp == null) continue;
            mcp.flush(mode);
            if (!mcp.isEmpty() || this.poolConfiguration.isPrefill()) continue;
            mcp.shutdown();
            this.pools.remove(credential);
            if (!Tracer.isEnabled()) continue;
            Tracer.destroyManagedConnectionPool(this.poolConfiguration.getId(), mcp);
        }
    }

    @Override
    public boolean testConnection() {
        return this.internalTestConnection(this.getPrefillCredential());
    }

    @Override
    public boolean testConnection(ConnectionRequestInfo cri, Subject subject) {
        return this.internalTestConnection(new Credential(subject, cri));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean internalTestConnection(Credential credential) {
        boolean result = false;
        boolean kill = false;
        ConnectionListener cl = null;
        if (this.isShutdown()) {
            return false;
        }
        if (this.isFull()) {
            return false;
        }
        try {
            ManagedConnectionPool mcp = this.getManagedConnectionPool(credential);
            cl = mcp.getConnectionListener();
            result = true;
        }
        catch (Throwable t) {
            kill = true;
        }
        finally {
            if (cl != null) {
                try {
                    this.returnConnectionListener(cl, kill);
                }
                catch (ResourceException mcp) {}
            }
        }
        return result;
    }

    @Override
    public void enlist(ManagedConnection mc) throws ResourceException {
        if (this.cm.getTransactionSupport() == TransactionSupport.TransactionSupportLevel.NoTransaction) {
            return;
        }
        ConnectionListener cl = this.findConnectionListener(mc, null);
        if (cl != null) {
            if (cl.isEnlisted()) {
                throw new ResourceException();
            }
            try {
                TransactionalConnectionManager txCM = (TransactionalConnectionManager)this.cm;
                Transaction tx = txCM.getTransactionIntegration().getTransactionManager().getTransaction();
                if (TxUtils.isUncommitted(tx)) {
                    ConnectionListener existing;
                    HashMap<ManagedConnectionPool, ConnectionListener> map;
                    Object id = txCM.getTransactionIntegration().getTransactionSynchronizationRegistry().getTransactionKey();
                    HashMap<ManagedConnectionPool, ConnectionListener> currentMap = this.transactionMap.get(id);
                    if (currentMap == null && (currentMap = (HashMap<ManagedConnectionPool, ConnectionListener>)this.transactionMap.putIfAbsent(id, map = new HashMap<ManagedConnectionPool, ConnectionListener>())) == null) {
                        currentMap = map;
                    }
                    if ((existing = currentMap.get(cl.getManagedConnectionPool())) == null) {
                        if (TxUtils.isActive(tx)) {
                            cl.enlist();
                            currentMap.put(cl.getManagedConnectionPool(), cl);
                            txCM.getTransactionIntegration().getTransactionSynchronizationRegistry().registerInterposedSynchronization((Synchronization)new TransactionMapCleanup(id, this.transactionMap));
                        }
                        throw new ResourceException();
                    }
                    log.tracef("Already a connection listener in the pool tracked by transaction=%s (existing=%s)", id, (Object)existing);
                    if (existing.equals(cl)) {
                        if (TxUtils.isActive(tx)) {
                            cl.enlist();
                        }
                        throw new ResourceException();
                    }
                    throw new ResourceException();
                }
                throw new ResourceException();
            }
            catch (ResourceException re) {
                throw re;
            }
            catch (Throwable t) {
                throw new ResourceException(t);
            }
        } else {
            throw new ResourceException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void delist(ConnectionListener cl) throws ResourceException {
        if (this.cm.getTransactionSupport() == TransactionSupport.TransactionSupportLevel.NoTransaction) {
            return;
        }
        if (cl == null) throw new ResourceException();
        try {
            TransactionalConnectionManager txCM = (TransactionalConnectionManager)this.cm;
            Transaction tx = txCM.getTransactionIntegration().getTransactionManager().getTransaction();
            if (!TxUtils.isUncommitted(tx)) return;
            try {
                cl.delist();
                return;
            }
            finally {
                Object id = txCM.getTransactionIntegration().getTransactionSynchronizationRegistry().getTransactionKey();
                Map<ManagedConnectionPool, ConnectionListener> currentMap = this.transactionMap.get(id);
                if (currentMap != null) {
                    ConnectionListener registered = currentMap.remove(cl.getManagedConnectionPool());
                    this.transactionMap.put(id, currentMap);
                }
            }
        }
        catch (ResourceException re) {
            throw re;
        }
        catch (Exception e) {
            throw new ResourceException((Throwable)e);
        }
    }

    @Override
    public ConnectionListener findConnectionListener(ManagedConnection mc, Object c) {
        for (ManagedConnectionPool mcp : this.pools.values()) {
            ConnectionListener cl = mcp.findConnectionListener(mc, c);
            if (cl == null) continue;
            return cl;
        }
        return null;
    }

    @Override
    public ConnectionListener removeConnectionListener(Credential credential) {
        if (credential == null) {
            for (ManagedConnectionPool mcp : this.pools.values()) {
                ConnectionListener cl = mcp.removeConnectionListener(true);
                if (cl == null) continue;
                return cl;
            }
        } else {
            ManagedConnectionPool mcp = this.pools.get(credential);
            if (mcp != null) {
                return mcp.removeConnectionListener(false);
            }
        }
        return null;
    }

    @Override
    public ConnectionListener getActiveConnectionListener(Credential credential) {
        if (this.cm.getTransactionSupport() == TransactionSupport.TransactionSupportLevel.NoTransaction) {
            return null;
        }
        try {
            TransactionalConnectionManager txCM = (TransactionalConnectionManager)this.cm;
            Transaction tx = txCM.getTransactionIntegration().getTransactionManager().getTransaction();
            if (TxUtils.isUncommitted(tx)) {
                Object id = txCM.getTransactionIntegration().getTransactionSynchronizationRegistry().getTransactionKey();
                Map<ManagedConnectionPool, ConnectionListener> currentMap = this.transactionMap.get(id);
                ManagedConnectionPool key = this.pools.get(credential);
                return currentMap.get(key);
            }
        }
        catch (Exception e) {
            log.tracef((Throwable)e, "getActiveConnectionListener(%s)", (Object)credential);
        }
        return null;
    }

    @Override
    public Capacity getCapacity() {
        if (this.capacity == null) {
            return DefaultCapacity.INSTANCE;
        }
        return this.capacity;
    }

    @Override
    public void setCapacity(Capacity c) {
        this.capacity = c;
    }

    @Override
    public boolean isFIFO() {
        return this.capacity != null && this.capacity.getDecrementer() != null && !TimedOutDecrementer.class.getName().equals(this.capacity.getDecrementer().getClass().getName());
    }
}

