/*
 * Decompiled with CFR 0.152.
 */
package org.ironjacamar.core.connectionmanager.pool;

import java.util.Comparator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.ironjacamar.core.CoreLogger;
import org.ironjacamar.core.connectionmanager.pool.ManagedConnectionPool;
import org.ironjacamar.core.connectionmanager.pool.SecurityActions;
import org.jboss.logging.Logger;

public class ConnectionValidator {
    private static CoreLogger log = (CoreLogger)Logger.getMessageLogger(CoreLogger.class, (String)ConnectionValidator.class.getName());
    private static final String THREAD_NAME = "IronJacamar ConnectionValidator";
    private static ConnectionValidator instance = new ConnectionValidator();
    private TreeMap<Key, ManagedConnectionPool> registeredPools = new TreeMap(new KeyComparator());
    private ExecutorService executorService = null;
    private boolean isExternal = false;
    private long interval = Long.MAX_VALUE;
    private long next = Long.MAX_VALUE;
    private AtomicBoolean shutdown = new AtomicBoolean(false);
    private Lock lock = new ReentrantLock(true);
    private Condition condition = this.lock.newCondition();

    private ConnectionValidator() {
    }

    public static ConnectionValidator getInstance() {
        return instance;
    }

    public void setExecutorService(ExecutorService v) {
        if (v != null) {
            this.executorService = v;
            this.isExternal = true;
        } else {
            this.executorService = null;
            this.isExternal = false;
        }
    }

    public void start() throws Throwable {
        if (!this.isExternal) {
            this.executorService = Executors.newSingleThreadExecutor(new ValidatorThreadFactory());
        }
        this.shutdown.set(false);
        this.interval = Long.MAX_VALUE;
        this.next = Long.MAX_VALUE;
        this.executorService.execute(new ConnectionValidatorRunner());
    }

    public void stop() throws Throwable {
        this.shutdown.set(true);
        if (!this.isExternal && this.executorService != null) {
            this.executorService.shutdownNow();
            this.executorService = null;
        }
        this.registeredPools.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerPool(ManagedConnectionPool mcp, long mcpInterval) {
        try {
            this.lock.lock();
            TreeMap<Key, ManagedConnectionPool> treeMap = this.registeredPools;
            synchronized (treeMap) {
                this.registeredPools.put(new Key(System.identityHashCode(mcp), System.currentTimeMillis(), mcpInterval), mcp);
            }
            if (mcpInterval > 1L && mcpInterval / 2L < this.interval) {
                this.interval /= 2L;
                long maybeNext = System.currentTimeMillis() + this.interval;
                if (this.next > maybeNext && maybeNext > 0L) {
                    this.next = maybeNext;
                    this.condition.signal();
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterPool(ManagedConnectionPool mcp) {
        TreeMap<Key, ManagedConnectionPool> treeMap = this.registeredPools;
        synchronized (treeMap) {
            this.registeredPools.values().remove(mcp);
            if (this.registeredPools.size() == 0) {
                this.interval = Long.MAX_VALUE;
            }
        }
    }

    private static class KeyComparator
    implements Comparator<Key> {
        @Override
        public int compare(Key k1, Key k2) {
            long t2;
            long t1 = k1.timestamp + k1.interval / 2L;
            if (t1 < (t2 = k2.timestamp + k2.interval / 2L)) {
                return -1;
            }
            if (t1 > t2) {
                return 1;
            }
            if (k1.id != -1 && k2.id != -1) {
                if (k1.id < k2.id) {
                    return -1;
                }
                if (k1.id > k2.id) {
                    return 1;
                }
            } else {
                if (k1.id == -1) {
                    return 1;
                }
                return -1;
            }
            return 0;
        }

        public int hashCode() {
            return 42;
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            return o != null && o instanceof KeyComparator;
        }
    }

    private static class Key {
        private int id;
        private long timestamp;
        private long interval;

        public Key(long timestamp) {
            this(-1, timestamp, 0L);
        }

        public Key(int id, long timestamp, long interval) {
            this.id = id;
            this.timestamp = timestamp;
            this.interval = interval;
        }

        public void update() {
            this.timestamp = System.currentTimeMillis();
        }

        public int hashCode() {
            int hash = 7;
            hash += 7 * this.id;
            hash += (int)(7L * this.timestamp);
            return hash += (int)(7L * this.interval);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o == null || !(o instanceof Key)) {
                return false;
            }
            Key k = (Key)o;
            return this.id == k.id;
        }

        public String toString() {
            return "[" + Integer.toHexString(this.id) + "," + this.timestamp + "," + this.interval + "]";
        }
    }

    private class ConnectionValidatorRunner
    implements Runnable {
        private ConnectionValidatorRunner() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ClassLoader oldTccl = SecurityActions.getThreadContextClassLoader();
            SecurityActions.setThreadContextClassLoader(ConnectionValidator.class.getClassLoader());
            try {
                ConnectionValidator.this.lock.lock();
                while (!ConnectionValidator.this.shutdown.get()) {
                    boolean result = instance.condition.await(instance.interval, TimeUnit.MILLISECONDS);
                    NavigableMap entries = ConnectionValidator.this.registeredPools.headMap(new Key(System.currentTimeMillis()), true);
                    for (Map.Entry entry : entries.entrySet()) {
                        ((ManagedConnectionPool)entry.getValue()).validateConnections();
                        ((Key)entry.getKey()).update();
                    }
                    ConnectionValidator.this.next = System.currentTimeMillis() + ConnectionValidator.this.interval;
                    if (ConnectionValidator.this.next >= 0L) continue;
                    ConnectionValidator.this.next = Long.MAX_VALUE;
                }
            }
            catch (InterruptedException e) {
                if (!ConnectionValidator.this.shutdown.get()) {
                    log.returningConnectionValidatorInterrupted();
                }
            }
            catch (RuntimeException e) {
                log.connectionValidatorIgnoredUnexpectedRuntimeException(e);
            }
            catch (Exception e) {
                log.connectionValidatorIgnoredUnexpectedError(e);
            }
            finally {
                ConnectionValidator.this.lock.unlock();
                SecurityActions.setThreadContextClassLoader(oldTccl);
            }
        }
    }

    private static class ValidatorThreadFactory
    implements ThreadFactory {
        private ValidatorThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r, ConnectionValidator.THREAD_NAME);
            thread.setDaemon(true);
            return thread;
        }
    }
}

