/*
 * Decompiled with CFR 0.152.
 */
package org.ironjacamar.core.connectionmanager.pool;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ServiceLoader;
import org.ironjacamar.core.api.connectionmanager.pool.PoolConfiguration;
import org.ironjacamar.core.connectionmanager.ConnectionManager;
import org.ironjacamar.core.connectionmanager.pool.Pool;
import org.ironjacamar.core.connectionmanager.pool.dflt.DefaultPool;
import org.ironjacamar.core.connectionmanager.pool.stable.StablePool;

public class PoolFactory {
    private static Map<String, Class<? extends Pool>> customPoolTypes = new HashMap<String, Class<? extends Pool>>();

    private PoolFactory() {
    }

    public static Pool createPool(String type, ConnectionManager cm, PoolConfiguration pc) {
        if (type == null || type.equals("")) {
            return new DefaultPool(cm, pc);
        }
        switch (type = type.toLowerCase(Locale.US)) {
            case "default": {
                return new DefaultPool(cm, pc);
            }
            case "stable": {
                return new StablePool(cm, pc);
            }
        }
        Class<? extends Pool> clz = customPoolTypes.get(type);
        if (clz == null) {
            throw new RuntimeException(type + " can not be found");
        }
        try {
            Constructor<? extends Pool> constructor = clz.getConstructor(ConnectionManager.class, PoolConfiguration.class);
            return constructor.newInstance(cm, pc);
        }
        catch (Exception e) {
            throw new RuntimeException(type + " can not be created", e);
        }
    }

    static {
        ServiceLoader<Pool> sl = ServiceLoader.load(Pool.class, PoolFactory.class.getClassLoader());
        try {
            for (Pool p : sl) {
                customPoolTypes.put(p.getType(), p.getClass());
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Exception during loading of pool services", e);
        }
    }
}

