/*
 * Decompiled with CFR 0.152.
 */
package org.ironjacamar.core.connectionmanager.pool;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Set;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;
import org.ironjacamar.core.spi.security.SubjectFactory;

class SecurityActions {
    private SecurityActions() {
    }

    static String getSystemProperty(final String name) {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(name);
            }
        });
    }

    static ClassLoader getClassLoader(final Class<?> c) {
        if (System.getSecurityManager() == null) {
            return c.getClassLoader();
        }
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return c.getClassLoader();
            }
        });
    }

    public static ClassLoader getThreadContextClassLoader() {
        if (System.getSecurityManager() == null) {
            return Thread.currentThread().getContextClassLoader();
        }
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }

    public static void setThreadContextClassLoader(final ClassLoader cl) {
        if (System.getSecurityManager() == null) {
            Thread.currentThread().setContextClassLoader(cl);
        } else {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    Thread.currentThread().setContextClassLoader(cl);
                    return null;
                }
            });
        }
    }

    static Subject createSubject(final SubjectFactory subjectFactory, final String domain, final ManagedConnectionFactory mcf) {
        if (System.getSecurityManager() == null) {
            Subject subject = subjectFactory.createSubject(domain);
            Set<PasswordCredential> s = SecurityActions.getPasswordCredentials(subject);
            if (s != null && !s.isEmpty()) {
                for (PasswordCredential pc : s) {
                    pc.setManagedConnectionFactory(mcf);
                }
            }
            return subject;
        }
        return AccessController.doPrivileged(new PrivilegedAction<Subject>(){

            @Override
            public Subject run() {
                Subject subject = subjectFactory.createSubject(domain);
                Set<PasswordCredential> s = SecurityActions.getPasswordCredentials(subject);
                if (s != null && !s.isEmpty()) {
                    for (PasswordCredential pc : s) {
                        pc.setManagedConnectionFactory(mcf);
                    }
                }
                return subject;
            }
        });
    }

    static Set<PasswordCredential> getPasswordCredentials(final Subject subject) {
        if (System.getSecurityManager() == null) {
            return subject.getPrivateCredentials(PasswordCredential.class);
        }
        return AccessController.doPrivileged(new PrivilegedAction<Set<PasswordCredential>>(){

            @Override
            public Set<PasswordCredential> run() {
                return subject.getPrivateCredentials(PasswordCredential.class);
            }
        });
    }

    static int hashCode(final Subject subject) {
        if (System.getSecurityManager() == null) {
            return subject != null ? subject.hashCode() : 0;
        }
        Integer hashCode = AccessController.doPrivileged(new PrivilegedAction<Integer>(){

            @Override
            public Integer run() {
                return subject != null ? subject.hashCode() : 0;
            }
        });
        return hashCode;
    }

    static boolean equals(final Subject s1, final Subject s2) {
        if (System.getSecurityManager() == null) {
            return s1 != null ? s1.equals(s2) : s2 == null;
        }
        Boolean equals = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return s1 != null ? s1.equals(s2) : s2 == null;
            }
        });
        return equals;
    }

    static StackTraceElement[] getStackTrace(final Thread t) {
        if (System.getSecurityManager() == null) {
            return t.getStackTrace();
        }
        return AccessController.doPrivileged(new PrivilegedAction<StackTraceElement[]>(){

            @Override
            public StackTraceElement[] run() {
                return t.getStackTrace();
            }
        });
    }
}

