/*
 * Decompiled with CFR 0.152.
 */
package org.ironjacamar.core.connectionmanager.pool.capacity;

import java.util.Map;
import org.ironjacamar.common.api.metadata.common.Extension;
import org.ironjacamar.core.CoreLogger;
import org.ironjacamar.core.api.connectionmanager.pool.CapacityDecrementer;
import org.ironjacamar.core.api.connectionmanager.pool.CapacityIncrementer;
import org.ironjacamar.core.connectionmanager.pool.Capacity;
import org.ironjacamar.core.connectionmanager.pool.capacity.DefaultCapacity;
import org.ironjacamar.core.connectionmanager.pool.capacity.ExplicitCapacity;
import org.ironjacamar.core.connectionmanager.pool.capacity.MinPoolSizeDecrementer;
import org.ironjacamar.core.connectionmanager.pool.capacity.SizeDecrementer;
import org.ironjacamar.core.connectionmanager.pool.capacity.TimedOutDecrementer;
import org.ironjacamar.core.connectionmanager.pool.capacity.TimedOutFIFODecrementer;
import org.ironjacamar.core.spi.classloading.ClassLoaderPlugin;
import org.ironjacamar.core.util.Injection;
import org.jboss.logging.Logger;

public class CapacityFactory {
    private static CoreLogger log = (CoreLogger)Logger.getMessageLogger(CoreLogger.class, (String)CapacityFactory.class.getName());

    private CapacityFactory() {
    }

    public static Capacity create(org.ironjacamar.common.api.metadata.common.Capacity metadata, ClassLoaderPlugin classLoaderPlugin) {
        if (metadata == null) {
            return DefaultCapacity.INSTANCE;
        }
        CapacityIncrementer incrementer = null;
        CapacityDecrementer decrementer = null;
        if (metadata.getIncrementer() != null && metadata.getIncrementer().getClassName() != null) {
            incrementer = CapacityFactory.loadIncrementer(metadata.getIncrementer(), classLoaderPlugin);
            if (incrementer != null) {
                CapacityFactory.injectProperties(metadata.getIncrementer().getConfigPropertiesMap(), incrementer);
            } else {
                log.invalidCapacityIncrementer(metadata.getIncrementer().getClassName());
            }
        }
        if (incrementer == null) {
            incrementer = DefaultCapacity.DEFAULT_INCREMENTER;
        }
        if (metadata.getDecrementer() != null && metadata.getDecrementer().getClassName() != null) {
            decrementer = CapacityFactory.loadDecrementer(metadata.getDecrementer(), classLoaderPlugin);
            if (decrementer != null) {
                CapacityFactory.injectProperties(metadata.getDecrementer().getConfigPropertiesMap(), decrementer);
            } else if (TimedOutDecrementer.class.getName().equals(metadata.getDecrementer().getClassName()) || TimedOutFIFODecrementer.class.getName().equals(metadata.getDecrementer().getClassName()) || MinPoolSizeDecrementer.class.getName().equals(metadata.getDecrementer().getClassName()) || SizeDecrementer.class.getName().equals(metadata.getDecrementer().getClassName())) {
                decrementer = CapacityFactory.loadDecrementer(metadata.getDecrementer(), classLoaderPlugin);
                CapacityFactory.injectProperties(metadata.getDecrementer().getConfigPropertiesMap(), decrementer);
            } else {
                log.invalidCapacityDecrementer(metadata.getDecrementer().getClassName());
            }
        }
        if (decrementer == null) {
            decrementer = DefaultCapacity.DEFAULT_DECREMENTER;
        }
        return new ExplicitCapacity(incrementer, decrementer);
    }

    private static void injectProperties(Map<String, String> properties, Object decrementer) {
        if (!properties.isEmpty()) {
            Injection injector = new Injection();
            for (Map.Entry<String, String> property : properties.entrySet()) {
                try {
                    injector.inject(decrementer, property.getKey(), property.getValue());
                }
                catch (Throwable t) {
                    log.invalidCapacityOption(property.getKey(), property.getValue(), decrementer.getClass().getName());
                }
            }
        }
    }

    private static CapacityIncrementer loadIncrementer(Extension incrementer, ClassLoaderPlugin classLoaderPlugin) {
        Object result = CapacityFactory.loadExtension(incrementer, classLoaderPlugin);
        if (result != null && result instanceof CapacityIncrementer) {
            return (CapacityIncrementer)result;
        }
        log.debugf("%s wasn't a CapacityIncrementer", incrementer.getClassName());
        return null;
    }

    private static CapacityDecrementer loadDecrementer(Extension decrementer, ClassLoaderPlugin classLoaderPlugin) {
        Object result = CapacityFactory.loadExtension(decrementer, classLoaderPlugin);
        if (result != null && result instanceof CapacityDecrementer) {
            return (CapacityDecrementer)result;
        }
        log.debugf("%s wasn't a CapacityDecrementer", decrementer.getClassName());
        return null;
    }

    private static Object loadExtension(Extension extension, ClassLoaderPlugin classLoaderPlugin) {
        try {
            Class<?> c = classLoaderPlugin.loadClass(extension.getClassName(), extension.getModuleName(), extension.getModuleSlot());
            return c.newInstance();
        }
        catch (Throwable t) {
            log.tracef("Throwable while loading %s using own classloader: %s", extension.getClassName(), t.getMessage());
            return null;
        }
    }
}

