/*
 * Decompiled with CFR 0.152.
 */
package org.ironjacamar.core.connectionmanager.pool.dflt;

import java.util.Iterator;
import java.util.concurrent.ConcurrentLinkedDeque;
import javax.resource.ResourceException;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.ValidatingManagedConnectionFactory;
import org.ironjacamar.core.api.connectionmanager.pool.CapacityDecrementer;
import org.ironjacamar.core.api.connectionmanager.pool.FlushMode;
import org.ironjacamar.core.connectionmanager.Credential;
import org.ironjacamar.core.connectionmanager.listener.ConnectionListener;
import org.ironjacamar.core.connectionmanager.pool.AbstractManagedConnectionPool;
import org.ironjacamar.core.connectionmanager.pool.CapacityFiller;
import org.ironjacamar.core.connectionmanager.pool.CapacityRequest;
import org.ironjacamar.core.connectionmanager.pool.ConnectionValidator;
import org.ironjacamar.core.connectionmanager.pool.FillRequest;
import org.ironjacamar.core.connectionmanager.pool.IdleConnectionRemover;
import org.ironjacamar.core.connectionmanager.pool.ManagedConnectionPoolUtility;
import org.ironjacamar.core.connectionmanager.pool.PoolFiller;
import org.ironjacamar.core.connectionmanager.pool.capacity.DefaultCapacity;
import org.ironjacamar.core.connectionmanager.pool.capacity.TimedOutDecrementer;
import org.ironjacamar.core.connectionmanager.pool.capacity.TimedOutFIFODecrementer;
import org.ironjacamar.core.connectionmanager.pool.dflt.DefaultPool;
import org.ironjacamar.core.tracer.Tracer;

public class DefaultManagedConnectionPool
extends AbstractManagedConnectionPool {
    private DefaultPool pool;
    private ConcurrentLinkedDeque<ConnectionListener> listeners;

    public DefaultManagedConnectionPool(DefaultPool pool, Credential credential) {
        super(pool, credential);
        this.pool = pool;
        this.listeners = new ConcurrentLinkedDeque();
        if (credential.equals(pool.getPrefillCredential()) && pool.getConfiguration().isPrefill() && pool.getConfiguration().getInitialSize() > 0) {
            PoolFiller.fillPool(new FillRequest(this, pool.getConfiguration().getInitialSize()));
        }
        if (pool.getConfiguration().isBackgroundValidation() && pool.getConfiguration().getBackgroundValidationMillis() > 0L) {
            ConnectionValidator.getInstance().registerPool(this, pool.getConfiguration().getBackgroundValidationMillis());
        }
        if (pool.getConfiguration().getIdleTimeoutMinutes() > 0) {
            IdleConnectionRemover.getInstance().registerPool(this, (long)(pool.getConfiguration().getIdleTimeoutMinutes() * 60) * 1000L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConnectionListener getConnectionListener() throws ResourceException {
        if (this.pool.getLogger().isTraceEnabled()) {
            DefaultManagedConnectionPool defaultManagedConnectionPool = this;
            synchronized (defaultManagedConnectionPool) {
                this.pool.getLogger().trace(ManagedConnectionPoolUtility.fullDetails(this, "getConnectionListener()", this.pool.getConnectionManager().getManagedConnectionFactory(), this.pool.getConnectionManager(), this.pool, this.pool.getConfiguration(), this.listeners, this.pool.getInternalStatistics(), this.credential.getSubject(), this.credential.getConnectionRequestInfo()));
            }
        } else if (this.pool.getLogger().isDebugEnabled()) {
            this.pool.getLogger().debug(ManagedConnectionPoolUtility.details("getConnectionListener()", this.pool.getConfiguration().getId(), this.getCount(2, this.listeners), this.pool.getConfiguration().getMaxSize()));
        }
        long timestamp = System.currentTimeMillis();
        while (System.currentTimeMillis() - timestamp <= this.pool.getConfiguration().getBlockingTimeout()) {
            ConnectionListener cl;
            Iterator<ConnectionListener> listenersIterator;
            Iterator<ConnectionListener> iterator = listenersIterator = this.poolIsFifo ? this.listeners.iterator() : this.listeners.descendingIterator();
            while (listenersIterator.hasNext()) {
                cl = listenersIterator.next();
                if (!cl.changeState(1, 6)) continue;
                if (this.pool.getInternalStatistics().isEnabled()) {
                    this.pool.getInternalStatistics().deltaTotalBlockingTime(System.currentTimeMillis() - timestamp);
                }
                if (this.pool.getConfiguration().isValidateOnMatch()) {
                    ConnectionListener result = this.validateConnectionListener(this.listeners, cl, 2);
                    if (result != null) {
                        if (Tracer.isEnabled()) {
                            Tracer.getConnectionListener(this.pool.getConfiguration().getId(), this, result, true, false, Tracer.isRecordCallstacks() ? new Throwable("CALLSTACK") : null);
                        }
                        if (this.pool.getJanitor().isRecording()) {
                            this.pool.getJanitor().registerConnectionListener(result);
                        }
                        result.fromPool();
                        if (this.pool.getInternalStatistics().isEnabled()) {
                            this.pool.getInternalStatistics().deltaInUseCount(1);
                            this.pool.getInternalStatistics().deltaTotalGetTime(result.getFromPool() - timestamp);
                            this.pool.getInternalStatistics().deltaTotalPoolTime(result.getFromPool() - result.getToPool());
                        }
                        return result;
                    }
                    if (Tracer.isEnabled()) {
                        Tracer.destroyConnectionListener(this.pool.getConfiguration().getId(), this, cl, false, false, true, false, false, false, false, Tracer.isRecordCallstacks() ? new Throwable("CALLSTACK") : null);
                    }
                    if (!this.pool.getConfiguration().isUseFastFail()) continue;
                    break;
                }
                if (cl.changeState(6, 2)) {
                    if (Tracer.isEnabled()) {
                        Tracer.getConnectionListener(this.pool.getConfiguration().getId(), this, cl, true, false, Tracer.isRecordCallstacks() ? new Throwable("CALLSTACK") : null);
                    }
                    if (this.pool.getJanitor().isRecording()) {
                        this.pool.getJanitor().registerConnectionListener(cl);
                    }
                    cl.fromPool();
                    if (this.pool.getInternalStatistics().isEnabled()) {
                        this.pool.getInternalStatistics().deltaInUseCount(1);
                        this.pool.getInternalStatistics().deltaTotalGetTime(cl.getFromPool() - timestamp);
                        this.pool.getInternalStatistics().deltaTotalPoolTime(cl.getFromPool() - cl.getToPool());
                    }
                    return cl;
                }
                if (Tracer.isEnabled()) {
                    Tracer.destroyConnectionListener(this.pool.getConfiguration().getId(), this, cl, false, false, false, false, true, false, false, Tracer.isRecordCallstacks() ? new Throwable("CALLSTACK") : null);
                }
                this.destroyAndRemoveConnectionListener(cl, this.listeners);
            }
            if (!this.pool.isFull()) {
                try {
                    cl = this.pool.createConnectionListener(this.credential, this);
                    if (Tracer.isEnabled()) {
                        Tracer.createConnectionListener(this.pool.getConfiguration().getId(), this, cl, cl.getManagedConnection(), true, false, false, Tracer.isRecordCallstacks() ? new Throwable("CALLSTACK") : null);
                    }
                    this.listeners.addFirst(cl);
                }
                catch (ResourceException re) {
                    throw re;
                }
                finally {
                    this.prefill();
                    if (this.pool.getCapacity().getIncrementer() != null) {
                        CapacityFiller.schedule(new CapacityRequest(this));
                    }
                }
            } else if (this.pool.getInternalStatistics().isEnabled()) {
                this.pool.getInternalStatistics().deltaWaitCount();
            }
            Thread.yield();
        }
        if (this.pool.getInternalStatistics().isEnabled()) {
            this.pool.getInternalStatistics().deltaBlockingFailureCount();
        }
        throw new ResourceException("No ConnectionListener");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void returnConnectionListener(ConnectionListener cl, boolean kill) throws ResourceException {
        if (this.pool.getLogger().isTraceEnabled()) {
            DefaultManagedConnectionPool defaultManagedConnectionPool = this;
            synchronized (defaultManagedConnectionPool) {
                this.pool.getLogger().trace(ManagedConnectionPoolUtility.fullDetails(this, "returnConnectionListener(" + Integer.toHexString(System.identityHashCode(cl)) + ", " + kill + ")", this.pool.getConnectionManager().getManagedConnectionFactory(), this.pool.getConnectionManager(), this.pool, this.pool.getConfiguration(), this.listeners, this.pool.getInternalStatistics(), this.credential.getSubject(), this.credential.getConnectionRequestInfo()));
            }
        } else if (this.pool.getLogger().isDebugEnabled()) {
            this.pool.getLogger().debug(ManagedConnectionPoolUtility.details("returnConnectionListener(" + Integer.toHexString(System.identityHashCode(cl)) + ", " + kill + ")", this.pool.getConfiguration().getId(), this.getCount(2, this.listeners), this.pool.getConfiguration().getMaxSize()));
        }
        if (this.pool.getJanitor().isRecording()) {
            this.pool.getJanitor().unregisterConnectionListener(cl);
        }
        if (cl.getState() != 4 && this.pool.getInternalStatistics().isEnabled()) {
            this.pool.getInternalStatistics().deltaInUseCount(-1);
            this.pool.getInternalStatistics().deltaTotalUsageTime(System.currentTimeMillis() - cl.getFromPool());
        }
        if (!kill) {
            if (cl.changeState(2, 5)) {
                try {
                    cl.getManagedConnection().cleanup();
                    cl.toPool();
                    if (!cl.changeState(5, 1)) {
                        kill = true;
                    }
                }
                catch (ResourceException re) {
                    kill = true;
                }
            } else {
                kill = true;
            }
        }
        if (kill && cl.getState() != 4) {
            try {
                if (Tracer.isEnabled()) {
                    Tracer.destroyConnectionListener(this.pool.getConfiguration().getId(), this, cl, true, false, false, false, false, false, false, Tracer.isRecordCallstacks() ? new Throwable("CALLSTACK") : null);
                }
                this.pool.destroyConnectionListener(cl);
            }
            finally {
                this.listeners.remove(cl);
            }
        }
    }

    @Override
    public synchronized void shutdown() {
        if (this.pool.getConfiguration().isBackgroundValidation() && this.pool.getConfiguration().getBackgroundValidationMillis() > 0L) {
            ConnectionValidator.getInstance().unregisterPool(this);
        }
        if (this.pool.getConfiguration().getIdleTimeoutMinutes() > 0) {
            IdleConnectionRemover.getInstance().unregisterPool(this);
        }
        for (ConnectionListener cl : this.listeners) {
            if (cl.getState() == 2 || cl.getState() == 3) {
                // empty if block
            }
            try {
                if (Tracer.isEnabled()) {
                    Tracer.clearConnectionListener(this.pool.getConfiguration().getId(), this, cl);
                }
                this.pool.destroyConnectionListener(cl);
            }
            catch (ResourceException re) {
                cl.setState(7);
            }
        }
        this.listeners.clear();
    }

    @Override
    public void increaseCapacity() {
        if (!this.credential.equals(this.pool.getPrefillCredential())) {
            return;
        }
        int created = 1;
        boolean create = true;
        while (create && !this.pool.isFull()) {
            if (this.pool.isShutdown()) {
                return;
            }
            int currentSize = this.listeners.size();
            create = this.pool.getCapacity().getIncrementer().shouldCreate(currentSize, this.pool.getConfiguration().getMaxSize(), created);
            if (!create) continue;
            try {
                ConnectionListener cl = this.pool.createConnectionListener(this.credential, this);
                if (Tracer.isEnabled()) {
                    Tracer.createConnectionListener(this.pool.getConfiguration().getId(), this, cl, cl.getManagedConnection(), false, false, true, Tracer.isRecordCallstacks() ? new Throwable("CALLSTACK") : null);
                }
                boolean added = false;
                if (this.listeners.size() < this.pool.getConfiguration().getMaxSize()) {
                    if (this.log.isTraceEnabled()) {
                        this.log.trace("Capacity fill: cl=" + cl);
                    }
                    this.listeners.add(cl);
                    ++created;
                    added = true;
                }
                if (added) continue;
                if (Tracer.isEnabled()) {
                    Tracer.destroyConnectionListener(this.pool.getConfiguration().getId(), this, cl, false, false, true, false, false, false, true, Tracer.isRecordCallstacks() ? new Throwable("CALLSTACK") : null);
                }
                this.pool.destroyConnectionListener(cl);
                return;
            }
            catch (ResourceException re) {
                this.log.unableFillPool(this.pool.getConfiguration().getId(), re);
                return;
            }
        }
    }

    @Override
    public void prefill() {
        if (this.credential.equals(this.pool.getPrefillCredential()) && this.pool.getConfiguration().isPrefill() && this.pool.getConfiguration().getMinSize() > 0 && this.listeners.size() < this.pool.getConfiguration().getMinSize()) {
            PoolFiller.fillPool(new FillRequest(this, this.pool.getConfiguration().getMinSize()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fillTo(int size) {
        if (size <= 0) {
            return;
        }
        if (this.pool.getLogger().isTraceEnabled()) {
            DefaultManagedConnectionPool defaultManagedConnectionPool = this;
            synchronized (defaultManagedConnectionPool) {
                this.pool.getLogger().trace(ManagedConnectionPoolUtility.fullDetails(this, "fillTo(" + size + ")", this.pool.getConnectionManager().getManagedConnectionFactory(), this.pool.getConnectionManager(), this.pool, this.pool.getConfiguration(), this.listeners, this.pool.getInternalStatistics(), this.credential.getSubject(), this.credential.getConnectionRequestInfo()));
            }
        } else if (this.pool.getLogger().isDebugEnabled()) {
            this.pool.getLogger().debug(ManagedConnectionPoolUtility.details("fillTo(" + size + ")", this.pool.getConfiguration().getId(), this.getCount(2, this.listeners), this.pool.getConfiguration().getMaxSize()));
        }
        while (!this.pool.isFull()) {
            if (this.pool.isShutdown()) {
                return;
            }
            if (this.listeners.size() >= size) {
                return;
            }
            try {
                ConnectionListener cl = this.pool.createConnectionListener(this.credential, this);
                if (Tracer.isEnabled()) {
                    Tracer.createConnectionListener(this.pool.getConfiguration().getId(), this, cl, cl.getManagedConnection(), false, true, false, Tracer.isRecordCallstacks() ? new Throwable("CALLSTACK") : null);
                }
                boolean added = false;
                if (this.listeners.size() < size) {
                    this.listeners.add(cl);
                    added = true;
                }
                if (added) continue;
                if (Tracer.isEnabled()) {
                    Tracer.destroyConnectionListener(this.pool.getConfiguration().getId(), this, cl, false, false, false, false, false, true, false, Tracer.isRecordCallstacks() ? new Throwable("CALLSTACK") : null);
                }
                this.pool.destroyConnectionListener(cl);
                return;
            }
            catch (ResourceException re) {
                return;
            }
        }
    }

    @Override
    public void validateConnections() {
        boolean anyDestroyed = false;
        ManagedConnectionFactory mcf = this.pool.getConnectionManager().getManagedConnectionFactory();
        if (mcf instanceof ValidatingManagedConnectionFactory) {
            ValidatingManagedConnectionFactory vcf = (ValidatingManagedConnectionFactory)mcf;
            long timestamp = System.currentTimeMillis();
            for (ConnectionListener cl : this.listeners) {
                if (!cl.changeState(1, 6)) continue;
                if (cl.getValidated() + this.pool.getConfiguration().getBackgroundValidationMillis() <= timestamp) {
                    ConnectionListener result = this.validateConnectionListener(this.listeners, cl, 1);
                    if (result != null) continue;
                    if (Tracer.isEnabled()) {
                        Tracer.destroyConnectionListener(this.pool.getConfiguration().getId(), this, cl, false, false, true, false, false, false, false, Tracer.isRecordCallstacks() ? new Throwable("CALLSTACK") : null);
                    }
                    anyDestroyed = true;
                    continue;
                }
                if (cl.changeState(6, 1)) continue;
                if (Tracer.isEnabled()) {
                    Tracer.destroyConnectionListener(this.pool.getConfiguration().getId(), this, cl, false, false, false, false, true, false, false, Tracer.isRecordCallstacks() ? new Throwable("CALLSTACK") : null);
                }
                this.destroyAndRemoveConnectionListener(cl, this.listeners);
            }
        } else {
            this.log.validateOnMatchNonCompliantManagedConnectionFactory(mcf.getClass().getName());
        }
        if (anyDestroyed) {
            this.prefill();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeIdleConnections() {
        long now = System.currentTimeMillis();
        long timeoutSetting = (long)this.pool.getConfiguration().getIdleTimeoutMinutes() * 1000L * 60L;
        CapacityDecrementer decrementer = this.pool.getCapacity().getDecrementer();
        if (decrementer == null || !this.credential.equals(this.pool.getPrefillCredential())) {
            decrementer = DefaultCapacity.DEFAULT_DECREMENTER;
        }
        if (TimedOutDecrementer.class.getName().equals(decrementer.getClass().getName()) || TimedOutFIFODecrementer.class.getName().equals(decrementer.getClass().getName()) ? now < this.lastIdleCheck + 60000L : now < this.lastIdleCheck + timeoutSetting) {
            return;
        }
        this.lastIdleCheck = now;
        long timeout = now - timeoutSetting;
        int destroyed = 0;
        if (this.pool.getLogger().isTraceEnabled()) {
            DefaultManagedConnectionPool defaultManagedConnectionPool = this;
            synchronized (defaultManagedConnectionPool) {
                this.pool.getLogger().trace(ManagedConnectionPoolUtility.fullDetails(this, "removeIdleConnections(" + timeout + ")", this.pool.getConnectionManager().getManagedConnectionFactory(), this.pool.getConnectionManager(), this.pool, this.pool.getConfiguration(), this.listeners, this.pool.getInternalStatistics(), this.credential.getSubject(), this.credential.getConnectionRequestInfo()));
            }
        } else if (this.pool.getLogger().isDebugEnabled()) {
            this.pool.getLogger().debug(ManagedConnectionPoolUtility.details("removeIdleConnections(" + timeout + ")", this.pool.getConfiguration().getId(), this.getCount(2, this.listeners), this.pool.getConfiguration().getMaxSize()));
        }
        for (ConnectionListener cl : this.listeners) {
            if (!cl.changeState(1, 6)) continue;
            if (decrementer.shouldDestroy(cl, timeout, this.listeners.size(), this.pool.getConfiguration().getMinSize(), destroyed)) {
                if (Tracer.isEnabled()) {
                    Tracer.destroyConnectionListener(this.pool.getConfiguration().getId(), this, cl, false, true, false, false, false, false, false, Tracer.isRecordCallstacks() ? new Throwable("CALLSTACK") : null);
                }
                if (this.pool.getInternalStatistics().isEnabled()) {
                    this.pool.getInternalStatistics().deltaTimedOut();
                }
                this.destroyAndRemoveConnectionListener(cl, this.listeners);
                ++destroyed;
                continue;
            }
            if (cl.changeState(6, 1)) continue;
            if (Tracer.isEnabled()) {
                Tracer.destroyConnectionListener(this.pool.getConfiguration().getId(), this, cl, false, false, false, false, true, false, false, Tracer.isRecordCallstacks() ? new Throwable("CALLSTACK") : null);
            }
            if (this.pool.getInternalStatistics().isEnabled()) {
                this.pool.getInternalStatistics().deltaTimedOut();
            }
            this.destroyAndRemoveConnectionListener(cl, this.listeners);
            ++destroyed;
        }
        if (!this.pool.isShutdown()) {
            boolean emptyManagedConnectionPool = false;
            if (this.credential.equals(this.pool.getPrefillCredential()) && this.pool.getConfiguration().isPrefill()) {
                if (this.pool.getConfiguration().getMinSize() > 0) {
                    this.prefill();
                } else {
                    emptyManagedConnectionPool = true;
                }
            } else {
                emptyManagedConnectionPool = true;
            }
            if (emptyManagedConnectionPool && this.listeners.isEmpty()) {
                this.pool.emptyManagedConnectionPool(this);
            }
        }
    }

    @Override
    public boolean isEmpty() {
        return this.listeners.isEmpty();
    }

    @Override
    public void flush(FlushMode mode) {
        for (ConnectionListener cl : this.listeners) {
            switch (mode) {
                case ALL: {
                    if (Tracer.isEnabled()) {
                        Tracer.destroyConnectionListener(this.pool.getConfiguration().getId(), this, cl, false, false, false, true, false, false, false, Tracer.isRecordCallstacks() ? new Throwable("CALLSTACK") : null);
                    }
                    this.destroyAndRemoveConnectionListener(cl, this.listeners);
                    break;
                }
                case INVALID: {
                    if (!cl.changeState(1, 6)) break;
                    this.validateConnectionListener(this.listeners, cl, 1);
                    break;
                }
                case IDLE: {
                    if (!cl.changeState(1, 8)) break;
                    if (Tracer.isEnabled()) {
                        Tracer.destroyConnectionListener(this.pool.getConfiguration().getId(), this, cl, false, false, false, true, false, false, false, Tracer.isRecordCallstacks() ? new Throwable("CALLSTACK") : null);
                    }
                    this.destroyAndRemoveConnectionListener(cl, this.listeners);
                    break;
                }
                case GRACEFULLY: {
                    if (cl.changeState(1, 8)) {
                        if (Tracer.isEnabled()) {
                            Tracer.destroyConnectionListener(this.pool.getConfiguration().getId(), this, cl, false, false, false, true, false, false, false, Tracer.isRecordCallstacks() ? new Throwable("CALLSTACK") : null);
                        }
                        this.destroyAndRemoveConnectionListener(cl, this.listeners);
                        break;
                    }
                    if (cl.getState() != 2 && cl.getState() != 5 && cl.getState() != 6) break;
                    cl.setState(3);
                }
            }
        }
        this.prefill();
    }

    @Override
    public ConnectionListener findConnectionListener(ManagedConnection mc, Object c) {
        return this.findConnectionListener(mc, c, this.listeners);
    }

    @Override
    public ConnectionListener removeConnectionListener(boolean free) {
        return this.removeConnectionListener(free, this.listeners);
    }
}

