/*
 * Decompiled with CFR 0.152.
 */
package org.ironjacamar.core.connectionmanager.pool.stable;

import java.util.Map;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import javax.resource.ResourceException;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.TransactionSupport;
import javax.transaction.Transaction;
import org.ironjacamar.core.CoreLogger;
import org.ironjacamar.core.api.connectionmanager.pool.PoolConfiguration;
import org.ironjacamar.core.connectionmanager.ConnectionManager;
import org.ironjacamar.core.connectionmanager.Credential;
import org.ironjacamar.core.connectionmanager.TransactionalConnectionManager;
import org.ironjacamar.core.connectionmanager.listener.ConnectionListener;
import org.ironjacamar.core.connectionmanager.listener.stable.LocalTransactionConnectionListener;
import org.ironjacamar.core.connectionmanager.listener.stable.NoTransactionConnectionListener;
import org.ironjacamar.core.connectionmanager.listener.stable.XATransactionConnectionListener;
import org.ironjacamar.core.connectionmanager.pool.AbstractPool;
import org.ironjacamar.core.connectionmanager.pool.ManagedConnectionPool;
import org.ironjacamar.core.connectionmanager.pool.stable.StableManagedConnectionPool;
import org.jboss.logging.Logger;

public class StablePool
extends AbstractPool {
    private static CoreLogger log = (CoreLogger)Logger.getMessageLogger(CoreLogger.class, (String)StablePool.class.getName());
    private Semaphore requestSemaphore;

    public StablePool(ConnectionManager cm, PoolConfiguration pc) {
        super(cm, pc);
        this.requestSemaphore = new Semaphore(pc.getMaxSize(), true);
    }

    @Override
    public String getType() {
        return "stable";
    }

    @Override
    public CoreLogger getLogger() {
        return log;
    }

    @Override
    public ConnectionListener createConnectionListener(Credential credential, ManagedConnectionPool mcp) throws ResourceException {
        try {
            if (this.semaphore.tryAcquire(this.poolConfiguration.getBlockingTimeout(), TimeUnit.MILLISECONDS)) {
                long start = this.getInternalStatistics().isEnabled() ? System.currentTimeMillis() : 0L;
                ManagedConnection mc = this.cm.getManagedConnectionFactory().createManagedConnection(credential.getSubject(), credential.getConnectionRequestInfo());
                if (this.getInternalStatistics().isEnabled()) {
                    this.getInternalStatistics().deltaCreatedCount();
                    this.getInternalStatistics().deltaTotalCreationTime(System.currentTimeMillis() - start);
                }
                if (this.cm.getTransactionSupport() == TransactionSupport.TransactionSupportLevel.NoTransaction) {
                    return new NoTransactionConnectionListener(this.cm, mc, credential, mcp, this.cm.getPool().getFlushStrategy());
                }
                if (this.cm.getTransactionSupport() == TransactionSupport.TransactionSupportLevel.LocalTransaction) {
                    return new LocalTransactionConnectionListener(this.cm, mc, credential, this.getLocalXAResource(mc), mcp, this.cm.getPool().getFlushStrategy());
                }
                return new XATransactionConnectionListener(this.cm, mc, credential, this.getXAResource(mc), this.cm.getConnectionManagerConfiguration().getXAResourceTimeout(), mcp, this.cm.getPool().getFlushStrategy());
            }
        }
        catch (ResourceException re) {
            throw re;
        }
        catch (Exception e) {
            throw new ResourceException((Throwable)e);
        }
        throw new ResourceException("No ConnectionListener");
    }

    @Override
    public void destroyConnectionListener(ConnectionListener cl) throws ResourceException {
        if (this.getInternalStatistics().isEnabled()) {
            this.getInternalStatistics().deltaDestroyedCount();
        }
        try {
            cl.getManagedConnection().destroy();
        }
        catch (Exception e) {
            throw new ResourceException((Throwable)e);
        }
        finally {
            cl.setState(4);
            this.semaphore.release();
        }
    }

    @Override
    public ManagedConnectionPool createManagedConnectionPool(Credential credential) {
        return new StableManagedConnectionPool(this, credential);
    }

    public synchronized Object verifyConnectionListener(ConnectionListener cl) throws ResourceException {
        for (Map.Entry entry : this.transactionMap.entrySet()) {
            if (!((Map)entry.getValue()).values().contains(cl)) continue;
            try {
                TransactionalConnectionManager txCM = (TransactionalConnectionManager)this.cm;
                Transaction tx = txCM.getTransactionIntegration().getTransactionManager().getTransaction();
                Object id = txCM.getTransactionIntegration().getTransactionSynchronizationRegistry().getTransactionKey();
                if (id.equals(entry.getKey())) continue;
                return entry.getKey();
            }
            catch (Exception e) {
                throw new ResourceException((Throwable)e);
            }
        }
        return null;
    }

    Semaphore getRequestSemaphore() {
        return this.requestSemaphore;
    }
}

