/*
 * Decompiled with CFR 0.152.
 */
package org.ironjacamar.core.deploymentrepository;

import java.io.Externalizable;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import javax.naming.Referenceable;
import javax.resource.spi.ResourceAdapterAssociation;
import org.ironjacamar.common.api.metadata.resourceadapter.AdminObject;
import org.ironjacamar.core.api.deploymentrepository.ConfigProperty;
import org.ironjacamar.core.deploymentrepository.DelegatorInvocationHandler;
import org.ironjacamar.core.deploymentrepository.SecurityActions;
import org.ironjacamar.core.spi.naming.JndiStrategy;
import org.ironjacamar.core.spi.statistics.StatisticsPlugin;

public class AdminObjectImpl
implements org.ironjacamar.core.api.deploymentrepository.AdminObject {
    private boolean activated = false;
    private String jndiName;
    private Object adminObject;
    private Object jndiObject;
    private Collection<ConfigProperty> configProperties;
    private AdminObject activation;
    private StatisticsPlugin statistics;
    private JndiStrategy jndiStrategy;

    public AdminObjectImpl(String jndiName, Object ao, Collection<ConfigProperty> configProperties, AdminObject activation, StatisticsPlugin statistics, JndiStrategy jndiStrategy) {
        this.jndiName = jndiName;
        this.adminObject = ao;
        this.jndiObject = null;
        this.configProperties = configProperties;
        this.activation = activation;
        this.statistics = statistics;
        this.jndiStrategy = jndiStrategy;
    }

    @Override
    public String getJndiName() {
        return this.jndiName;
    }

    @Override
    public Object getAdminObject() {
        return this.adminObject;
    }

    @Override
    public Collection<ConfigProperty> getConfigProperties() {
        return this.configProperties;
    }

    @Override
    public AdminObject getActivation() {
        return this.activation;
    }

    @Override
    public StatisticsPlugin getStatistics() {
        return this.statistics;
    }

    @Override
    public boolean isActivated() {
        return this.activated;
    }

    @Override
    public boolean activate() throws Exception {
        if (!this.activated) {
            if (this.adminObject instanceof ResourceAdapterAssociation) {
                if (!(this.adminObject instanceof Serializable) || !(this.adminObject instanceof javax.resource.Referenceable)) {
                    throw new Exception("TODO");
                }
            } else if (!(this.adminObject instanceof Referenceable)) {
                DelegatorInvocationHandler dih = new DelegatorInvocationHandler(this.adminObject);
                ArrayList interfaces = new ArrayList();
                Class<?> clz = this.adminObject.getClass();
                while (!clz.equals(Object.class)) {
                    Class<?>[] is = clz.getInterfaces();
                    if (is != null) {
                        for (Class<?> interfaceClass : is) {
                            if (interfaceClass.equals(javax.resource.Referenceable.class) || interfaceClass.equals(ResourceAdapterAssociation.class) || interfaceClass.equals(Serializable.class) || interfaceClass.equals(Externalizable.class) || interfaces.contains(interfaceClass)) continue;
                            interfaces.add(interfaceClass);
                        }
                    }
                    clz = clz.getSuperclass();
                }
                interfaces.add(Serializable.class);
                interfaces.add(javax.resource.Referenceable.class);
                this.jndiObject = Proxy.newProxyInstance(SecurityActions.getClassLoader(this.adminObject.getClass()), interfaces.toArray(new Class[interfaces.size()]), (InvocationHandler)dih);
            }
            if (this.jndiObject != null) {
                this.jndiStrategy.bind(this.jndiName, this.jndiObject);
            } else {
                this.jndiStrategy.bind(this.jndiName, this.adminObject);
            }
            this.activated = true;
            return true;
        }
        return false;
    }

    @Override
    public boolean deactivate() throws Exception {
        if (this.activated) {
            if (this.jndiObject != null) {
                this.jndiStrategy.unbind(this.jndiName, this.jndiObject);
            } else {
                this.jndiStrategy.unbind(this.jndiName, this.adminObject);
            }
            this.activated = false;
            return true;
        }
        return false;
    }
}

