/*
 * Decompiled with CFR 0.152.
 */
package org.ironjacamar.core.deploymentrepository;

import java.util.Collection;
import org.ironjacamar.common.api.metadata.resourceadapter.ConnectionDefinition;
import org.ironjacamar.core.api.connectionmanager.ConnectionManager;
import org.ironjacamar.core.api.deploymentrepository.ConfigProperty;
import org.ironjacamar.core.api.deploymentrepository.ConnectionFactory;
import org.ironjacamar.core.api.deploymentrepository.Pool;
import org.ironjacamar.core.api.deploymentrepository.Recovery;
import org.ironjacamar.core.spi.naming.JndiStrategy;
import org.ironjacamar.core.spi.statistics.StatisticsPlugin;

public class ConnectionFactoryImpl
implements ConnectionFactory {
    private boolean activated = false;
    private String jndiName;
    private Object cf;
    private Collection<ConfigProperty> configProperties;
    private ConnectionDefinition activation;
    private ConnectionManager connectionManager;
    private Pool pool;
    private StatisticsPlugin statistics;
    private Recovery recovery;
    private JndiStrategy jndiStrategy;

    public ConnectionFactoryImpl(String jndiName, Object cf, Collection<ConfigProperty> configProperties, ConnectionDefinition activation, ConnectionManager connectionManager, Pool pool, StatisticsPlugin statistics, Recovery recovery, JndiStrategy jndiStrategy) {
        this.jndiName = jndiName;
        this.cf = cf;
        this.configProperties = configProperties;
        this.activation = activation;
        this.connectionManager = connectionManager;
        this.pool = pool;
        this.statistics = statistics;
        this.recovery = recovery;
        this.jndiStrategy = jndiStrategy;
    }

    @Override
    public String getJndiName() {
        return this.jndiName;
    }

    @Override
    public Object getConnectionFactory() {
        return this.cf;
    }

    @Override
    public Collection<ConfigProperty> getConfigProperties() {
        return this.configProperties;
    }

    @Override
    public ConnectionDefinition getActivation() {
        return this.activation;
    }

    @Override
    public ConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    @Override
    public Pool getPool() {
        return this.pool;
    }

    @Override
    public StatisticsPlugin getStatistics() {
        return this.statistics;
    }

    @Override
    public Recovery getRecovery() {
        return this.recovery;
    }

    @Override
    public boolean isActivated() {
        return this.activated;
    }

    @Override
    public boolean activate() throws Exception {
        if (!this.activated) {
            this.jndiStrategy.bind(this.jndiName, this.cf);
            ((org.ironjacamar.core.connectionmanager.pool.Pool)this.pool.getPool()).prefill();
            if (this.recovery != null) {
                this.recovery.activate();
            }
            this.activated = true;
            return true;
        }
        return false;
    }

    @Override
    public boolean deactivate() throws Exception {
        if (this.activated) {
            if (this.recovery != null) {
                this.recovery.deactivate();
            }
            this.jndiStrategy.unbind(this.jndiName, this.cf);
            ((org.ironjacamar.core.connectionmanager.ConnectionManager)this.connectionManager).shutdown();
            this.activated = false;
            return true;
        }
        return false;
    }
}

