/*
 * Decompiled with CFR 0.152.
 */
package org.ironjacamar.core.deploymentrepository;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.ironjacamar.common.api.metadata.resourceadapter.Activation;
import org.ironjacamar.common.api.metadata.spec.Connector;
import org.ironjacamar.core.api.deploymentrepository.AdminObject;
import org.ironjacamar.core.api.deploymentrepository.ConnectionFactory;
import org.ironjacamar.core.api.deploymentrepository.Deployment;
import org.ironjacamar.core.api.deploymentrepository.ResourceAdapter;
import org.ironjacamar.core.deploymentrepository.DeploymentImpl;
import org.ironjacamar.core.spi.classloading.ClassLoaderPlugin;

public class DeploymentBuilder {
    private String identifier = null;
    private String name = null;
    private File archive = null;
    private ClassLoader classLoader = null;
    private Connector metadata = null;
    private Activation activation = null;
    private ResourceAdapter resourceAdapter = null;
    private Collection<ConnectionFactory> connectionFactories = null;
    private Collection<AdminObject> adminObjects = null;
    private ClassLoaderPlugin classLoaderPlugin = null;

    public String getIdentifier() {
        return this.identifier;
    }

    public DeploymentBuilder identifier(String v) {
        this.identifier = v;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public DeploymentBuilder name(String v) {
        this.name = v;
        return this;
    }

    public File getArchive() {
        return this.archive;
    }

    public DeploymentBuilder archive(File v) {
        this.archive = v;
        return this;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public DeploymentBuilder classLoader(ClassLoader v) {
        this.classLoader = v;
        return this;
    }

    public DeploymentBuilder classLoaderPlugin(ClassLoaderPlugin v) {
        this.classLoaderPlugin = v;
        return this;
    }

    public Connector getMetadata() {
        return this.metadata;
    }

    public DeploymentBuilder metadata(Connector v) {
        this.metadata = v;
        return this;
    }

    public Activation getActivation() {
        return this.activation;
    }

    public DeploymentBuilder activation(Activation v) {
        this.activation = v;
        return this;
    }

    public ResourceAdapter getResourceAdapter() {
        return this.resourceAdapter;
    }

    public DeploymentBuilder resourceAdapter(ResourceAdapter v) {
        this.resourceAdapter = v;
        return this;
    }

    public Collection<ConnectionFactory> getConnectionFactories() {
        if (this.connectionFactories == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableCollection(this.connectionFactories);
    }

    public DeploymentBuilder connectionFactory(ConnectionFactory v) {
        if (this.connectionFactories == null) {
            this.connectionFactories = new ArrayList<ConnectionFactory>();
        }
        this.connectionFactories.add(v);
        return this;
    }

    public Collection<AdminObject> getAdminObjects() {
        if (this.adminObjects == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableCollection(this.adminObjects);
    }

    public DeploymentBuilder adminObject(AdminObject v) {
        if (this.adminObjects == null) {
            this.adminObjects = new ArrayList<AdminObject>();
        }
        this.adminObjects.add(v);
        return this;
    }

    public Deployment build() {
        return new DeploymentImpl(this.identifier, this.name, this.archive, this.classLoader, this.metadata, this.activation, this.resourceAdapter, this.getConnectionFactories(), this.getAdminObjects(), this.classLoaderPlugin);
    }
}

