/*
 * Decompiled with CFR 0.152.
 */
package org.ironjacamar.core.deploymentrepository;

import java.io.File;
import java.util.Collection;
import org.ironjacamar.common.api.metadata.resourceadapter.Activation;
import org.ironjacamar.common.api.metadata.spec.Connector;
import org.ironjacamar.core.api.deploymentrepository.AdminObject;
import org.ironjacamar.core.api.deploymentrepository.ConnectionFactory;
import org.ironjacamar.core.api.deploymentrepository.Deployment;
import org.ironjacamar.core.api.deploymentrepository.ResourceAdapter;
import org.ironjacamar.core.spi.classloading.ClassLoaderPlugin;

public class DeploymentImpl
implements Deployment {
    private boolean activated = false;
    private String identifier;
    private String name;
    private File archive;
    private ClassLoader classLoader;
    private Connector metadata;
    private Activation activation;
    private ResourceAdapter resourceAdapter;
    private Collection<ConnectionFactory> connectionFactories;
    private Collection<AdminObject> adminObjects;
    private ClassLoaderPlugin classLoaderPlugin;

    public DeploymentImpl(String identifier, String name, File archive, ClassLoader classLoader, Connector metadata, Activation activation, ResourceAdapter resourceAdapter, Collection<ConnectionFactory> connectionFactories, Collection<AdminObject> adminObjects, ClassLoaderPlugin classLoaderPlugin) {
        this.identifier = identifier;
        this.name = name;
        this.archive = archive;
        this.classLoader = classLoader;
        this.metadata = metadata;
        this.activation = activation;
        this.resourceAdapter = resourceAdapter;
        this.connectionFactories = connectionFactories;
        this.adminObjects = adminObjects;
        this.classLoaderPlugin = classLoaderPlugin;
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public File getArchive() {
        return this.archive;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Override
    public Connector getMetadata() {
        return this.metadata;
    }

    @Override
    public Activation getActivation() {
        return this.activation;
    }

    @Override
    public ResourceAdapter getResourceAdapter() {
        return this.resourceAdapter;
    }

    @Override
    public Collection<ConnectionFactory> getConnectionFactories() {
        return this.connectionFactories;
    }

    @Override
    public Collection<AdminObject> getAdminObjects() {
        return this.adminObjects;
    }

    @Override
    public ClassLoaderPlugin getClassLoaderPlugin() {
        return this.classLoaderPlugin;
    }

    @Override
    public boolean isActivated() {
        return this.activated;
    }

    @Override
    public boolean activate() throws Exception {
        if (!this.activated) {
            if (this.connectionFactories != null) {
                for (ConnectionFactory cf : this.connectionFactories) {
                    cf.activate();
                }
            }
            if (this.adminObjects != null) {
                for (AdminObject ao : this.adminObjects) {
                    ao.activate();
                }
            }
            if (this.resourceAdapter != null) {
                this.resourceAdapter.activate();
            }
            this.activated = true;
            return true;
        }
        return false;
    }

    @Override
    public boolean deactivate() throws Exception {
        if (this.activated) {
            if (this.connectionFactories != null) {
                for (ConnectionFactory cf : this.connectionFactories) {
                    cf.deactivate();
                }
            }
            if (this.adminObjects != null) {
                for (AdminObject ao : this.adminObjects) {
                    ao.deactivate();
                }
            }
            if (this.resourceAdapter != null) {
                this.resourceAdapter.deactivate();
            }
            this.activated = false;
            return true;
        }
        return false;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !(o instanceof DeploymentImpl)) {
            return false;
        }
        return super.equals(o);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Deployment@").append(Integer.toHexString(System.identityHashCode(this)));
        sb.append("[");
        sb.append("identifier=").append(this.identifier).append(" ");
        sb.append("name=").append(this.name).append(" ");
        sb.append("classLoader=").append(this.classLoader).append(" ");
        sb.append("metadata=").append(this.metadata).append(" ");
        sb.append("activation=").append(this.activation).append(" ");
        sb.append("resourceAdapter=").append(this.resourceAdapter).append(" ");
        sb.append("connectionFactories=").append(this.connectionFactories).append(" ");
        sb.append("adminObjects=").append(this.adminObjects);
        sb.append("]");
        return sb.toString();
    }
}

