/*
 * Decompiled with CFR 0.152.
 */
package org.ironjacamar.core.deploymentrepository;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.ironjacamar.core.api.deploymentrepository.AdminObject;
import org.ironjacamar.core.api.deploymentrepository.ConnectionFactory;
import org.ironjacamar.core.api.deploymentrepository.Deployment;
import org.ironjacamar.core.api.deploymentrepository.DeploymentRepository;

public class DeploymentRepositoryImpl
implements DeploymentRepository {
    private Collection<Deployment> deployments = Collections.synchronizedCollection(new ArrayList());

    @Override
    public Collection<Deployment> getDeployments() {
        return Collections.unmodifiableCollection(this.deployments);
    }

    @Override
    public Deployment findByJndi(String jndi) {
        for (Deployment d : this.deployments) {
            for (ConnectionFactory cf : d.getConnectionFactories()) {
                if (!cf.getJndiName().equals(jndi)) continue;
                return d;
            }
            for (AdminObject ao : d.getAdminObjects()) {
                if (!ao.getJndiName().equals(jndi)) continue;
                return d;
            }
        }
        return null;
    }

    @Override
    public Deployment findById(String id) {
        for (Deployment d : this.deployments) {
            if (d.getIdentifier() == null || !d.getIdentifier().equals(id)) continue;
            return d;
        }
        return null;
    }

    @Override
    public Collection<Deployment> findByName(String name) {
        ArrayList<Deployment> result = new ArrayList<Deployment>();
        for (Deployment d : this.deployments) {
            if (d.getName() == null || !d.getName().equals(name)) continue;
            result.add(d);
        }
        return Collections.unmodifiableCollection(result);
    }

    @Override
    public Collection<Deployment> findByMessageListener(String messageListener) {
        ArrayList<Deployment> result = new ArrayList<Deployment>();
        for (Deployment d : this.deployments) {
            if (d.getResourceAdapter() == null || !d.getResourceAdapter().isMessageListenerSupported(messageListener)) continue;
            result.add(d);
        }
        return Collections.unmodifiableCollection(result);
    }

    @Override
    public boolean registerDeployment(Deployment deployment) {
        if (this.deployments.contains(deployment)) {
            return false;
        }
        return this.deployments.add(deployment);
    }

    @Override
    public boolean unregisterDeployment(Deployment deployment) {
        if (!this.deployments.contains(deployment)) {
            return false;
        }
        return this.deployments.remove(deployment);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("DeploymentRepository@").append(Integer.toHexString(System.identityHashCode(this)));
        sb.append("[");
        sb.append("deployments=").append(this.deployments);
        sb.append("]");
        return sb.toString();
    }
}

