/*
 * Decompiled with CFR 0.152.
 */
package org.ironjacamar.core.deploymentrepository;

import java.util.Collection;
import java.util.Collections;
import org.ironjacamar.core.api.deploymentrepository.ConfigProperty;
import org.ironjacamar.core.api.deploymentrepository.Recovery;
import org.ironjacamar.core.spi.transaction.recovery.XAResourceRecovery;
import org.ironjacamar.core.spi.transaction.recovery.XAResourceRecoveryRegistry;

public class RecoveryImpl
implements Recovery {
    private boolean activated = false;
    private String pluginClassName;
    private Collection<ConfigProperty> dcps;
    private XAResourceRecovery recovery;
    private XAResourceRecoveryRegistry registry;

    public RecoveryImpl(String pluginClassName, Collection<ConfigProperty> dcps, XAResourceRecovery recovery, String jndiName, XAResourceRecoveryRegistry registry) {
        this.pluginClassName = pluginClassName;
        this.dcps = dcps;
        this.recovery = recovery;
        this.registry = registry;
        this.recovery.setJndiName(jndiName);
    }

    @Override
    public String getPluginClassName() {
        return this.pluginClassName;
    }

    @Override
    public Collection<ConfigProperty> getConfigProperties() {
        return Collections.unmodifiableCollection(this.dcps);
    }

    @Override
    public boolean isActivated() {
        return this.activated;
    }

    @Override
    public boolean activate() throws Exception {
        if (!this.activated) {
            this.recovery.initialize();
            this.registry.addXAResourceRecovery(this.recovery);
            this.activated = true;
            return true;
        }
        return false;
    }

    @Override
    public boolean deactivate() throws Exception {
        if (this.activated) {
            this.recovery.shutdown();
            this.registry.removeXAResourceRecovery(this.recovery);
            this.activated = false;
            return true;
        }
        return false;
    }
}

