/*
 * Decompiled with CFR 0.152.
 */
package org.ironjacamar.core.deploymentrepository;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.resource.spi.ActivationSpec;
import javax.resource.spi.BootstrapContext;
import javax.resource.spi.ResourceAdapter;
import javax.resource.spi.endpoint.MessageEndpointFactory;
import javax.validation.ConstraintViolationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.groups.Default;
import org.ironjacamar.core.api.deploymentrepository.ConfigProperty;
import org.ironjacamar.core.api.deploymentrepository.InflowRecovery;
import org.ironjacamar.core.api.deploymentrepository.MessageListener;
import org.ironjacamar.core.bootstrapcontext.CloneableBootstrapContext;
import org.ironjacamar.core.deploymentrepository.ActivationSpecImpl;
import org.ironjacamar.core.deploymentrepository.InflowRecoveryImpl;
import org.ironjacamar.core.deploymentrepository.MessageListenerImpl;
import org.ironjacamar.core.spi.bv.BeanValidation;
import org.ironjacamar.core.spi.statistics.StatisticsPlugin;
import org.ironjacamar.core.spi.transaction.TransactionIntegration;
import org.ironjacamar.core.spi.transaction.recovery.XAResourceRecovery;

public class ResourceAdapterImpl
implements org.ironjacamar.core.api.deploymentrepository.ResourceAdapter {
    private boolean activated = false;
    private ResourceAdapter resourceAdapter;
    private BootstrapContext bc;
    private Collection<ConfigProperty> configProperties;
    private StatisticsPlugin statistics;
    private String productName;
    private String productVersion;
    private Map<String, ActivationSpecImpl> messageListeners;
    private boolean is16;
    private BeanValidation beanValidation;
    private List<String> bvGroups;
    private TransactionIntegration transactionIntegration;
    private Map<Endpoint, InflowRecovery> activeEndpoints;

    public ResourceAdapterImpl(ResourceAdapter resourceAdapter, BootstrapContext bc, Collection<ConfigProperty> configProperties, StatisticsPlugin statistics, String productName, String productVersion, Map<String, ActivationSpecImpl> messageListeners, boolean is16, BeanValidation beanValidation, List<String> bvGroups, TransactionIntegration ti) {
        this.resourceAdapter = resourceAdapter;
        this.bc = bc;
        this.configProperties = configProperties;
        this.statistics = statistics;
        this.productName = productName;
        this.productVersion = productVersion;
        this.messageListeners = messageListeners;
        this.is16 = is16;
        this.beanValidation = beanValidation;
        this.bvGroups = bvGroups;
        this.activeEndpoints = new HashMap<Endpoint, InflowRecovery>();
        this.transactionIntegration = ti;
    }

    @Override
    public boolean isActivated() {
        return this.activated;
    }

    @Override
    public ResourceAdapter getResourceAdapter() {
        return this.resourceAdapter;
    }

    @Override
    public BootstrapContext getBootstrapContext() {
        return this.bc;
    }

    @Override
    public Collection<ConfigProperty> getConfigProperties() {
        return this.configProperties;
    }

    @Override
    public StatisticsPlugin getStatistics() {
        return this.statistics;
    }

    @Override
    public boolean isMessageListenerSupported(String ml) {
        if (this.messageListeners != null && ml != null) {
            return this.messageListeners.containsKey(ml);
        }
        return false;
    }

    @Override
    public MessageListener createMessageListener(String ml) throws Exception {
        if (this.isMessageListenerSupported(ml)) {
            Class<?> mlClz = Class.forName(ml, true, this.resourceAdapter.getClass().getClassLoader());
            return new MessageListenerImpl(mlClz, this.messageListeners.get(ml), this.resourceAdapter.getClass().getClassLoader());
        }
        throw new Exception(ml + " not supported by " + this.resourceAdapter.getClass().getName());
    }

    @Override
    public void endpointActivation(MessageEndpointFactory mef, ActivationSpec as) throws Exception {
        if (mef == null) {
            throw new Exception("MessageEndpointFactory is null");
        }
        if (as == null) {
            throw new Exception("ActivationSpec is null");
        }
        as.setResourceAdapter(this.resourceAdapter);
        try {
            as.validate();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        if (this.is16) {
            this.verifyBeanValidation(as);
        }
        this.resourceAdapter.endpointActivation(mef, as);
        InflowRecoveryImpl ir = null;
        if (this.transactionIntegration != null && this.transactionIntegration.getRecoveryRegistry() != null) {
            XAResourceRecovery xar = this.transactionIntegration.createXAResourceRecovery(this.resourceAdapter, as, this.productName, this.productVersion);
            ir = new InflowRecoveryImpl(mef, as, xar, this.transactionIntegration.getRecoveryRegistry());
            ir.activate();
        }
        this.activeEndpoints.put(new Endpoint(mef, as), ir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void endpointDeactivation(MessageEndpointFactory mef, ActivationSpec as) throws Exception {
        if (mef == null) {
            throw new Exception("MessageEndpointFactory is null");
        }
        if (as == null) {
            throw new Exception("ActivationSpec is null");
        }
        Endpoint e = new Endpoint(mef, as);
        InflowRecovery ir = this.activeEndpoints.get(e);
        if (ir != null) {
            ir.deactivate();
        }
        try {
            this.resourceAdapter.endpointDeactivation(mef, as);
        }
        finally {
            this.activeEndpoints.remove(e);
        }
    }

    @Override
    public Collection<InflowRecovery> getRecovery() {
        return Collections.unmodifiableCollection(this.activeEndpoints.values());
    }

    @Override
    public boolean activate() throws Exception {
        if (!this.activated) {
            this.resourceAdapter.start(this.bc);
            this.activated = true;
            return true;
        }
        return false;
    }

    @Override
    public boolean deactivate() throws Exception {
        if (this.activated) {
            if (!this.activeEndpoints.isEmpty()) {
                throw new Exception("Still active endpoints");
            }
            this.resourceAdapter.stop();
            ((CloneableBootstrapContext)this.bc).shutdown();
            this.activated = false;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyBeanValidation(Object as) throws Exception {
        if (this.beanValidation != null) {
            try (ValidatorFactory vf = null;){
                vf = this.beanValidation.getValidatorFactory();
                Validator v = vf.getValidator();
                List<String> l = this.bvGroups;
                if (l == null || l.isEmpty()) {
                    l = Arrays.asList(Default.class.getName());
                }
                ArrayList groups = new ArrayList();
                for (String clz : l) {
                    groups.add(Class.forName(clz, true, this.resourceAdapter.getClass().getClassLoader()));
                }
                Set failures = v.validate(as, groups.toArray(new Class[groups.size()]));
                if (!failures.isEmpty()) {
                    throw new ConstraintViolationException("Violation for " + as, failures);
                }
            }
        }
    }

    static class Endpoint {
        private MessageEndpointFactory mef;
        private ActivationSpec as;

        Endpoint(MessageEndpointFactory mef, ActivationSpec as) {
            this.mef = mef;
            this.as = as;
        }

        public int hashCode() {
            int hash = 7;
            hash += 7 * this.mef.hashCode();
            return hash += 7 * this.as.hashCode();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o == null || !(o instanceof Endpoint)) {
                return false;
            }
            Endpoint e = (Endpoint)o;
            return this.mef.equals(e.mef) && this.as.equals(e.as);
        }
    }
}

