/*
 * Decompiled with CFR 0.152.
 */
package org.ironjacamar.core.metadatarepository;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.ironjacamar.core.api.metadatarepository.Metadata;
import org.ironjacamar.core.api.metadatarepository.MetadataRepository;

public class MetadataRepositoryImpl
implements MetadataRepository {
    private Collection<Metadata> metadata = Collections.synchronizedCollection(new ArrayList());

    @Override
    public Collection<Metadata> getMetadata() {
        return Collections.unmodifiableCollection(this.metadata);
    }

    @Override
    public Metadata findByName(String name) {
        for (Metadata m : this.metadata) {
            if (!m.getName().equals(name)) continue;
            return m;
        }
        return null;
    }

    @Override
    public boolean registerMetadata(Metadata md) {
        if (this.metadata.contains(md)) {
            return false;
        }
        return this.metadata.add(md);
    }

    @Override
    public boolean unregisterMetadata(Metadata md) {
        if (!this.metadata.contains(md)) {
            return false;
        }
        return this.metadata.remove(md);
    }
}

