/*
 * Decompiled with CFR 0.152.
 */
package org.ironjacamar.core.naming;

import java.util.Hashtable;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.resource.Referenceable;
import org.ironjacamar.core.CoreBundle;
import org.ironjacamar.core.CoreLogger;
import org.ironjacamar.core.naming.Util;
import org.ironjacamar.core.spi.naming.JndiStrategy;
import org.jboss.logging.Logger;
import org.jboss.logging.Messages;

public class JNPStrategy
implements JndiStrategy {
    private static CoreLogger log = (CoreLogger)Logger.getMessageLogger(CoreLogger.class, (String)JNPStrategy.class.getName());
    private static boolean trace = log.isTraceEnabled();
    private static CoreBundle bundle = (CoreBundle)Messages.getBundle(CoreBundle.class);
    private static ConcurrentMap<String, Object> objs = new ConcurrentHashMap<String, Object>();
    private int jndiPort;
    private String jndiProtocol;
    private String jndiHost;

    @Override
    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment) throws Exception {
        Reference ref = (Reference)obj;
        String className = (String)ref.get("class").getContent();
        String cfname = (String)ref.get("name").getContent();
        return objs.get(JNPStrategy.qualifiedName(cfname, className));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void bind(String jndiName, Object o) throws NamingException {
        if (jndiName == null) {
            throw new NamingException();
        }
        if (o == null) {
            throw new NamingException();
        }
        Context context = this.createContext();
        try {
            String className = o.getClass().getName();
            if (trace) {
                log.trace("Binding " + className + " under " + jndiName);
            }
            Reference ref = new Reference(className, new StringRefAddr("class", className), JNPStrategy.class.getName(), null);
            ref.add(new StringRefAddr("name", jndiName));
            if (objs.putIfAbsent(JNPStrategy.qualifiedName(jndiName, className), o) != null) {
                throw new NamingException(bundle.deploymentFailedSinceJndiNameHasDeployed(className, jndiName));
            }
            if (o instanceof Referenceable) {
                Referenceable referenceable = (Referenceable)o;
                referenceable.setReference(ref);
            }
            Util.bind(context, jndiName, o);
            if (log.isDebugEnabled()) {
                log.debug("Bound " + className + " under " + jndiName);
            }
        }
        finally {
            if (context != null) {
                try {
                    context.close();
                }
                catch (NamingException namingException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unbind(String jndiName, Object o) throws NamingException {
        if (jndiName == null) {
            throw new NamingException();
        }
        if (o == null) {
            throw new NamingException();
        }
        Context context = this.createContext();
        try {
            String className = o.getClass().getName();
            if (trace) {
                log.trace("Unbinding " + className + " under " + jndiName);
            }
            Util.unbind(context, jndiName);
            objs.remove(JNPStrategy.qualifiedName(jndiName, className));
            if (log.isDebugEnabled()) {
                log.debug("Unbound " + className + " under " + jndiName);
            }
        }
        catch (Throwable throwable) {
        }
        finally {
            if (context != null) {
                try {
                    context.close();
                }
                catch (NamingException namingException) {}
            }
        }
    }

    protected Context createContext() throws NamingException {
        Properties properties = new Properties();
        properties.setProperty("java.naming.factory.initial", "org.jnp.interfaces.LocalOnlyContextFactory");
        properties.setProperty("java.naming.factory.url.pkgs", "org.jboss.naming:org.jnp.interfaces");
        properties.setProperty("java.naming.provider.url", this.jndiProtocol + "://" + this.jndiHost + ":" + this.jndiPort);
        return new InitialContext(properties);
    }

    public int getJndiPort() {
        return this.jndiPort;
    }

    public String getJndiProtocol() {
        return this.jndiProtocol;
    }

    public String getJndiHost() {
        return this.jndiHost;
    }

    public void setJndiPort(int jndiPort) {
        this.jndiPort = jndiPort;
    }

    public void setJndiProtocol(String jndiProtocol) {
        this.jndiProtocol = jndiProtocol;
    }

    public void setJndiHost(String jndiHost) {
        this.jndiHost = jndiHost;
    }

    private static String qualifiedName(String name, String className) {
        return className + "#" + name;
    }
}

