/*
 * Decompiled with CFR 0.152.
 */
package org.ironjacamar.core.naming;

import java.util.Hashtable;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.naming.spi.ObjectFactory;
import org.ironjacamar.core.CoreLogger;
import org.ironjacamar.core.naming.Util;
import org.jboss.logging.Logger;

public class JndiBinder
implements ObjectFactory {
    private static CoreLogger log = (CoreLogger)Logger.getMessageLogger(CoreLogger.class, (String)JndiBinder.class.getName());
    private static boolean trace = log.isTraceEnabled();
    private static ConcurrentMap<String, Object> objs = new ConcurrentHashMap<String, Object>();
    private String name;
    private Object obj;
    private int jndiPort;
    private String jndiProtocol;
    private String jndiHost;

    public void setName(String v) {
        this.name = v;
    }

    public void setObject(Object v) {
        this.obj = v;
    }

    public void setJndiPort(int jndiPort) {
        this.jndiPort = jndiPort;
    }

    public void setJndiProtocol(String jndiProtocol) {
        this.jndiProtocol = jndiProtocol;
    }

    public void setJndiHost(String jndiHost) {
        this.jndiHost = jndiHost;
    }

    @Override
    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment) throws Exception {
        Reference ref = (Reference)obj;
        String objName = (String)ref.get("name").getContent();
        return objs.get(objName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bind() throws Throwable {
        if (this.name == null) {
            throw new IllegalArgumentException("Name is null");
        }
        if (this.obj == null) {
            throw new IllegalArgumentException("Obj is null");
        }
        if (trace) {
            log.trace("Binding " + this.obj.getClass().getName() + " under " + this.name);
        }
        Properties properties = new Properties();
        properties.setProperty("java.naming.provider.url", this.jndiProtocol + "://" + this.jndiHost + ":" + this.jndiPort);
        InitialContext context = new InitialContext(properties);
        try {
            String className = this.obj.getClass().getName();
            Reference ref = new Reference(className, new StringRefAddr("class", className), JndiBinder.class.getName(), null);
            ref.add(new StringRefAddr("name", this.name));
            objs.put(this.name, this.obj);
            Util.bind((Context)context, this.name, (Object)ref);
            if (log.isDebugEnabled()) {
                log.debug("Bound " + this.obj.getClass().getName() + " under " + this.name);
            }
        }
        finally {
            if (context != null) {
                try {
                    context.close();
                }
                catch (NamingException namingException) {}
            }
        }
    }

    public void unbind() throws Throwable {
        if (this.name == null) {
            throw new IllegalArgumentException("Name is null");
        }
        if (trace) {
            log.trace("Unbinding " + this.name);
        }
        Context context = null;
        try {
            Properties properties = new Properties();
            properties.setProperty("java.naming.provider.url", this.jndiProtocol + "://" + this.jndiHost + ":" + this.jndiPort);
            context = new InitialContext(properties);
            Util.unbind(context, this.name);
            objs.remove(this.name);
            if (log.isDebugEnabled()) {
                log.debug("Unbound " + this.name);
            }
        }
        catch (Throwable t) {
            log.exceptionDuringUnbind(t);
        }
        finally {
            if (context != null) {
                try {
                    context.close();
                }
                catch (NamingException properties) {}
            }
        }
    }
}

