/*
 * Decompiled with CFR 0.152.
 */
package org.ironjacamar.core.recovery;

import java.lang.reflect.Method;
import javax.resource.ResourceException;
import javax.resource.cci.Connection;
import org.ironjacamar.core.CoreBundle;
import org.ironjacamar.core.CoreLogger;
import org.ironjacamar.core.recovery.SecurityActions;
import org.ironjacamar.core.spi.recovery.RecoveryPlugin;
import org.jboss.logging.Logger;
import org.jboss.logging.Messages;

public class DefaultRecoveryPlugin
implements RecoveryPlugin {
    private static CoreLogger log = (CoreLogger)Logger.getMessageLogger(CoreLogger.class, (String)DefaultRecoveryPlugin.class.getName());
    private static CoreBundle bundle = (CoreBundle)Messages.getBundle(CoreBundle.class);

    @Override
    public boolean isValid(Object c) throws ResourceException {
        if (c != null) {
            try {
                Method method = SecurityActions.getMethod(c.getClass(), "isValid", Integer.TYPE);
                SecurityActions.setAccessible(method, true);
                Boolean b = (Boolean)method.invoke(c, 5);
                return b;
            }
            catch (Throwable t) {
                log.debugf("No isValid(int) method defined on connection interface (%s)", c.getClass().getName());
            }
        }
        return false;
    }

    @Override
    public void close(Object c) throws ResourceException {
        if (c != null) {
            if (c instanceof Connection) {
                try {
                    Connection cci = (Connection)c;
                    cci.close();
                }
                catch (ResourceException re) {
                    log.exceptionDuringConnectionClose(re);
                    throw new ResourceException(bundle.errorDuringConnectionClose(), (Throwable)re);
                }
            }
            try {
                Method method = SecurityActions.getMethod(c.getClass(), "close", null);
                SecurityActions.setAccessible(method, true);
                method.invoke(c, (Object[])null);
            }
            catch (Throwable t) {
                log.debug("Error during connection close()", t);
                throw new ResourceException(bundle.errorDuringConnectionClose(), t);
            }
        }
    }
}

