/*
 * Decompiled with CFR 0.152.
 */
package org.ironjacamar.core.security.picketbox;

import java.io.IOException;
import java.io.Serializable;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.message.callback.CallerPrincipalCallback;
import javax.security.auth.message.callback.GroupPrincipalCallback;
import org.ironjacamar.core.CoreLogger;
import org.ironjacamar.core.spi.security.Callback;
import org.jboss.logging.Logger;
import org.jboss.security.auth.callback.JASPICallbackHandler;

public class PicketBoxCallbackHandler
implements CallbackHandler,
Serializable {
    private static final long serialVersionUID = 1L;
    private static CoreLogger log = (CoreLogger)Logger.getMessageLogger(CoreLogger.class, (String)PicketBoxCallbackHandler.class.getName());
    private static boolean trace = log.isTraceEnabled();
    private Callback mappings;

    public PicketBoxCallbackHandler() {
        this(null);
    }

    public PicketBoxCallbackHandler(Callback mappings) {
        this.mappings = mappings;
    }

    @Override
    public void handle(javax.security.auth.callback.Callback[] callbacks) throws UnsupportedCallbackException, IOException {
        if (trace) {
            log.tracef("handle(%s)", Arrays.toString(callbacks));
        }
        if (callbacks != null && callbacks.length > 0) {
            if (this.mappings != null) {
                ArrayList<Object> l = new ArrayList<Object>(callbacks.length);
                for (int i = 0; i < callbacks.length; ++i) {
                    javax.security.auth.callback.Callback callback = callbacks[i];
                    if (callback instanceof CallerPrincipalCallback) {
                        CallerPrincipalCallback callerPrincipalCallback = (CallerPrincipalCallback)callback;
                        String name = null;
                        Principal p = null;
                        Principal callerPrincipal = callerPrincipalCallback.getPrincipal();
                        if (callerPrincipal != null) {
                            name = callerPrincipal.getName();
                        }
                        if (name == null && callerPrincipalCallback.getName() != null) {
                            name = callerPrincipalCallback.getName();
                        }
                        if (name != null) {
                            p = this.mappings.mapPrincipal(name);
                        }
                        if (p != null) {
                            l.add(new CallerPrincipalCallback(callerPrincipalCallback.getSubject(), p));
                            continue;
                        }
                        l.add(callback);
                        continue;
                    }
                    if (callback instanceof GroupPrincipalCallback) {
                        GroupPrincipalCallback groupPrincipalCallback = (GroupPrincipalCallback)callback;
                        if (groupPrincipalCallback.getGroups() != null && groupPrincipalCallback.getGroups().length > 0) {
                            ArrayList<String> gs = new ArrayList<String>(groupPrincipalCallback.getGroups().length);
                            for (String g : groupPrincipalCallback.getGroups()) {
                                String s = this.mappings.mapGroup(g);
                                if (s != null) {
                                    gs.add(s);
                                    continue;
                                }
                                gs.add(g);
                            }
                            l.add(new GroupPrincipalCallback(groupPrincipalCallback.getSubject(), gs.toArray(new String[gs.size()])));
                            continue;
                        }
                        l.add(callback);
                        continue;
                    }
                    l.add(callback);
                }
                callbacks = l.toArray(new javax.security.auth.callback.Callback[l.size()]);
            }
            JASPICallbackHandler jaspi = new JASPICallbackHandler();
            jaspi.handle(callbacks);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("PicketBoxCallbackHandler@").append(Integer.toHexString(System.identityHashCode(this)));
        sb.append("[mappings=").append(this.mappings);
        sb.append("]");
        return sb.toString();
    }
}

