/*
 * Decompiled with CFR 0.152.
 */
package org.ironjacamar.core.tx.narayana;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashSet;
import java.util.Set;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;
import org.ironjacamar.core.security.SimplePrincipal;
import org.ironjacamar.core.spi.security.SubjectFactory;

class SecurityActions {
    private SecurityActions() {
    }

    static Subject createSubject(final String recoverUserName, final String recoverPassword, final ManagedConnectionFactory mcf) {
        if (System.getSecurityManager() == null) {
            HashSet<SimplePrincipal> principals = new HashSet<SimplePrincipal>();
            HashSet pubCredentials = new HashSet();
            HashSet<PasswordCredential> privCredentials = new HashSet<PasswordCredential>();
            SimplePrincipal p = new SimplePrincipal(recoverUserName);
            principals.add(p);
            PasswordCredential pc = new PasswordCredential(recoverUserName, recoverPassword.toCharArray());
            pc.setManagedConnectionFactory(mcf);
            privCredentials.add(pc);
            return new Subject(false, principals, pubCredentials, privCredentials);
        }
        return AccessController.doPrivileged(new PrivilegedAction<Subject>(){

            @Override
            public Subject run() {
                HashSet<SimplePrincipal> principals = new HashSet<SimplePrincipal>();
                HashSet pubCredentials = new HashSet();
                HashSet<PasswordCredential> privCredentials = new HashSet<PasswordCredential>();
                SimplePrincipal p = new SimplePrincipal(recoverUserName);
                principals.add(p);
                PasswordCredential pc = new PasswordCredential(recoverUserName, recoverPassword.toCharArray());
                pc.setManagedConnectionFactory(mcf);
                privCredentials.add(pc);
                return new Subject(false, principals, pubCredentials, privCredentials);
            }
        });
    }

    static Subject createSubject(final SubjectFactory subjectFactory, final String domain) {
        if (System.getSecurityManager() == null) {
            return subjectFactory.createSubject(domain);
        }
        return AccessController.doPrivileged(new PrivilegedAction<Subject>(){

            @Override
            public Subject run() {
                return subjectFactory.createSubject(domain);
            }
        });
    }

    static Set<PasswordCredential> getPasswordCredentials(final Subject subject) {
        if (System.getSecurityManager() == null) {
            return subject.getPrivateCredentials(PasswordCredential.class);
        }
        return AccessController.doPrivileged(new PrivilegedAction<Set<PasswordCredential>>(){

            @Override
            public Set<PasswordCredential> run() {
                return subject.getPrivateCredentials(PasswordCredential.class);
            }
        });
    }
}

