/*
 * Decompiled with CFR 0.152.
 */
package org.ironjacamar.core.tx.narayana;

import javax.resource.NotSupportedException;
import javax.resource.ResourceException;
import javax.resource.spi.ActivationSpec;
import javax.resource.spi.ResourceAdapter;
import javax.transaction.xa.XAResource;
import org.ironjacamar.core.CoreLogger;
import org.ironjacamar.core.tx.narayana.XAResourceWrapperImpl;
import org.jboss.logging.Logger;
import org.jboss.tm.XAResourceRecovery;

public class XAResourceRecoveryInflowImpl
implements org.ironjacamar.core.spi.transaction.recovery.XAResourceRecovery,
XAResourceRecovery {
    private static CoreLogger log = (CoreLogger)Logger.getMessageLogger(CoreLogger.class, (String)XAResourceRecoveryInflowImpl.class.getName());
    private ResourceAdapter resourceAdapter;
    private ActivationSpec activationSpec;
    private String productName;
    private String productVersion;
    private String jndiName;

    public XAResourceRecoveryInflowImpl(ResourceAdapter rar, ActivationSpec as, String productName, String productVersion) {
        if (rar == null) {
            throw new IllegalArgumentException("ResourceAdapter is null");
        }
        if (as == null) {
            throw new IllegalArgumentException("ActivationSpec is null");
        }
        this.resourceAdapter = rar;
        this.activationSpec = as;
        this.productName = productName;
        this.productVersion = productVersion;
        this.jndiName = null;
    }

    @Override
    public void initialize() throws Exception {
    }

    @Override
    public void shutdown() throws Exception {
    }

    @Override
    public void setJndiName(String jndiName) {
        this.jndiName = jndiName;
    }

    @Override
    public XAResource[] getXAResources() {
        try {
            XAResource[] result = this.resourceAdapter.getXAResources(new ActivationSpec[]{this.activationSpec});
            if (result == null || result.length == 0) {
                return result;
            }
            XAResource[] newResult = new XAResource[result.length];
            for (int i = 0; i < result.length; ++i) {
                newResult[i] = new XAResourceWrapperImpl(result[i], this.productName, this.productVersion);
            }
            return newResult;
        }
        catch (NotSupportedException result) {
        }
        catch (ResourceException re) {
            log.exceptionDuringCrashRecoveryInflow(this.resourceAdapter.getClass().getName(), this.activationSpec, re);
        }
        return new XAResource[0];
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("XAResourceRecoveryInflowImpl@").append(Integer.toHexString(System.identityHashCode(this)));
        sb.append("[");
        sb.append(" rar=").append(this.resourceAdapter.getClass().getName());
        sb.append(" as=").append(this.activationSpec);
        sb.append("]");
        return sb.toString();
    }
}

