/*
 * Decompiled with CFR 0.152.
 */
package org.ironjacamar.core.tx.noopts;

import javax.resource.ResourceException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.ironjacamar.core.api.connectionmanager.ConnectionManager;
import org.ironjacamar.core.api.connectionmanager.listener.ConnectionListener;
import org.ironjacamar.core.spi.transaction.local.LocalXAException;
import org.ironjacamar.core.spi.transaction.local.LocalXAResource;
import org.ironjacamar.core.spi.transaction.xa.XAResourceWrapper;

public class LocalXAResourceImpl
implements LocalXAResource,
XAResourceWrapper {
    private ConnectionListener cl = null;
    private ConnectionManager connectionManager = null;
    private String productName;
    private String productVersion;
    private String jndiName;

    public LocalXAResourceImpl(String productName, String productVersion, String jndiName) {
        this.productName = productName;
        this.productVersion = productVersion;
        this.jndiName = jndiName;
    }

    @Override
    public void setConnectionManager(ConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
    }

    @Override
    public void setConnectionListener(ConnectionListener cl) {
        this.cl = cl;
    }

    @Override
    public void start(Xid xid, int flags) throws XAException {
        try {
            this.cl.getManagedConnection().getLocalTransaction().begin();
        }
        catch (ResourceException re) {
            throw new LocalXAException("start", -3, re);
        }
    }

    @Override
    public void end(Xid xid, int flags) throws XAException {
    }

    @Override
    public void commit(Xid xid, boolean onePhase) throws XAException {
        try {
            this.cl.getManagedConnection().getLocalTransaction().commit();
        }
        catch (ResourceException re) {
            this.connectionManager.returnConnectionListener(this.cl, true);
            throw new LocalXAException("commit", 100, re);
        }
    }

    @Override
    public void forget(Xid xid) throws XAException {
        throw new LocalXAException("Error", -3);
    }

    @Override
    public int getTransactionTimeout() throws XAException {
        return 0;
    }

    @Override
    public boolean isSameRM(XAResource xaResource) throws XAException {
        return xaResource == this;
    }

    @Override
    public int prepare(Xid xid) throws XAException {
        return 0;
    }

    @Override
    public Xid[] recover(int flag) throws XAException {
        throw new LocalXAException("Error", -3);
    }

    @Override
    public void rollback(Xid xid) throws XAException {
        try {
            this.cl.getManagedConnection().getLocalTransaction().rollback();
        }
        catch (ResourceException re) {
            this.connectionManager.returnConnectionListener(this.cl, true);
            throw new LocalXAException("rollback", -3, re);
        }
    }

    @Override
    public boolean setTransactionTimeout(int seconds) throws XAException {
        return false;
    }

    @Override
    public XAResource getResource() {
        return this;
    }

    @Override
    public String getProductName() {
        return this.productName;
    }

    @Override
    public String getProductVersion() {
        return this.productVersion;
    }

    @Override
    public String getJndiName() {
        return this.jndiName;
    }
}

