/*
 * Decompiled with CFR 0.152.
 */
package org.ironjacamar.core.tx.noopts;

import java.io.Serializable;
import javax.naming.InitialContext;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.UserTransaction;
import org.ironjacamar.core.spi.transaction.usertx.UserTransactionProvider;
import org.ironjacamar.core.spi.transaction.usertx.UserTransactionRegistry;
import org.ironjacamar.core.tx.noopts.TransactionImpl;
import org.ironjacamar.core.tx.noopts.TxRegistry;

public class UserTransactionImpl
implements UserTransactionProvider,
UserTransaction,
Serializable {
    private static final long serialVersionUID = 2L;
    private static final String JNDI_NAME = "java:/UserTransaction";
    private transient TxRegistry registry = null;
    private transient UserTransactionRegistry userTransactionRegistry = null;

    public void setRegistry(TxRegistry v) {
        this.registry = v;
    }

    @Override
    public void setUserTransactionRegistry(UserTransactionRegistry v) {
        this.userTransactionRegistry = v;
    }

    public void begin() throws NotSupportedException, SystemException {
        TransactionImpl tx = this.registry.getTransaction();
        if (tx != null && tx.getStatus() != 5) {
            throw new SystemException();
        }
        this.registry.startTransaction();
        if (this.userTransactionRegistry != null) {
            this.userTransactionRegistry.userTransactionStarted();
        }
    }

    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        TransactionImpl tx = this.registry.getTransaction();
        if (tx == null) {
            throw new SystemException();
        }
        if (tx.getStatus() == 9 || tx.getStatus() == 4 || tx.getStatus() == 1) {
            throw new RollbackException();
        }
        this.registry.commitTransaction();
    }

    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        TransactionImpl tx = this.registry.getTransaction();
        if (tx == null) {
            throw new IllegalStateException();
        }
        this.registry.rollbackTransaction();
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        TransactionImpl tx = this.registry.getTransaction();
        if (tx == null) {
            throw new IllegalStateException();
        }
        tx.setRollbackOnly();
    }

    public int getStatus() throws SystemException {
        TransactionImpl tx = this.registry.getTransaction();
        if (tx == null) {
            return 6;
        }
        return tx.getStatus();
    }

    public void setTransactionTimeout(int seconds) throws SystemException {
    }

    public void start() throws Throwable {
        InitialContext context = new InitialContext();
        context.bind(JNDI_NAME, (Object)this);
        context.close();
    }

    public void stop() throws Throwable {
        InitialContext context = new InitialContext();
        context.unbind(JNDI_NAME);
        context.close();
    }
}

