/*
 * Decompiled with CFR 0.152.
 */
package org.ironjacamar.core.tx.noopts;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.transaction.SystemException;
import org.ironjacamar.core.spi.transaction.usertx.UserTransactionListener;
import org.ironjacamar.core.spi.transaction.usertx.UserTransactionProvider;
import org.ironjacamar.core.spi.transaction.usertx.UserTransactionRegistry;

public class UserTransactionRegistryImpl
implements UserTransactionRegistry {
    private Set<UserTransactionListener> listeners = Collections.synchronizedSet(new HashSet());
    private Set<UserTransactionProvider> providers = Collections.synchronizedSet(new HashSet());

    @Override
    public void addListener(UserTransactionListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    @Override
    public void removeListener(UserTransactionListener listener) {
        if (listener != null) {
            this.listeners.remove(listener);
        }
    }

    @Override
    public void addProvider(UserTransactionProvider provider) {
        if (provider != null) {
            provider.setUserTransactionRegistry(this);
            this.providers.add(provider);
        }
    }

    @Override
    public void removeProvider(UserTransactionProvider provider) {
        if (provider != null) {
            provider.setUserTransactionRegistry(null);
            this.providers.remove(provider);
        }
    }

    @Override
    public void userTransactionStarted() {
        for (UserTransactionListener utl : this.listeners) {
            try {
                utl.userTransactionStarted();
            }
            catch (SystemException systemException) {}
        }
    }
}

