/*
 * Decompiled with CFR 0.152.
 */
package org.ironjacamar.core.tx.noopts;

import javax.resource.spi.ActivationSpec;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.ResourceAdapter;
import javax.transaction.xa.XAResource;
import org.ironjacamar.core.spi.security.SubjectFactory;
import org.ironjacamar.core.spi.transaction.recovery.XAResourceRecovery;

public class XAResourceRecoveryImpl
implements XAResourceRecovery {
    private ResourceAdapter rar;
    private ActivationSpec as;
    private ManagedConnectionFactory mcf;
    private ManagedConnection mc;
    private String securityDomain;
    private SubjectFactory subjectFactory;

    public XAResourceRecoveryImpl(ResourceAdapter rar, ActivationSpec as) {
        this.rar = rar;
        this.as = as;
    }

    public XAResourceRecoveryImpl(ManagedConnectionFactory mcf, String sd, SubjectFactory subjectFactory) {
        this.mcf = mcf;
        this.mc = null;
        this.securityDomain = sd;
        this.subjectFactory = subjectFactory;
    }

    @Override
    public void initialize() throws Exception {
        if (this.rar != null) {
            for (XAResource xar : this.rar.getXAResources(new ActivationSpec[]{this.as})) {
                xar.recover(0x1000000);
                xar.recover(0x800000);
            }
        } else {
            this.mc = this.mcf.createManagedConnection(this.subjectFactory.createSubject(this.securityDomain), null);
            this.mc.getXAResource().recover(0x1000000);
            this.mc.getXAResource().recover(0x800000);
        }
    }

    @Override
    public void shutdown() throws Exception {
        if (this.mc != null) {
            this.mc.cleanup();
            this.mc.destroy();
            this.mc = null;
        }
    }

    @Override
    public XAResource[] getXAResources() {
        return new XAResource[0];
    }

    @Override
    public void setJndiName(String jndiName) {
    }
}

