/*
 * Decompiled with CFR 0.152.
 */
package org.ironjacamar.core.tx.noopts;

import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.ironjacamar.core.CoreLogger;
import org.ironjacamar.core.spi.transaction.xa.XAResourceWrapper;
import org.jboss.logging.Logger;

public class XAResourceWrapperImpl
implements XAResourceWrapper {
    private static CoreLogger log = (CoreLogger)Logger.getMessageLogger(CoreLogger.class, (String)XAResourceWrapperImpl.class.getName());
    private XAResource xaResource;
    private Boolean overrideRmValue;
    private String productName;
    private String productVersion;
    private String jndiName;

    public XAResourceWrapperImpl(XAResource resource, Boolean override, String productName, String productVersion, String jndiName) {
        this.xaResource = resource;
        this.overrideRmValue = override;
        this.productName = productName;
        this.productVersion = productVersion;
        this.jndiName = jndiName;
    }

    @Override
    public void commit(Xid xid, boolean onePhase) throws XAException {
        this.xaResource.commit(xid, onePhase);
    }

    @Override
    public void end(Xid xid, int flags) throws XAException {
        this.xaResource.end(xid, flags);
    }

    @Override
    public void forget(Xid xid) throws XAException {
        this.xaResource.forget(xid);
    }

    @Override
    public int getTransactionTimeout() throws XAException {
        return this.xaResource.getTransactionTimeout();
    }

    @Override
    public boolean isSameRM(XAResource resource) throws XAException {
        if (this.overrideRmValue != null) {
            if (log.isTraceEnabled()) {
                log.trace("Executing isSameRM with override value" + this.overrideRmValue + " for XAResourceWrapper" + this);
            }
            return this.overrideRmValue;
        }
        if (resource instanceof XAResourceWrapper) {
            XAResourceWrapper other = (XAResourceWrapper)resource;
            return this.xaResource.isSameRM(other.getResource());
        }
        return this.xaResource.isSameRM(resource);
    }

    @Override
    public int prepare(Xid xid) throws XAException {
        return this.xaResource.prepare(xid);
    }

    @Override
    public Xid[] recover(int flag) throws XAException {
        return this.xaResource.recover(flag);
    }

    @Override
    public void rollback(Xid xid) throws XAException {
        this.xaResource.rollback(xid);
    }

    @Override
    public boolean setTransactionTimeout(int flag) throws XAException {
        return this.xaResource.setTransactionTimeout(flag);
    }

    @Override
    public void start(Xid xid, int flags) throws XAException {
        this.xaResource.start(xid, flags);
    }

    @Override
    public XAResource getResource() {
        return this.xaResource;
    }

    @Override
    public String getProductName() {
        return this.productName;
    }

    @Override
    public String getProductVersion() {
        return this.productVersion;
    }

    @Override
    public String getJndiName() {
        return this.jndiName;
    }
}

