/*
 * Decompiled with CFR 0.152.
 */
package org.ironjacamar.core.workmanager;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import org.ironjacamar.core.CoreLogger;
import org.ironjacamar.core.workmanager.ClassBundle;
import org.ironjacamar.core.workmanager.ClassDefinition;
import org.ironjacamar.core.workmanager.ClassDefinitionFactory;
import org.ironjacamar.core.workmanager.SecurityActions;
import org.jboss.logging.Logger;

public class ClassBundleFactory {
    private static CoreLogger log = (CoreLogger)Logger.getMessageLogger(CoreLogger.class, (String)ClassBundleFactory.class.getName());
    private static boolean trace = log.isTraceEnabled();

    private ClassBundleFactory() {
    }

    public static ClassBundle createClassBundle(Serializable s) {
        ClassDefinition cd;
        String name;
        if (s == null) {
            return null;
        }
        if (trace) {
            log.tracef("Creating class bundle for: %s", s);
        }
        ClassBundle cb = new ClassBundle();
        Class<?>[] classes = s.getClass().getInterfaces();
        if (classes != null && classes.length > 0) {
            for (Class<?> clz : classes) {
                name = clz.getName();
                if (name.startsWith("java") || name.startsWith("javax")) continue;
                if (trace) {
                    log.tracef("Creating class definition for: %s", name);
                }
                cd = ClassDefinitionFactory.createClassDefinition(s, clz);
                if (cb.getDefinitions().contains(cd)) continue;
                cb.getDefinitions().add(cd);
            }
        } else if (trace) {
            log.tracef("No interfaces for: %s", s.getClass().getName());
        }
        if ((classes = SecurityActions.getDeclaredClasses(s.getClass())) != null && classes.length > 0) {
            for (Class<?> clz : classes) {
                name = clz.getName();
                if (name.startsWith("java") || name.startsWith("javax")) continue;
                if (trace) {
                    log.tracef("Creating class definition for: %s", name);
                }
                cd = ClassDefinitionFactory.createClassDefinition(s, clz);
                if (cb.getDefinitions().contains(cd)) continue;
                cb.getDefinitions().add(cd);
            }
        } else if (trace) {
            log.tracef("No classes for: %s", s.getClass().getName());
        }
        if ((classes = ClassBundleFactory.getFields(s.getClass())) != null && classes.length > 0) {
            for (Class<?> clz : classes) {
                name = clz.getName();
                if (name.startsWith("java") || name.startsWith("javax")) continue;
                if (trace) {
                    log.tracef("Creating class definition for: %s", name);
                }
                cd = ClassDefinitionFactory.createClassDefinition(s, clz);
                if (cb.getDefinitions().contains(cd)) continue;
                cb.getDefinitions().add(cd);
            }
        } else if (trace) {
            log.tracef("No fields for: %s", s.getClass().getName());
        }
        Class<?> clz = s.getClass().getSuperclass();
        while (clz != null) {
            String name2 = clz.getName();
            if (!name2.startsWith("java") && !name2.startsWith("javax")) {
                if (trace) {
                    log.tracef("Creating class definition for: %s", name2);
                }
                ClassDefinition cd2 = ClassDefinitionFactory.createClassDefinition(s, clz);
                if (!cb.getDefinitions().contains(cd2)) {
                    cb.getDefinitions().add(cd2);
                }
                clz = clz.getSuperclass();
                continue;
            }
            clz = null;
        }
        cb.getDefinitions().add(ClassDefinitionFactory.createClassDefinition(s));
        if (trace) {
            log.tracef("Class bundle: %s", cb);
        }
        return cb;
    }

    private static Class<?>[] getFields(Class<?> clz) {
        ArrayList result = new ArrayList();
        Class<?> c = clz;
        while (!c.equals(Object.class)) {
            try {
                Field[] fields = SecurityActions.getDeclaredFields(c);
                if (fields.length > 0) {
                    for (Field f : fields) {
                        Class<?> defClz = f.getType();
                        String defClzName = defClz.getName();
                        if (defClz.isPrimitive() || defClz.isArray() || defClzName.startsWith("java") || defClzName.startsWith("javax") || result.contains(defClz)) continue;
                        if (trace) {
                            log.tracef("Adding field: %s", defClzName);
                        }
                        result.add(defClz);
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            c = c.getSuperclass();
        }
        return result.toArray(new Class[result.size()]);
    }
}

