/*
 * Decompiled with CFR 0.152.
 */
package org.ironjacamar.core.workmanager;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.resource.spi.ResourceAdapter;
import javax.resource.spi.ResourceAdapterAssociation;
import javax.resource.spi.work.ExecutionContext;
import javax.resource.spi.work.HintsContext;
import javax.resource.spi.work.SecurityContext;
import javax.resource.spi.work.TransactionContext;
import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkCompletedException;
import javax.resource.spi.work.WorkContext;
import javax.resource.spi.work.WorkContextLifecycleListener;
import javax.resource.spi.work.WorkContextProvider;
import javax.resource.spi.work.WorkEvent;
import javax.resource.spi.work.WorkException;
import javax.resource.spi.work.WorkListener;
import javax.resource.spi.work.WorkRejectedException;
import org.ironjacamar.core.CoreBundle;
import org.ironjacamar.core.CoreLogger;
import org.ironjacamar.core.api.workmanager.DistributableContext;
import org.ironjacamar.core.api.workmanager.StatisticsExecutor;
import org.ironjacamar.core.api.workmanager.WorkManager;
import org.ironjacamar.core.api.workmanager.WorkManagerStatistics;
import org.ironjacamar.core.spi.graceful.GracefulCallback;
import org.ironjacamar.core.spi.security.Callback;
import org.ironjacamar.core.spi.security.SecurityIntegration;
import org.ironjacamar.core.spi.transaction.xa.XATerminator;
import org.ironjacamar.core.workmanager.ResourceAdapterClassLoader;
import org.ironjacamar.core.workmanager.SecurityActions;
import org.ironjacamar.core.workmanager.StatisticsExecutorImpl;
import org.ironjacamar.core.workmanager.WorkClassLoader;
import org.ironjacamar.core.workmanager.WorkManagerShutdown;
import org.ironjacamar.core.workmanager.WorkManagerStatisticsImpl;
import org.ironjacamar.core.workmanager.WorkManagerUtil;
import org.ironjacamar.core.workmanager.WorkWrapper;
import org.jboss.logging.Logger;
import org.jboss.logging.Messages;
import org.jboss.threads.BlockingExecutor;
import org.jboss.threads.ExecutionTimedOutException;

public class WorkManagerImpl
implements WorkManager {
    private static CoreLogger log = (CoreLogger)Logger.getMessageLogger(CoreLogger.class, (String)WorkManagerImpl.class.getName());
    private static boolean trace = log.isTraceEnabled();
    private static CoreBundle bundle = (CoreBundle)Messages.getBundle(CoreBundle.class);
    private static final String RUN_METHOD_NAME = "run";
    private static final String RELEASE_METHOD_NAME = "release";
    private static final Set<Class<? extends WorkContext>> SUPPORTED_WORK_CONTEXT_CLASSES = new HashSet<Class<? extends WorkContext>>(4);
    private String id = null;
    private String name = null;
    private boolean specCompliant = true;
    private StatisticsExecutor shortRunningExecutor;
    private StatisticsExecutor longRunningExecutor;
    private XATerminator xaTerminator;
    private Set<String> validatedWork = new HashSet<String>();
    private Callback callbackSecurity;
    private SecurityIntegration securityIntegration;
    private ResourceAdapter resourceAdapter = null;
    private AtomicBoolean shutdown = new AtomicBoolean(false);
    private ScheduledExecutorService scheduledExecutorService = null;
    private ScheduledFuture scheduledGraceful = null;
    private GracefulCallback gracefulCallback = null;
    private Set<WorkWrapper> activeWorkWrappers = new HashSet<WorkWrapper>();
    private boolean statisticsEnabled = true;
    private WorkManagerStatisticsImpl statistics = new WorkManagerStatisticsImpl();

    @Override
    public String getId() {
        if (this.id == null) {
            return this.name;
        }
        return this.id;
    }

    @Override
    public void setId(String v) {
        this.id = v;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String v) {
        this.name = v;
    }

    @Override
    public StatisticsExecutor getShortRunningThreadPool() {
        return this.shortRunningExecutor;
    }

    @Override
    public void setShortRunningThreadPool(BlockingExecutor executor) {
        if (trace) {
            log.trace("short running executor:" + (executor != null ? executor.getClass() : "null"));
        }
        if (executor != null) {
            this.shortRunningExecutor = executor instanceof StatisticsExecutor ? (StatisticsExecutor)executor : new StatisticsExecutorImpl(executor);
        }
    }

    @Override
    public StatisticsExecutor getLongRunningThreadPool() {
        return this.longRunningExecutor;
    }

    @Override
    public void setLongRunningThreadPool(BlockingExecutor executor) {
        if (trace) {
            log.trace("long running executor:" + (executor != null ? executor.getClass() : "null"));
        }
        if (executor != null) {
            this.longRunningExecutor = executor instanceof StatisticsExecutor ? (StatisticsExecutor)executor : new StatisticsExecutorImpl(executor);
        }
    }

    @Override
    public XATerminator getXATerminator() {
        return this.xaTerminator;
    }

    @Override
    public void setXATerminator(XATerminator xaTerminator) {
        this.xaTerminator = xaTerminator;
    }

    @Override
    public boolean isSpecCompliant() {
        return this.specCompliant;
    }

    @Override
    public void setSpecCompliant(boolean v) {
        this.specCompliant = v;
    }

    @Override
    public Callback getCallbackSecurity() {
        return this.callbackSecurity;
    }

    @Override
    public void setCallbackSecurity(Callback v) {
        this.callbackSecurity = v;
    }

    @Override
    public SecurityIntegration getSecurityIntegration() {
        return this.securityIntegration;
    }

    @Override
    public void setSecurityIntegration(SecurityIntegration v) {
        this.securityIntegration = v;
    }

    public ResourceAdapter getResourceAdapter() {
        return this.resourceAdapter;
    }

    @Override
    public void setResourceAdapter(ResourceAdapter v) {
        this.resourceAdapter = v;
    }

    @Override
    public boolean isStatisticsEnabled() {
        return this.statisticsEnabled;
    }

    @Override
    public void setStatisticsEnabled(boolean v) {
        this.statisticsEnabled = v;
    }

    @Override
    public WorkManagerStatistics getStatistics() {
        return this.statistics;
    }

    void setStatistics(WorkManagerStatisticsImpl v) {
        this.statistics = v;
    }

    @Override
    public WorkManager clone() throws CloneNotSupportedException {
        WorkManagerImpl wm = (WorkManagerImpl)super.clone();
        wm.setId(this.getId());
        wm.setName(this.getName());
        wm.setShortRunningThreadPool(this.getShortRunningThreadPool());
        wm.setLongRunningThreadPool(this.getLongRunningThreadPool());
        wm.setXATerminator(this.getXATerminator());
        wm.setSpecCompliant(this.isSpecCompliant());
        wm.setCallbackSecurity(this.getCallbackSecurity());
        wm.setSecurityIntegration(this.getSecurityIntegration());
        wm.setStatistics(this.statistics);
        return wm;
    }

    public void doWork(Work work) throws WorkException {
        this.doWork(work, Long.MAX_VALUE, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doWork(Work work, long startTimeout, ExecutionContext execContext, WorkListener workListener) throws WorkException {
        if (trace) {
            log.tracef("doWork(%s, %s, %s, %s)", new Object[]{work, startTimeout, execContext, workListener});
        }
        WorkException exception = null;
        WorkWrapper wrapper = null;
        try {
            this.doFirstChecks(work, startTimeout, execContext);
            if (workListener != null) {
                WorkEvent event = new WorkEvent((Object)this, 1, work, null);
                workListener.workAccepted(event);
            }
            this.deltaDoWorkAccepted();
            if (execContext == null) {
                execContext = new ExecutionContext();
            }
            CountDownLatch completedLatch = new CountDownLatch(1);
            wrapper = new WorkWrapper(this, this.securityIntegration, work, execContext, workListener, null, completedLatch, System.currentTimeMillis());
            this.setup(wrapper, workListener);
            BlockingExecutor executor = this.getExecutor(work);
            if (startTimeout == Long.MAX_VALUE) {
                executor.executeBlocking((Runnable)wrapper);
            } else {
                executor.executeBlocking((Runnable)wrapper, startTimeout, TimeUnit.MILLISECONDS);
            }
            completedLatch.await();
        }
        catch (ExecutionTimedOutException etoe) {
            exception = new WorkRejectedException((Throwable)etoe);
            exception.setErrorCode("1");
        }
        catch (RejectedExecutionException ree) {
            exception = new WorkRejectedException((Throwable)ree);
        }
        catch (WorkCompletedException wce) {
            if (wrapper != null) {
                wrapper.setWorkException((WorkException)((Object)wce));
            }
        }
        catch (WorkException we) {
            exception = we;
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            exception = new WorkRejectedException(bundle.interruptedWhileRequestingPermit());
        }
        finally {
            if (exception != null) {
                if (workListener != null) {
                    WorkEvent event = new WorkEvent((Object)this, 2, work, exception);
                    workListener.workRejected(event);
                }
                if (trace) {
                    log.tracef("Exception %s for %s", (Object)exception, this);
                }
                this.deltaDoWorkRejected();
                throw exception;
            }
            if (wrapper != null) {
                this.checkWorkCompletionException(wrapper);
            }
        }
    }

    public long startWork(Work work) throws WorkException {
        return this.startWork(work, Long.MAX_VALUE, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long startWork(Work work, long startTimeout, ExecutionContext execContext, WorkListener workListener) throws WorkException {
        log.tracef("startWork(%s, %s, %s, %s)", new Object[]{work, startTimeout, execContext, workListener});
        WorkException exception = null;
        WorkWrapper wrapper = null;
        try {
            long started = System.currentTimeMillis();
            this.doFirstChecks(work, startTimeout, execContext);
            if (workListener != null) {
                WorkEvent event = new WorkEvent((Object)this, 1, work, null);
                workListener.workAccepted(event);
            }
            this.deltaStartWorkAccepted();
            if (execContext == null) {
                execContext = new ExecutionContext();
            }
            CountDownLatch startedLatch = new CountDownLatch(1);
            wrapper = new WorkWrapper(this, this.securityIntegration, work, execContext, workListener, startedLatch, null, System.currentTimeMillis());
            this.setup(wrapper, workListener);
            BlockingExecutor executor = this.getExecutor(work);
            if (startTimeout == Long.MAX_VALUE) {
                executor.executeBlocking((Runnable)wrapper);
            } else {
                executor.executeBlocking((Runnable)wrapper, startTimeout, TimeUnit.MILLISECONDS);
            }
            startedLatch.await();
            long l = System.currentTimeMillis() - started;
            return l;
        }
        catch (ExecutionTimedOutException etoe) {
            exception = new WorkRejectedException((Throwable)etoe);
            exception.setErrorCode("1");
        }
        catch (RejectedExecutionException ree) {
            exception = new WorkRejectedException((Throwable)ree);
        }
        catch (WorkCompletedException wce) {
            if (wrapper != null) {
                wrapper.setWorkException((WorkException)((Object)wce));
            }
        }
        catch (WorkException we) {
            exception = we;
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            exception = new WorkRejectedException(bundle.interruptedWhileRequestingPermit());
        }
        finally {
            if (exception != null) {
                if (workListener != null) {
                    WorkEvent event = new WorkEvent((Object)this, 2, work, exception);
                    workListener.workRejected(event);
                }
                if (trace) {
                    log.tracef("Exception %s for %s", (Object)exception, this);
                }
                this.deltaStartWorkRejected();
                throw exception;
            }
            if (wrapper != null) {
                this.checkWorkCompletionException(wrapper);
            }
        }
        return -1L;
    }

    public void scheduleWork(Work work) throws WorkException {
        this.scheduleWork(work, Long.MAX_VALUE, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleWork(Work work, long startTimeout, ExecutionContext execContext, WorkListener workListener) throws WorkException {
        log.tracef("scheduleWork(%s, %s, %s, %s)", new Object[]{work, startTimeout, execContext, workListener});
        WorkException exception = null;
        WorkWrapper wrapper = null;
        try {
            this.doFirstChecks(work, startTimeout, execContext);
            if (workListener != null) {
                WorkEvent event = new WorkEvent((Object)this, 1, work, null);
                workListener.workAccepted(event);
            }
            this.deltaScheduleWorkAccepted();
            if (execContext == null) {
                execContext = new ExecutionContext();
            }
            wrapper = new WorkWrapper(this, this.securityIntegration, work, execContext, workListener, null, null, System.currentTimeMillis());
            this.setup(wrapper, workListener);
            BlockingExecutor executor = this.getExecutor(work);
            if (startTimeout == Long.MAX_VALUE) {
                executor.executeBlocking((Runnable)wrapper);
            } else {
                executor.executeBlocking((Runnable)wrapper, startTimeout, TimeUnit.MILLISECONDS);
            }
        }
        catch (ExecutionTimedOutException etoe) {
            exception = new WorkRejectedException((Throwable)etoe);
            exception.setErrorCode("1");
        }
        catch (RejectedExecutionException ree) {
            exception = new WorkRejectedException((Throwable)ree);
        }
        catch (WorkCompletedException wce) {
            if (wrapper != null) {
                wrapper.setWorkException((WorkException)((Object)wce));
            }
        }
        catch (WorkException we) {
            exception = we;
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            exception = new WorkRejectedException(bundle.interruptedWhileRequestingPermit());
        }
        finally {
            if (exception != null) {
                if (workListener != null) {
                    WorkEvent event = new WorkEvent((Object)this, 2, work, exception);
                    workListener.workRejected(event);
                }
                if (trace) {
                    log.tracef("Exception %s for %s", (Object)exception, this);
                }
                this.deltaScheduleWorkRejected();
                throw exception;
            }
            if (wrapper != null) {
                this.checkWorkCompletionException(wrapper);
            }
        }
    }

    protected void deltaDoWorkAccepted() {
        if (this.statisticsEnabled) {
            this.statistics.deltaDoWorkAccepted();
        }
    }

    protected void deltaDoWorkRejected() {
        if (this.statisticsEnabled) {
            this.statistics.deltaDoWorkRejected();
        }
    }

    protected void deltaStartWorkAccepted() {
        if (this.statisticsEnabled) {
            this.statistics.deltaStartWorkAccepted();
        }
    }

    protected void deltaStartWorkRejected() {
        if (this.statisticsEnabled) {
            this.statistics.deltaStartWorkRejected();
        }
    }

    protected void deltaScheduleWorkAccepted() {
        if (this.statisticsEnabled) {
            this.statistics.deltaScheduleWorkAccepted();
        }
    }

    protected void deltaScheduleWorkRejected() {
        if (this.statisticsEnabled) {
            this.statistics.deltaScheduleWorkRejected();
        }
    }

    protected void deltaWorkSuccessful() {
        if (this.statisticsEnabled) {
            this.statistics.deltaWorkSuccessful();
        }
    }

    protected void deltaWorkFailed() {
        if (this.statisticsEnabled) {
            this.statistics.deltaWorkFailed();
        }
    }

    public void doFirstChecks(Work work, long startTimeout, ExecutionContext execContext) throws WorkException {
        if (this.isShutdown()) {
            throw new WorkRejectedException(bundle.workmanagerShutdown());
        }
        if (work == null) {
            throw new WorkRejectedException(bundle.workIsNull());
        }
        if (startTimeout < 0L) {
            throw new WorkRejectedException(bundle.startTimeoutIsNegative(startTimeout));
        }
        this.checkAndVerifyWork(work, execContext);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean cancelShutdown() {
        if (this.scheduledGraceful != null) {
            boolean result = this.scheduledGraceful.cancel(false);
            if (!result) return false;
            this.shutdown.set(false);
            if (this.gracefulCallback != null) {
                this.gracefulCallback.cancel();
            }
            this.scheduledGraceful = null;
            this.gracefulCallback = null;
            return true;
        } else {
            if (!this.shutdown.get()) return false;
            this.shutdown.set(false);
            if (this.gracefulCallback != null) {
                this.gracefulCallback.cancel();
            }
            this.gracefulCallback = null;
        }
        return true;
    }

    @Override
    public void prepareShutdown() {
        this.prepareShutdown(0, null);
    }

    @Override
    public void prepareShutdown(GracefulCallback cb) {
        this.prepareShutdown(0, cb);
    }

    @Override
    public void prepareShutdown(int seconds) {
        this.prepareShutdown(seconds, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void prepareShutdown(int seconds, GracefulCallback cb) {
        this.shutdown.set(true);
        if (this.gracefulCallback == null) {
            this.gracefulCallback = cb;
        }
        if (seconds > 0) {
            if (this.scheduledGraceful == null) {
                if (this.scheduledExecutorService == null) {
                    this.scheduledExecutorService = Executors.newScheduledThreadPool(1);
                }
                this.scheduledGraceful = this.scheduledExecutorService.schedule(new WorkManagerShutdown(this), (long)seconds, TimeUnit.SECONDS);
            }
        } else {
            Set<WorkWrapper> set = this.activeWorkWrappers;
            synchronized (set) {
                if (this.activeWorkWrappers.isEmpty()) {
                    this.shutdown();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void shutdown() {
        this.shutdown.set(true);
        Set<WorkWrapper> set = this.activeWorkWrappers;
        synchronized (set) {
            for (WorkWrapper ww : this.activeWorkWrappers) {
                ww.getWork().release();
            }
        }
        if (this.scheduledExecutorService != null) {
            if (this.scheduledGraceful != null && !this.scheduledGraceful.isDone()) {
                this.scheduledGraceful.cancel(true);
            }
            this.scheduledGraceful = null;
            this.scheduledExecutorService.shutdownNow();
            this.scheduledExecutorService = null;
        }
        if (this.gracefulCallback != null) {
            this.gracefulCallback.done();
            this.gracefulCallback = null;
        }
    }

    @Override
    public boolean isShutdown() {
        return this.shutdown.get();
    }

    @Override
    public int getDelay() {
        if (this.scheduledGraceful != null) {
            return (int)this.scheduledGraceful.getDelay(TimeUnit.SECONDS);
        }
        if (this.shutdown.get()) {
            return Integer.MIN_VALUE;
        }
        return Integer.MAX_VALUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addWorkWrapper(WorkWrapper ww) {
        Set<WorkWrapper> set = this.activeWorkWrappers;
        synchronized (set) {
            this.activeWorkWrappers.add(ww);
            if (this.statisticsEnabled) {
                this.statistics.setWorkActive(this.activeWorkWrappers.size());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeWorkWrapper(WorkWrapper ww) {
        Set<WorkWrapper> set = this.activeWorkWrappers;
        synchronized (set) {
            this.activeWorkWrappers.remove(ww);
            if (this.statisticsEnabled) {
                this.statistics.setWorkActive(this.activeWorkWrappers.size());
            }
        }
    }

    private BlockingExecutor getExecutor(Work work) {
        StatisticsExecutor executor = this.shortRunningExecutor;
        if (this.longRunningExecutor != null && WorkManagerUtil.isLongRunning(work)) {
            executor = this.longRunningExecutor;
        }
        this.fireHintsComplete(work);
        return executor;
    }

    private void fireHintsComplete(Work work) {
        WorkContextProvider wcProvider;
        List contexts;
        if (work != null && work instanceof WorkContextProvider && (contexts = (wcProvider = (WorkContextProvider)work).getWorkContexts()) != null && !contexts.isEmpty()) {
            for (WorkContext wc : contexts) {
                HintsContext hc;
                if (!(wc instanceof HintsContext) || !((hc = (HintsContext)wc) instanceof WorkContextLifecycleListener)) continue;
                WorkContextLifecycleListener listener = (WorkContextLifecycleListener)hc;
                listener.contextSetupComplete();
            }
        }
    }

    private void checkAndVerifyWork(Work work, ExecutionContext executionContext) throws WorkException {
        if (this.specCompliant) {
            this.verifyWork(work);
        }
        if (work instanceof WorkContextProvider && executionContext != null) {
            throw new WorkRejectedException(bundle.workExecutionContextMustNullImplementsWorkContextProvider());
        }
    }

    private void verifyWork(Work work) throws WorkException {
        Class<?> workClass = work.getClass();
        String className = workClass.getName();
        if (!this.validatedWork.contains(className)) {
            if (this.isWorkMethodSynchronized(workClass, RUN_METHOD_NAME)) {
                throw new WorkException(bundle.runMethodIsSynchronized(className));
            }
            if (this.isWorkMethodSynchronized(workClass, RELEASE_METHOD_NAME)) {
                throw new WorkException(bundle.releaseMethodIsSynchronized(className));
            }
            this.validatedWork.add(className);
        }
    }

    private boolean isWorkMethodSynchronized(Class<? extends Work> workClass, String methodName) {
        try {
            Method method = SecurityActions.getMethod(workClass, methodName, new Class[0]);
            if (Modifier.isSynchronized(method.getModifiers())) {
                return true;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return false;
    }

    private void checkWorkCompletionException(WorkWrapper wrapper) throws WorkException {
        if (wrapper.getWorkException() != null) {
            if (trace) {
                log.tracef("Exception %s for %s", (Object)wrapper.getWorkException(), this);
            }
            this.deltaWorkFailed();
            throw wrapper.getWorkException();
        }
        this.deltaWorkSuccessful();
    }

    private void setup(WorkWrapper wrapper, WorkListener workListener) throws WorkCompletedException, WorkException {
        WorkContextProvider wcProvider;
        List contexts;
        if (trace) {
            log.tracef("Setting up work: %s, work listener: %s", wrapper, workListener);
        }
        Work work = wrapper.getWork();
        if (this.resourceAdapter != null) {
            if (SecurityActions.getClassLoader(work.getClass()) instanceof WorkClassLoader) {
                WorkClassLoader wcl = (WorkClassLoader)SecurityActions.getClassLoader(work.getClass());
                ResourceAdapterClassLoader racl = new ResourceAdapterClassLoader(SecurityActions.getClassLoader(this.resourceAdapter.getClass()), wcl);
                wcl.setResourceAdapterClassLoader(racl);
            }
            if (work instanceof ResourceAdapterAssociation) {
                try {
                    ResourceAdapterAssociation raa = (ResourceAdapterAssociation)work;
                    raa.setResourceAdapter(this.resourceAdapter);
                }
                catch (Throwable t) {
                    throw new WorkException(bundle.resourceAdapterAssociationFailed(work.getClass().getName()), t);
                }
            }
        }
        if (work instanceof WorkContextProvider && (contexts = (wcProvider = (WorkContextProvider)work).getWorkContexts()) != null && !contexts.isEmpty()) {
            boolean isTransactionContext = false;
            boolean isSecurityContext = false;
            boolean isHintcontext = false;
            for (WorkContext context : contexts) {
                Class<?> contextType = null;
                contextType = this.getSupportedWorkContextClass(context.getClass());
                if (contextType == null) {
                    if (trace) {
                        log.trace("Not supported work context class : " + context.getClass().getName());
                    }
                    WorkCompletedException wce = new WorkCompletedException(bundle.unsupportedWorkContextClass(context.getClass().getName()), "1");
                    this.fireWorkContextSetupFailed(context, "1", workListener, work, (WorkException)((Object)wce));
                    throw wce;
                }
                if (this.isTransactionContext(contextType)) {
                    if (isTransactionContext) {
                        if (trace) {
                            log.trace("Duplicate transaction work context : " + context.getClass().getName());
                        }
                        WorkCompletedException wce = new WorkCompletedException(bundle.duplicateTransactionWorkContextClass(context.getClass().getName()), "2");
                        this.fireWorkContextSetupFailed(context, "2", workListener, work, (WorkException)((Object)wce));
                        throw wce;
                    }
                    isTransactionContext = true;
                } else if (this.isSecurityContext(contextType)) {
                    if (isSecurityContext) {
                        if (trace) {
                            log.trace("Duplicate security work context : " + context.getClass().getName());
                        }
                        WorkCompletedException wce = new WorkCompletedException(bundle.duplicateSecurityWorkContextClass(context.getClass().getName()), "2");
                        this.fireWorkContextSetupFailed(context, "2", workListener, work, (WorkException)((Object)wce));
                        throw wce;
                    }
                    isSecurityContext = true;
                } else if (this.isHintContext(contextType)) {
                    if (isHintcontext) {
                        if (trace) {
                            log.trace("Duplicate hint work context : " + context.getClass().getName());
                        }
                        WorkCompletedException wce = new WorkCompletedException(bundle.duplicateHintWorkContextClass(context.getClass().getName()), "2");
                        this.fireWorkContextSetupFailed(context, "2", workListener, work, (WorkException)((Object)wce));
                        throw wce;
                    }
                    isHintcontext = true;
                }
                wrapper.addWorkContext(contextType, context);
            }
        }
    }

    private void fireWorkContextSetupFailed(Object workContext, String errorCode, WorkListener workListener, Work work, WorkException exception) {
        WorkEvent event;
        if (workListener != null) {
            event = new WorkEvent((Object)this, 3, work, null);
            workListener.workStarted(event);
        }
        if (workContext instanceof WorkContextLifecycleListener) {
            WorkContextLifecycleListener listener = (WorkContextLifecycleListener)workContext;
            listener.contextSetupFailed(errorCode);
        }
        if (workListener != null) {
            event = new WorkEvent((Object)this, 4, work, exception);
            workListener.workCompleted(event);
        }
    }

    private boolean isTransactionContext(Class<? extends WorkContext> workContextType) {
        return workContextType.isAssignableFrom(TransactionContext.class);
    }

    private boolean isSecurityContext(Class<? extends WorkContext> workContextType) {
        return workContextType.isAssignableFrom(SecurityContext.class);
    }

    private boolean isHintContext(Class<? extends WorkContext> workContextType) {
        return workContextType.isAssignableFrom(HintsContext.class);
    }

    private <T extends WorkContext> Class<T> getSupportedWorkContextClass(Class<T> adaptorWorkContext) {
        for (Class<? extends WorkContext> supportedWorkContext : SUPPORTED_WORK_CONTEXT_CLASSES) {
            if (!supportedWorkContext.isAssignableFrom(adaptorWorkContext)) continue;
            for (Class<T> clz = adaptorWorkContext; clz != null; clz = clz.getSuperclass()) {
                if (!clz.equals(supportedWorkContext)) continue;
                return clz;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getName()).append("@").append(Integer.toHexString(System.identityHashCode(this)));
        sb.append("[id=").append(this.getId());
        sb.append(" name=").append(this.name);
        sb.append(" specCompliant=").append(this.specCompliant);
        sb.append(" shortRunningExecutor=").append(this.shortRunningExecutor);
        sb.append(" longRunningExecutor=").append(this.longRunningExecutor);
        sb.append(" xaTerminator=").append(this.xaTerminator);
        sb.append(" validatedWork=").append(this.validatedWork);
        sb.append(" callbackSecurity=").append(this.callbackSecurity);
        sb.append(" securityIntegration=").append(this.securityIntegration);
        sb.append(" resourceAdapter=").append(this.resourceAdapter);
        sb.append(" shutdown=").append(this.shutdown);
        sb.append(" activeWorkWrappers=[");
        Set<WorkWrapper> set = this.activeWorkWrappers;
        synchronized (set) {
            if (!this.activeWorkWrappers.isEmpty()) {
                Iterator<WorkWrapper> it = this.activeWorkWrappers.iterator();
                while (it.hasNext()) {
                    WorkWrapper ww = it.next();
                    sb.append("WorkWrapper@").append(Integer.toHexString(System.identityHashCode(ww)));
                    if (!it.hasNext()) continue;
                    sb.append(", ");
                }
            }
        }
        sb.append("]");
        sb.append(" statistics=").append(this.statistics);
        this.toString(sb);
        sb.append("]");
        return sb.toString();
    }

    public void toString(StringBuilder sb) {
    }

    static {
        SUPPORTED_WORK_CONTEXT_CLASSES.add(TransactionContext.class);
        SUPPORTED_WORK_CONTEXT_CLASSES.add(SecurityContext.class);
        SUPPORTED_WORK_CONTEXT_CLASSES.add(HintsContext.class);
        SUPPORTED_WORK_CONTEXT_CLASSES.add(DistributableContext.class);
    }
}

