/*
 * Decompiled with CFR 0.152.
 */
package org.ironjacamar.core.workmanager;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import javax.resource.spi.work.ExecutionContext;
import javax.resource.spi.work.SecurityContext;
import javax.resource.spi.work.TransactionContext;
import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkCompletedException;
import javax.resource.spi.work.WorkContext;
import javax.resource.spi.work.WorkContextLifecycleListener;
import javax.resource.spi.work.WorkEvent;
import javax.resource.spi.work.WorkException;
import javax.resource.spi.work.WorkListener;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.message.callback.CallerPrincipalCallback;
import javax.security.auth.message.callback.GroupPrincipalCallback;
import javax.transaction.xa.Xid;
import org.ironjacamar.core.CoreBundle;
import org.ironjacamar.core.CoreLogger;
import org.ironjacamar.core.api.workmanager.WorkManager;
import org.ironjacamar.core.spi.security.SecurityIntegration;
import org.ironjacamar.core.workmanager.SecurityActions;
import org.ironjacamar.core.workmanager.WorkManagerImpl;
import org.jboss.logging.Logger;
import org.jboss.logging.Messages;

public class WorkWrapper
implements Runnable {
    private static CoreLogger log = (CoreLogger)Logger.getMessageLogger(CoreLogger.class, (String)WorkWrapper.class.getName());
    private static boolean trace = log.isTraceEnabled();
    private static CoreBundle bundle = (CoreBundle)Messages.getBundle(CoreBundle.class);
    private Work work;
    private ExecutionContext executionContext;
    private Map<Class<? extends WorkContext>, WorkContext> workContexts;
    private WorkListener workListener;
    private WorkManagerImpl workManager;
    private SecurityIntegration securityIntegration;
    private long startTime;
    private WorkException exception;
    private CountDownLatch startedLatch;
    private CountDownLatch completedLatch;

    public WorkWrapper(WorkManagerImpl workManager, SecurityIntegration si, Work work, ExecutionContext executionContext, WorkListener workListener, CountDownLatch startedLatch, CountDownLatch completedLatch, long startTime) {
        if (workManager == null) {
            throw new IllegalArgumentException("Null work manager");
        }
        if (si == null) {
            throw new IllegalArgumentException("Null security integration");
        }
        if (work == null) {
            throw new IllegalArgumentException("Null work");
        }
        if (executionContext == null) {
            throw new IllegalArgumentException("Null execution context");
        }
        this.workManager = workManager;
        this.securityIntegration = si;
        this.work = work;
        this.executionContext = executionContext;
        this.workListener = workListener;
        this.startedLatch = startedLatch;
        this.completedLatch = completedLatch;
        this.startTime = startTime;
        this.workContexts = null;
    }

    public WorkManager getWorkManager() {
        return this.workManager;
    }

    public Work getWork() {
        return this.work;
    }

    public ExecutionContext getExecutionContext() {
        return this.executionContext;
    }

    public WorkListener getWorkListener() {
        return this.workListener;
    }

    public WorkException getWorkException() {
        return this.exception;
    }

    void setWorkException(WorkException e) {
        this.exception = e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ClassLoader oldCL = SecurityActions.getThreadContextClassLoader();
        SecurityActions.setThreadContextClassLoader(this.work.getClass().getClassLoader());
        org.ironjacamar.core.spi.security.SecurityContext oldSC = this.securityIntegration.getSecurityContext();
        try {
            this.start();
            this.workManager.addWorkWrapper(this);
            if (this.startedLatch != null) {
                this.startedLatch.countDown();
            }
            this.work.run();
            this.end();
        }
        catch (Throwable t) {
            this.exception = new WorkCompletedException(t.getMessage(), t);
            this.cancel();
        }
        finally {
            this.workManager.removeWorkWrapper(this);
            this.work.release();
            if (this.workListener != null) {
                WorkEvent event = new WorkEvent((Object)this.workManager, 4, this.work, this.exception);
                this.workListener.workCompleted(event);
            }
            this.securityIntegration.setSecurityContext(oldSC);
            SecurityActions.setThreadContextClassLoader(oldCL);
            if (this.startedLatch != null) {
                while (this.startedLatch.getCount() != 0L) {
                    this.startedLatch.countDown();
                }
            }
            if (this.completedLatch != null) {
                this.completedLatch.countDown();
            }
            if (trace) {
                log.tracef("Executed work: %s", this);
            }
        }
    }

    protected void start() throws WorkException {
        Xid xid;
        Xid xid2;
        ExecutionContext ctx;
        if (trace) {
            log.tracef("Starting work: %s", this);
        }
        if (this.workListener != null) {
            long duration = System.currentTimeMillis() - this.startTime;
            if (duration < 0L) {
                duration = -1L;
            }
            WorkEvent event = new WorkEvent((Object)this.workManager, 3, this.work, null, duration);
            this.workListener.workStarted(event);
        }
        if ((ctx = (ExecutionContext)this.getWorkContext(TransactionContext.class)) == null) {
            ctx = this.getExecutionContext();
        }
        if (ctx != null && (xid2 = ctx.getXid()) != null) {
            long timeout = ctx.getTransactionTimeout() * 1000L;
            this.workManager.getXATerminator().registerWork(this.work, xid2, timeout);
        }
        this.fireWorkContextSetupComplete(ctx);
        SecurityContext securityContext = this.getWorkContext(SecurityContext.class);
        if (securityContext != null && this.workManager.getCallbackSecurity() != null) {
            if (trace) {
                log.tracef("Setting security context: %s", securityContext);
            }
            try {
                org.ironjacamar.core.spi.security.SecurityContext sc = null;
                CallbackHandler cbh = null;
                if (this.workManager.getCallbackSecurity() != null && this.workManager.getCallbackSecurity().isMappingRequired()) {
                    cbh = this.securityIntegration.createCallbackHandler(this.workManager.getCallbackSecurity());
                }
                if (cbh == null) {
                    cbh = this.securityIntegration.createCallbackHandler();
                }
                Subject executionSubject = null;
                Subject serviceSubject = null;
                if (trace) {
                    log.tracef("Callback security: %s", this.workManager.getCallbackSecurity());
                }
                if (this.securityIntegration.getSecurityContext() == null || this.workManager.getCallbackSecurity().getDomain() != null) {
                    String scDomain = this.workManager.getCallbackSecurity().getDomain();
                    if (trace) {
                        log.tracef("Creating security context: %s", scDomain);
                    }
                    if (scDomain == null || scDomain.trim().equals("")) {
                        this.fireWorkContextSetupFailed(securityContext);
                        throw new WorkException(bundle.securityContextSetupFailedSinceCallbackSecurityDomainWasEmpty());
                    }
                    sc = this.securityIntegration.createSecurityContext(scDomain);
                    this.securityIntegration.setSecurityContext(sc);
                } else {
                    sc = this.securityIntegration.getSecurityContext();
                    if (trace) {
                        log.tracef("Using security context: %s", sc);
                    }
                }
                executionSubject = sc.getAuthenticatedSubject();
                if (executionSubject == null) {
                    if (trace) {
                        log.tracef("Creating empty subject", new Object[0]);
                    }
                    executionSubject = new Subject();
                }
                securityContext.setupSecurityContext(cbh, executionSubject, serviceSubject);
                if (this.workManager.getCallbackSecurity() != null) {
                    ArrayList<Object> callbacks = new ArrayList<Object>();
                    if (this.workManager.getCallbackSecurity().getDefaultPrincipal() != null) {
                        Principal defaultPrincipal = this.workManager.getCallbackSecurity().getDefaultPrincipal();
                        if (trace) {
                            log.tracef("Adding default principal: %s", defaultPrincipal);
                        }
                        CallerPrincipalCallback cpc = new CallerPrincipalCallback(executionSubject, defaultPrincipal);
                        callbacks.add(cpc);
                    }
                    if (this.workManager.getCallbackSecurity().getDefaultGroups() != null) {
                        Object[] defaultGroups = this.workManager.getCallbackSecurity().getDefaultGroups();
                        if (trace) {
                            log.tracef("Adding default groups: %s", Arrays.toString(defaultGroups));
                        }
                        GroupPrincipalCallback gpc = new GroupPrincipalCallback(executionSubject, (String[])defaultGroups);
                        callbacks.add(gpc);
                    }
                    if (!callbacks.isEmpty()) {
                        Callback[] cb = new Callback[callbacks.size()];
                        cbh.handle(callbacks.toArray(cb));
                    }
                }
                if (trace) {
                    log.tracef("Setting authenticated subject (%s) on security context (%s)", executionSubject, sc);
                }
                sc.setAuthenticatedSubject(executionSubject);
                this.fireWorkContextSetupComplete(securityContext);
            }
            catch (Throwable t) {
                log.securityContextSetupFailed(t.getMessage(), t);
                this.fireWorkContextSetupFailed(securityContext);
                throw new WorkException(bundle.securityContextSetupFailed(t.getMessage()), t);
            }
        } else if (securityContext != null && this.workManager.getCallbackSecurity() == null) {
            log.securityContextSetupFailedCallbackSecurityNull();
            this.fireWorkContextSetupFailed(securityContext);
            throw new WorkException(bundle.securityContextSetupFailedSinceCallbackSecurityWasNull());
        }
        if (ctx != null && (xid = ctx.getXid()) != null) {
            this.workManager.getXATerminator().startWork(this.work, xid);
        }
        if (trace) {
            log.tracef("Started work: %s", this);
        }
    }

    protected void end() {
        Xid xid;
        ExecutionContext ctx;
        if (trace) {
            log.tracef("Ending work: %s", this);
        }
        if ((ctx = (ExecutionContext)this.getWorkContext(TransactionContext.class)) == null) {
            ctx = this.getExecutionContext();
        }
        if (ctx != null && (xid = ctx.getXid()) != null) {
            this.workManager.getXATerminator().endWork(this.work, xid);
        }
        if (trace) {
            log.tracef("Ended work: %s", this);
        }
    }

    protected void cancel() {
        Xid xid;
        ExecutionContext ctx;
        if (trace) {
            log.tracef("Cancel work: %s", this);
        }
        if ((ctx = (ExecutionContext)this.getWorkContext(TransactionContext.class)) == null) {
            ctx = this.getExecutionContext();
        }
        if (ctx != null && (xid = ctx.getXid()) != null) {
            this.workManager.getXATerminator().cancelWork(this.work, xid);
        }
        if (trace) {
            log.tracef("Canceled work: %s", this);
        }
    }

    public <T> T getWorkContext(Class<T> workContextClass) {
        T instance = null;
        if (this.workContexts != null && this.workContexts.containsKey(workContextClass)) {
            instance = workContextClass.cast(this.workContexts.get(workContextClass));
        }
        return instance;
    }

    public void addWorkContext(Class<? extends WorkContext> workContextClass, WorkContext workContext) {
        if (workContextClass == null) {
            throw new IllegalArgumentException("Work context class is null");
        }
        if (workContext == null) {
            throw new IllegalArgumentException("Work context is null");
        }
        if (this.workContexts == null) {
            this.workContexts = new HashMap<Class<? extends WorkContext>, WorkContext>(1);
        }
        if (trace) {
            log.tracef("Adding work context %s for %s", workContextClass, this);
        }
        this.workContexts.put(workContextClass, workContext);
    }

    private void fireWorkContextSetupComplete(Object workContext) {
        if (workContext != null && workContext instanceof WorkContextLifecycleListener) {
            if (trace) {
                log.tracef("WorkContextSetupComplete(%s) for %s", workContext, this);
            }
            WorkContextLifecycleListener listener = (WorkContextLifecycleListener)workContext;
            listener.contextSetupComplete();
        }
    }

    private void fireWorkContextSetupFailed(Object workContext) {
        if (workContext != null && workContext instanceof WorkContextLifecycleListener) {
            if (trace) {
                log.tracef("WorkContextSetupFailed(%s) for %s", workContext, this);
            }
            WorkContextLifecycleListener listener = (WorkContextLifecycleListener)workContext;
            listener.contextSetupFailed("3");
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(100);
        buffer.append("WorkWrapper@").append(Integer.toHexString(System.identityHashCode(this)));
        buffer.append("[workManager=").append(this.workManager);
        buffer.append(" work=").append(this.work);
        if (this.executionContext != null && this.executionContext.getXid() != null) {
            buffer.append(" xid=").append(this.executionContext.getXid());
            buffer.append(" txTimeout=").append(this.executionContext.getTransactionTimeout());
        }
        buffer.append(" workListener=").append(this.workListener);
        buffer.append(" workContexts=").append(this.workContexts);
        buffer.append(" exception=").append((Object)this.exception);
        buffer.append("]");
        return buffer.toString();
    }
}

