/*
 * Decompiled with CFR 0.152.
 */
package org.ironjacamar.core.workmanager.selector;

import java.util.Map;
import javax.resource.spi.work.DistributableWork;
import org.ironjacamar.core.CoreBundle;
import org.ironjacamar.core.CoreLogger;
import org.ironjacamar.core.spi.workmanager.Address;
import org.ironjacamar.core.workmanager.selector.AbstractSelector;
import org.jboss.logging.Logger;
import org.jboss.logging.Messages;

public class MaxFreeThreads
extends AbstractSelector {
    private static CoreLogger log = (CoreLogger)Logger.getMessageLogger(CoreLogger.class, (String)MaxFreeThreads.class.getName());
    private static boolean trace = log.isTraceEnabled();
    private static CoreBundle bundle = (CoreBundle)Messages.getBundle(CoreBundle.class);

    @Override
    public synchronized Address selectDistributedWorkManager(Address own, DistributableWork work) {
        Map<Address, Long> selectionMap = this.getSelectionMap(own.getWorkManagerId(), work);
        Address result = null;
        long freeThread = 0L;
        if (selectionMap != null) {
            for (Map.Entry<Address, Long> entry : selectionMap.entrySet()) {
                Long free;
                Address id = entry.getKey();
                if (own.equals(id) || (free = entry.getValue()) == null || free <= 0L || free <= freeThread) continue;
                result = id;
                freeThread = free;
            }
        }
        if (trace) {
            log.tracef("WorkManager: %s (%s)", result, freeThread);
        }
        return result;
    }
}

