/*
 * Decompiled with CFR 0.152.
 */
package org.ironjacamar.core.workmanager.selector;

import java.util.Map;
import javax.resource.spi.work.DistributableWork;
import org.ironjacamar.core.CoreBundle;
import org.ironjacamar.core.CoreLogger;
import org.ironjacamar.core.spi.workmanager.Address;
import org.ironjacamar.core.workmanager.selector.AbstractSelector;
import org.jboss.logging.Logger;
import org.jboss.logging.Messages;

public class PingTime
extends AbstractSelector {
    private static CoreLogger log = (CoreLogger)Logger.getMessageLogger(CoreLogger.class, (String)PingTime.class.getName());
    private static boolean trace = log.isTraceEnabled();
    private static CoreBundle bundle = (CoreBundle)Messages.getBundle(CoreBundle.class);

    @Override
    public Address selectDistributedWorkManager(Address own, DistributableWork work) {
        Map<Address, Long> selectionMap = this.getSelectionMap(own.getWorkManagerId(), work);
        Address result = null;
        long pingTime = Long.MAX_VALUE;
        if (selectionMap != null) {
            for (Map.Entry<Address, Long> entry : selectionMap.entrySet()) {
                long l;
                Long free;
                Address id = entry.getKey();
                if (own.equals(id) || (free = entry.getValue()) == null || free <= 0L || (l = Long.MAX_VALUE) >= pingTime) continue;
                result = id;
                pingTime = l;
            }
        }
        if (trace) {
            log.tracef("WorkManager: %s (%s)", result, pingTime);
        }
        return result;
    }
}

