/*
 * Decompiled with CFR 0.152.
 */
package org.ironjacamar.core.workmanager.transport.remote;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import javax.resource.spi.work.DistributableWork;
import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkException;
import org.ironjacamar.core.CoreLogger;
import org.ironjacamar.core.api.workmanager.DistributedWorkManager;
import org.ironjacamar.core.api.workmanager.DistributedWorkManagerStatisticsValues;
import org.ironjacamar.core.api.workmanager.StatisticsExecutor;
import org.ironjacamar.core.api.workmanager.WorkManager;
import org.ironjacamar.core.spi.workmanager.Address;
import org.ironjacamar.core.spi.workmanager.notification.NotificationListener;
import org.ironjacamar.core.spi.workmanager.transport.Transport;
import org.ironjacamar.core.workmanager.ClassBundle;
import org.ironjacamar.core.workmanager.ClassBundleFactory;
import org.ironjacamar.core.workmanager.WorkManagerCoordinator;
import org.ironjacamar.core.workmanager.WorkManagerEvent;
import org.ironjacamar.core.workmanager.WorkManagerEventQueue;
import org.ironjacamar.core.workmanager.transport.remote.ProtocolMessages;
import org.jboss.logging.Logger;

public abstract class AbstractRemoteTransport<T>
implements Transport {
    private static CoreLogger log = (CoreLogger)Logger.getMessageLogger(CoreLogger.class, (String)AbstractRemoteTransport.class.getName());
    private static boolean trace = log.isTraceEnabled();
    private String id;
    protected ExecutorService executorService = null;
    protected Map<Address, T> nodes = Collections.synchronizedMap(new HashMap());
    protected WorkManagerCoordinator workManagerCoordinator;

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setWorkManagerCoordinator(WorkManagerCoordinator wcc) {
        if (trace) {
            log.tracef("WorkManagerCoordinator: %s", wcc);
        }
        this.workManagerCoordinator = wcc;
    }

    @Override
    public long ping(Address address) {
        if (trace) {
            log.tracef("PING(%s)", address);
        }
        if (address.getTransportId() == null || this.getId().equals(address.getTransportId())) {
            return this.localPing();
        }
        long start = System.currentTimeMillis();
        try {
            T addr = this.nodes.get(address);
            this.sendMessage(addr, ProtocolMessages.Request.PING, new Serializable[0]);
        }
        catch (WorkException e1) {
            if (log.isDebugEnabled()) {
                log.debug("Error", e1);
            }
            return Long.MAX_VALUE;
        }
        return System.currentTimeMillis() - start;
    }

    @Override
    public long getShortRunningFree(Address address) {
        if (trace) {
            log.tracef("GET_SHORT_RUNNING_FREE(%s)", address);
        }
        if (address.getTransportId() == null || this.getId().equals(address.getTransportId())) {
            return this.localGetShortRunningFree(address);
        }
        try {
            T addr = this.nodes.get(address);
            return (Long)this.sendMessage(addr, ProtocolMessages.Request.GET_SHORTRUNNING_FREE, address);
        }
        catch (WorkException e1) {
            if (log.isDebugEnabled()) {
                log.debug("Error", e1);
            }
            return 0L;
        }
    }

    @Override
    public long getLongRunningFree(Address address) {
        if (trace) {
            log.tracef("GET_LONGRUNNING_FREE(%s)", address);
        }
        if (address.getTransportId() == null || this.getId().equals(address.getTransportId())) {
            return this.localGetLongRunningFree(address);
        }
        try {
            T addr = this.nodes.get(address);
            return (Long)this.sendMessage(addr, ProtocolMessages.Request.GET_LONGRUNNING_FREE, address);
        }
        catch (WorkException e1) {
            if (log.isDebugEnabled()) {
                log.debug("Error", e1);
            }
            return 0L;
        }
    }

    @Override
    public void updateShortRunningFree(Address address, long freeCount) {
        if (trace) {
            log.tracef("UPDATE_SHORT_RUNNING_FREE(%s, %d)", address, freeCount);
        }
        this.localUpdateShortRunningFree(address, freeCount);
        if (address.getTransportId() != null && this.getId().equals(address.getTransportId())) {
            for (Map.Entry<Address, T> entry : this.nodes.entrySet()) {
                Address a = entry.getKey();
                if (this.getId().equals(a.getTransportId())) continue;
                try {
                    this.sendMessage(entry.getValue(), ProtocolMessages.Request.UPDATE_SHORTRUNNING_FREE, address, Long.valueOf(freeCount));
                }
                catch (WorkException e1) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug("Error", e1);
                }
            }
        }
    }

    @Override
    public void updateLongRunningFree(Address address, long freeCount) {
        if (trace) {
            log.tracef("UPDATE_LONG_RUNNING_FREE(%s, %d)", address, freeCount);
        }
        this.localUpdateLongRunningFree(address, freeCount);
        if (address.getTransportId() != null && this.getId().equals(address.getTransportId())) {
            for (Map.Entry<Address, T> entry : this.nodes.entrySet()) {
                Address a = entry.getKey();
                if (this.getId().equals(a.getTransportId())) continue;
                try {
                    this.sendMessage(entry.getValue(), ProtocolMessages.Request.UPDATE_LONGRUNNING_FREE, address, Long.valueOf(freeCount));
                }
                catch (WorkException e1) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug("Error", e1);
                }
            }
        }
    }

    @Override
    public DistributedWorkManagerStatisticsValues getDistributedStatistics(Address address) {
        if (trace) {
            log.tracef("GET_DISTRIBUTED_STATISTICS(%s)", address);
        }
        if (address.getTransportId() == null || this.getId().equals(address.getTransportId())) {
            return this.localGetDistributedStatistics(address);
        }
        try {
            T addr = this.nodes.get(address);
            return (DistributedWorkManagerStatisticsValues)this.sendMessage(addr, ProtocolMessages.Request.GET_DISTRIBUTED_STATISTICS, address);
        }
        catch (WorkException e1) {
            if (log.isDebugEnabled()) {
                log.debug("Error", e1);
            }
            return null;
        }
    }

    @Override
    public void clearDistributedStatistics(Address address) {
        if (trace) {
            log.tracef("CLEAR_DISTRIBUTED_STATISTICS(%s)", address);
        }
        if (!this.getId().equals(address.getTransportId())) {
            this.localClearDistributedStatistics(address);
        }
        if (address.getTransportId() != null && this.getId().equals(address.getTransportId())) {
            for (Map.Entry<Address, T> entry : this.nodes.entrySet()) {
                Address a = entry.getKey();
                if (this.getId().equals(a.getTransportId())) continue;
                try {
                    this.sendMessage(entry.getValue(), ProtocolMessages.Request.CLEAR_DISTRIBUTED_STATISTICS, address);
                }
                catch (WorkException e1) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug("Error", e1);
                }
            }
        }
    }

    @Override
    public void deltaDoWorkAccepted(Address address) {
        block4: {
            if (trace) {
                log.tracef("DELTA_DOWORK_ACCEPTED(%s)", address);
            }
            if (address.getTransportId() != null && !this.getId().equals(address.getTransportId())) {
                try {
                    T addr = this.nodes.get(address);
                    this.sendMessage(addr, ProtocolMessages.Request.DELTA_DOWORK_ACCEPTED, address);
                }
                catch (WorkException e1) {
                    if (!log.isDebugEnabled()) break block4;
                    log.debug("Error", e1);
                }
            }
        }
    }

    @Override
    public void deltaDoWorkRejected(Address address) {
        block4: {
            if (trace) {
                log.tracef("DELTA_DOWORK_REJECTED(%s)", address);
            }
            if (address.getTransportId() != null && !this.getId().equals(address.getTransportId())) {
                try {
                    T addr = this.nodes.get(address);
                    this.sendMessage(addr, ProtocolMessages.Request.DELTA_DOWORK_REJECTED, address);
                }
                catch (WorkException e1) {
                    if (!log.isDebugEnabled()) break block4;
                    log.debug("Error", e1);
                }
            }
        }
    }

    @Override
    public void deltaStartWorkAccepted(Address address) {
        block4: {
            if (trace) {
                log.tracef("DELTA_STARTWORK_ACCEPTED(%s)", address);
            }
            if (address.getTransportId() != null && !this.getId().equals(address.getTransportId())) {
                try {
                    T addr = this.nodes.get(address);
                    this.sendMessage(addr, ProtocolMessages.Request.DELTA_STARTWORK_ACCEPTED, address);
                }
                catch (WorkException e1) {
                    if (!log.isDebugEnabled()) break block4;
                    log.debug("Error", e1);
                }
            }
        }
    }

    @Override
    public void deltaStartWorkRejected(Address address) {
        block4: {
            if (trace) {
                log.tracef("DELTA_STARTWORK_REJECTED(%s)", address);
            }
            if (address.getTransportId() != null && !this.getId().equals(address.getTransportId())) {
                try {
                    T addr = this.nodes.get(address);
                    this.sendMessage(addr, ProtocolMessages.Request.DELTA_STARTWORK_REJECTED, address);
                }
                catch (WorkException e1) {
                    if (!log.isDebugEnabled()) break block4;
                    log.debug("Error", e1);
                }
            }
        }
    }

    @Override
    public void deltaScheduleWorkAccepted(Address address) {
        block4: {
            if (trace) {
                log.tracef("DELTA_SCHEDULEWORK_ACCEPTED(%s)", address);
            }
            if (address.getTransportId() != null && !this.getId().equals(address.getTransportId())) {
                try {
                    T addr = this.nodes.get(address);
                    this.sendMessage(addr, ProtocolMessages.Request.DELTA_SCHEDULEWORK_ACCEPTED, address);
                }
                catch (WorkException e1) {
                    if (!log.isDebugEnabled()) break block4;
                    log.debug("Error", e1);
                }
            }
        }
    }

    @Override
    public void deltaScheduleWorkRejected(Address address) {
        block4: {
            if (trace) {
                log.tracef("DELTA_SCHEDULEWORK_REJECTED(%s)", address);
            }
            if (address.getTransportId() != null && !this.getId().equals(address.getTransportId())) {
                try {
                    T addr = this.nodes.get(address);
                    this.sendMessage(addr, ProtocolMessages.Request.DELTA_SCHEDULEWORK_REJECTED, address);
                }
                catch (WorkException e1) {
                    if (!log.isDebugEnabled()) break block4;
                    log.debug("Error", e1);
                }
            }
        }
    }

    @Override
    public void deltaWorkSuccessful(Address address) {
        block4: {
            if (trace) {
                log.tracef("DELTA_WORK_SUCCESSFUL(%s)", address);
            }
            if (address.getTransportId() != null && !this.getId().equals(address.getTransportId())) {
                try {
                    T addr = this.nodes.get(address);
                    this.sendMessage(addr, ProtocolMessages.Request.DELTA_WORK_SUCCESSFUL, address);
                }
                catch (WorkException e1) {
                    if (!log.isDebugEnabled()) break block4;
                    log.debug("Error", e1);
                }
            }
        }
    }

    @Override
    public void deltaWorkFailed(Address address) {
        block4: {
            if (trace) {
                log.tracef("DELTA_WORK_FAILED(%s)", address);
            }
            if (address.getTransportId() != null && !this.getId().equals(address.getTransportId())) {
                try {
                    T addr = this.nodes.get(address);
                    this.sendMessage(addr, ProtocolMessages.Request.DELTA_WORK_FAILED, address);
                }
                catch (WorkException e1) {
                    if (!log.isDebugEnabled()) break block4;
                    log.debug("Error", e1);
                }
            }
        }
    }

    @Override
    public void doWork(Address address, DistributableWork work) throws WorkException {
        if (trace) {
            log.tracef("DO_WORK(%s, %s)", address, work);
        }
        ClassBundle cb = ClassBundleFactory.createClassBundle((Serializable)work);
        T addr = this.nodes.get(address);
        this.sendMessage(addr, ProtocolMessages.Request.DO_WORK, new Serializable[]{address, cb, work});
    }

    @Override
    public void scheduleWork(Address address, DistributableWork work) throws WorkException {
        if (trace) {
            log.tracef("SCHEDULE_WORK(%s, %s)", address, work);
        }
        ClassBundle cb = ClassBundleFactory.createClassBundle((Serializable)work);
        T addr = this.nodes.get(address);
        this.sendMessage(addr, ProtocolMessages.Request.SCHEDULE_WORK, new Serializable[]{address, cb, work});
    }

    @Override
    public long startWork(Address address, DistributableWork work) throws WorkException {
        if (trace) {
            log.tracef("START_WORK(%s, %s)", address, work);
        }
        ClassBundle cb = ClassBundleFactory.createClassBundle((Serializable)work);
        T addr = this.nodes.get(address);
        return (Long)this.sendMessage(addr, ProtocolMessages.Request.START_WORK, new Serializable[]{address, cb, work});
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }

    @Override
    public void register(Address address) {
        this.nodes.put(address, null);
        if (address.getTransportId() == null || address.getTransportId().equals(this.getId())) {
            HashSet<T> sent = new HashSet<T>();
            for (T addr : this.nodes.values()) {
                if (addr == null || sent.contains(addr)) continue;
                sent.add(addr);
                try {
                    this.sendMessage(addr, ProtocolMessages.Request.WORKMANAGER_ADD, address, (Serializable)this.getOwnAddress());
                }
                catch (Throwable t) {
                    log.error("Register " + t.getMessage(), t);
                }
            }
        }
    }

    @Override
    public void unregister(Address address) {
        this.nodes.remove(address);
        if (address.getTransportId() == null || address.getTransportId().equals(this.getId())) {
            HashSet<T> sent = new HashSet<T>();
            for (T addr : this.nodes.values()) {
                if (addr == null || sent.contains(addr)) continue;
                sent.add(addr);
                try {
                    this.sendMessage(addr, ProtocolMessages.Request.WORKMANAGER_REMOVE, address);
                }
                catch (Throwable t) {
                    log.error("Unregister: " + t.getMessage(), t);
                }
            }
        }
    }

    public Set<Address> getAddresses(T physicalAddress) {
        HashSet<Address> result = new HashSet<Address>();
        for (Map.Entry<Address, T> entry : this.nodes.entrySet()) {
            if (entry.getValue() != null && !entry.getValue().equals(physicalAddress)) continue;
            result.add(entry.getKey());
        }
        if (trace) {
            log.tracef("Addresses: %s", result);
        }
        return Collections.unmodifiableSet(result);
    }

    public void join(Address logicalAddress, T physicalAddress) {
        if (trace) {
            log.tracef("JOIN(%s, %s)", logicalAddress, physicalAddress);
        }
        if (!this.nodes.containsKey(logicalAddress)) {
            this.nodes.put(logicalAddress, physicalAddress);
            DistributedWorkManager dwm = this.workManagerCoordinator.resolveDistributedWorkManager(logicalAddress);
            if (dwm != null) {
                ArrayList<NotificationListener> copy = new ArrayList<NotificationListener>(dwm.getNotificationListeners());
                for (NotificationListener nl : copy) {
                    nl.join(logicalAddress);
                }
            } else {
                WorkManagerEventQueue wmeq = WorkManagerEventQueue.getInstance();
                wmeq.addEvent(new WorkManagerEvent(0, logicalAddress));
            }
        }
    }

    public void leave(T physicalAddress) {
        if (trace) {
            log.tracef("LEAVE(%s)", physicalAddress);
        }
        HashSet<Address> remove = new HashSet<Address>();
        for (Map.Entry<Address, T> entry : this.nodes.entrySet()) {
            if (!physicalAddress.equals(entry.getValue())) continue;
            remove.add(entry.getKey());
        }
        if (!remove.isEmpty()) {
            for (Address logicalAddress : remove) {
                this.nodes.remove(logicalAddress);
                DistributedWorkManager dwm = this.workManagerCoordinator.resolveDistributedWorkManager(logicalAddress);
                if (dwm != null) {
                    ArrayList<NotificationListener> copy = new ArrayList<NotificationListener>(dwm.getNotificationListeners());
                    for (NotificationListener nl : copy) {
                        nl.leave(logicalAddress);
                    }
                    continue;
                }
                WorkManagerEventQueue wmeq = WorkManagerEventQueue.getInstance();
                wmeq.addEvent(new WorkManagerEvent(1, logicalAddress));
            }
        }
    }

    public long localPing() {
        if (trace) {
            log.tracef("LOCAL_PING()", new Object[0]);
        }
        return 0L;
    }

    public void localWorkManagerAdd(Address address, T physicalAddress) {
        if (trace) {
            log.tracef("LOCAL_WORKMANAGER_ADD(%s, %s)", address, physicalAddress);
        }
        this.join(address, physicalAddress);
    }

    public void localWorkManagerRemove(Address address) {
        if (trace) {
            log.tracef("LOCAL_WORKMANAGER_REMOVE(%s)", address);
        }
        this.nodes.remove(address);
        DistributedWorkManager dwm = this.workManagerCoordinator.resolveDistributedWorkManager(address);
        if (dwm != null) {
            ArrayList<NotificationListener> copy = new ArrayList<NotificationListener>(dwm.getNotificationListeners());
            for (NotificationListener nl : copy) {
                nl.leave(address);
            }
        } else {
            WorkManagerEventQueue wmeq = WorkManagerEventQueue.getInstance();
            wmeq.addEvent(new WorkManagerEvent(1, address));
        }
    }

    public void localDoWork(Address address, DistributableWork work) throws WorkException {
        if (trace) {
            log.tracef("LOCAL_DO_WORK(%s, %s)", address, work);
        }
        DistributedWorkManager dwm = this.workManagerCoordinator.resolveDistributedWorkManager(address);
        dwm.localDoWork((Work)work);
    }

    public long localStartWork(Address address, DistributableWork work) throws WorkException {
        if (trace) {
            log.tracef("LOCAL_START_WORK(%s, %s)", address, work);
        }
        DistributedWorkManager dwm = this.workManagerCoordinator.resolveDistributedWorkManager(address);
        return dwm.localStartWork((Work)work);
    }

    public void localScheduleWork(Address address, DistributableWork work) throws WorkException {
        if (trace) {
            log.tracef("LOCAL_SCHEDULE_WORK(%s, %s)", address, work);
        }
        DistributedWorkManager dwm = this.workManagerCoordinator.resolveDistributedWorkManager(address);
        dwm.localScheduleWork((Work)work);
    }

    public long localGetShortRunningFree(Address address) {
        StatisticsExecutor executor;
        WorkManager wm;
        if (trace) {
            log.tracef("LOCAL_GET_SHORTRUNNING_FREE(%s)", address);
        }
        if ((wm = this.workManagerCoordinator.resolveWorkManager(address)) != null && (executor = wm.getShortRunningThreadPool()) != null) {
            return executor.getNumberOfFreeThreads();
        }
        return 0L;
    }

    public long localGetLongRunningFree(Address address) {
        StatisticsExecutor executor;
        WorkManager wm;
        if (trace) {
            log.tracef("LOCAL_GET_LONGRUNNING_FREE(%s)", address);
        }
        if ((wm = this.workManagerCoordinator.resolveWorkManager(address)) != null && (executor = wm.getLongRunningThreadPool()) != null) {
            return executor.getNumberOfFreeThreads();
        }
        return 0L;
    }

    public void localUpdateShortRunningFree(Address logicalAddress, Long freeCount) {
        DistributedWorkManager dwm;
        if (trace) {
            log.tracef("LOCAL_UPDATE_SHORTRUNNING_FREE(%s, %d)", logicalAddress, freeCount);
        }
        if ((dwm = this.workManagerCoordinator.resolveDistributedWorkManager(logicalAddress)) != null) {
            ArrayList<NotificationListener> copy = new ArrayList<NotificationListener>(dwm.getNotificationListeners());
            for (NotificationListener nl : copy) {
                nl.updateShortRunningFree(logicalAddress, freeCount);
            }
        } else {
            WorkManagerEventQueue wmeq = WorkManagerEventQueue.getInstance();
            wmeq.addEvent(new WorkManagerEvent(2, logicalAddress, freeCount));
        }
    }

    public void localUpdateLongRunningFree(Address logicalAddress, Long freeCount) {
        DistributedWorkManager dwm;
        if (trace) {
            log.tracef("LOCAL_UPDATE_LONGRUNNING_FREE(%s, %d)", logicalAddress, freeCount);
        }
        if ((dwm = this.workManagerCoordinator.resolveDistributedWorkManager(logicalAddress)) != null) {
            ArrayList<NotificationListener> copy = new ArrayList<NotificationListener>(dwm.getNotificationListeners());
            for (NotificationListener nl : copy) {
                nl.updateLongRunningFree(logicalAddress, freeCount);
            }
        } else {
            WorkManagerEventQueue wmeq = WorkManagerEventQueue.getInstance();
            wmeq.addEvent(new WorkManagerEvent(3, logicalAddress, freeCount));
        }
    }

    public DistributedWorkManagerStatisticsValues localGetDistributedStatistics(Address address) {
        DistributedWorkManager dwm;
        if (trace) {
            log.tracef("LOCAL_GET_DISTRIBUTED_STATISTICS(%s)", address);
        }
        if ((dwm = this.workManagerCoordinator.resolveDistributedWorkManager(address)) != null) {
            DistributedWorkManagerStatisticsValues values = new DistributedWorkManagerStatisticsValues(dwm.getDistributedStatistics().getWorkSuccessful(), dwm.getDistributedStatistics().getWorkFailed(), dwm.getDistributedStatistics().getDoWorkAccepted(), dwm.getDistributedStatistics().getDoWorkRejected(), dwm.getDistributedStatistics().getScheduleWorkAccepted(), dwm.getDistributedStatistics().getScheduleWorkRejected(), dwm.getDistributedStatistics().getStartWorkAccepted(), dwm.getDistributedStatistics().getStartWorkRejected());
            return values;
        }
        return null;
    }

    public void localClearDistributedStatistics(Address logicalAddress) {
        DistributedWorkManager dwm;
        if (trace) {
            log.tracef("LOCAL_CLEAR_DISTRIBUTED_STATISTICS(%s)", logicalAddress);
        }
        if ((dwm = this.workManagerCoordinator.resolveDistributedWorkManager(logicalAddress)) != null && dwm.isDistributedStatisticsEnabled()) {
            DistributedWorkManagerStatisticsValues v = new DistributedWorkManagerStatisticsValues(0, 0, 0, 0, 0, 0, 0, 0);
            dwm.getDistributedStatistics().initialize(v);
        }
    }

    public void localDeltaDoWorkAccepted(Address address) {
        DistributedWorkManager dwm;
        if (trace) {
            log.tracef("LOCAL_DELTA_DOWORK_ACCEPTED(%s)", address);
        }
        if ((dwm = this.workManagerCoordinator.resolveDistributedWorkManager(address)) != null) {
            ArrayList<NotificationListener> copy = new ArrayList<NotificationListener>(dwm.getNotificationListeners());
            for (NotificationListener nl : copy) {
                nl.deltaDoWorkAccepted();
            }
        }
    }

    public void localDeltaDoWorkRejected(Address address) {
        DistributedWorkManager dwm;
        if (trace) {
            log.tracef("LOCAL_DELTA_DOWORK_REJECTED(%s)", address);
        }
        if ((dwm = this.workManagerCoordinator.resolveDistributedWorkManager(address)) != null) {
            ArrayList<NotificationListener> copy = new ArrayList<NotificationListener>(dwm.getNotificationListeners());
            for (NotificationListener nl : copy) {
                nl.deltaDoWorkRejected();
            }
        }
    }

    public void localDeltaStartWorkAccepted(Address address) {
        DistributedWorkManager dwm;
        if (trace) {
            log.tracef("LOCAL_DELTA_STARTWORK_ACCEPTED(%s)", address);
        }
        if ((dwm = this.workManagerCoordinator.resolveDistributedWorkManager(address)) != null) {
            ArrayList<NotificationListener> copy = new ArrayList<NotificationListener>(dwm.getNotificationListeners());
            for (NotificationListener nl : copy) {
                nl.deltaStartWorkAccepted();
            }
        }
    }

    public void localDeltaStartWorkRejected(Address address) {
        DistributedWorkManager dwm;
        if (trace) {
            log.tracef("LOCAL_DELTA_STARTWORK_REJECTED(%s)", address);
        }
        if ((dwm = this.workManagerCoordinator.resolveDistributedWorkManager(address)) != null) {
            ArrayList<NotificationListener> copy = new ArrayList<NotificationListener>(dwm.getNotificationListeners());
            for (NotificationListener nl : copy) {
                nl.deltaStartWorkRejected();
            }
        }
    }

    public void localDeltaScheduleWorkAccepted(Address address) {
        DistributedWorkManager dwm;
        if (trace) {
            log.tracef("LOCAL_DELTA_SCHEDULEWORK_ACCEPTED(%s)", address);
        }
        if ((dwm = this.workManagerCoordinator.resolveDistributedWorkManager(address)) != null) {
            ArrayList<NotificationListener> copy = new ArrayList<NotificationListener>(dwm.getNotificationListeners());
            for (NotificationListener nl : copy) {
                nl.deltaScheduleWorkAccepted();
            }
        }
    }

    public void localDeltaScheduleWorkRejected(Address address) {
        DistributedWorkManager dwm;
        if (trace) {
            log.tracef("LOCAL_DELTA_SCHEDULEWORK_REJECTED(%s)", address);
        }
        if ((dwm = this.workManagerCoordinator.resolveDistributedWorkManager(address)) != null) {
            ArrayList<NotificationListener> copy = new ArrayList<NotificationListener>(dwm.getNotificationListeners());
            for (NotificationListener nl : copy) {
                nl.deltaScheduleWorkRejected();
            }
        }
    }

    public void localDeltaWorkSuccessful(Address address) {
        DistributedWorkManager dwm;
        if (trace) {
            log.tracef("LOCAL_DELTA_WORK_SUCCESSFUL(%s)", address);
        }
        if ((dwm = this.workManagerCoordinator.resolveDistributedWorkManager(address)) != null) {
            ArrayList<NotificationListener> copy = new ArrayList<NotificationListener>(dwm.getNotificationListeners());
            for (NotificationListener nl : copy) {
                nl.deltaWorkSuccessful();
            }
        }
    }

    public void localDeltaWorkFailed(Address address) {
        DistributedWorkManager dwm;
        if (trace) {
            log.tracef("LOCAL_DELTA_WORK_FAILED(%s)", address);
        }
        if ((dwm = this.workManagerCoordinator.resolveDistributedWorkManager(address)) != null) {
            ArrayList<NotificationListener> copy = new ArrayList<NotificationListener>(dwm.getNotificationListeners());
            for (NotificationListener nl : copy) {
                nl.deltaWorkFailed();
            }
        }
    }

    protected abstract T getOwnAddress();

    protected abstract Serializable sendMessage(T var1, ProtocolMessages.Request var2, Serializable ... var3) throws WorkException;
}

