/*
 * Decompiled with CFR 0.152.
 */
package org.ironjacamar.core.workmanager.transport.remote.socket;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.Socket;
import java.util.Arrays;
import java.util.Set;
import javax.resource.spi.work.DistributableWork;
import javax.resource.spi.work.WorkException;
import org.ironjacamar.core.CoreBundle;
import org.ironjacamar.core.CoreLogger;
import org.ironjacamar.core.spi.workmanager.Address;
import org.ironjacamar.core.workmanager.ClassBundle;
import org.ironjacamar.core.workmanager.WorkClassLoader;
import org.ironjacamar.core.workmanager.WorkObjectInputStream;
import org.ironjacamar.core.workmanager.transport.remote.ProtocolMessages;
import org.ironjacamar.core.workmanager.transport.remote.socket.SecurityActions;
import org.ironjacamar.core.workmanager.transport.remote.socket.SocketTransport;
import org.jboss.logging.Logger;
import org.jboss.logging.Messages;

public class Communication
implements Runnable {
    private static CoreLogger log = (CoreLogger)Logger.getMessageLogger(CoreLogger.class, (String)Communication.class.getName());
    private static boolean trace = log.isTraceEnabled();
    private static CoreBundle bundle = (CoreBundle)Messages.getBundle(CoreBundle.class);
    private final Socket socket;
    private final SocketTransport transport;

    public Communication(SocketTransport transport, Socket socket) {
        this.socket = socket;
        this.transport = transport;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        WorkObjectInputStream wois = null;
        Object oos = null;
        Serializable returnValue = null;
        ProtocolMessages.Response response = null;
        try {
            wois = new WorkObjectInputStream(this.socket.getInputStream());
            int commandOrdinalPosition = wois.readInt();
            int numberOfParameters = wois.readInt();
            ProtocolMessages.Request command = ProtocolMessages.Request.values()[commandOrdinalPosition];
            switch (command) {
                case JOIN: {
                    Set workManagers;
                    if (numberOfParameters != 1) {
                        throw new IllegalArgumentException(bundle.invalidNumberOfParameters(numberOfParameters, "JOIN"));
                    }
                    String address = (String)wois.readObject();
                    if (trace) {
                        log.tracef("%s: JOIN(%s)", this.socket.getInetAddress(), address);
                    }
                    if ((workManagers = (Set)((Object)this.transport.sendMessage(address, ProtocolMessages.Request.GET_WORKMANAGERS, new Serializable[0]))) != null) {
                        for (Address a : workManagers) {
                            this.transport.join(a, address);
                            long shortRunningFree = (Long)this.transport.sendMessage(address, ProtocolMessages.Request.GET_SHORTRUNNING_FREE, new Serializable[]{a});
                            long longRunningFree = (Long)this.transport.sendMessage(address, ProtocolMessages.Request.GET_LONGRUNNING_FREE, new Serializable[]{a});
                            this.transport.localUpdateShortRunningFree(a, shortRunningFree);
                            this.transport.localUpdateLongRunningFree(a, longRunningFree);
                        }
                    }
                    response = ProtocolMessages.Response.OK_VOID;
                    break;
                }
                case LEAVE: {
                    if (numberOfParameters != 1) {
                        throw new IllegalArgumentException(bundle.invalidNumberOfParameters(numberOfParameters, "LEAVE"));
                    }
                    String address = (String)wois.readObject();
                    if (trace) {
                        log.tracef("%s: LEAVE(%s)", this.socket.getInetAddress(), address);
                    }
                    this.transport.leave(address);
                    response = ProtocolMessages.Response.OK_VOID;
                    break;
                }
                case GET_WORKMANAGERS: {
                    if (numberOfParameters != 0) {
                        throw new IllegalArgumentException(bundle.invalidNumberOfParameters(numberOfParameters, "GET_WORKMANAGERS"));
                    }
                    if (trace) {
                        log.tracef("%s: GET_WORKMANAGERS()", this.socket.getInetAddress());
                    }
                    returnValue = (Serializable)((Object)this.transport.getAddresses(this.transport.getOwnAddress()));
                    response = ProtocolMessages.Response.OK_SERIALIZABLE;
                    break;
                }
                case WORKMANAGER_ADD: {
                    if (numberOfParameters != 2) {
                        throw new IllegalArgumentException(bundle.invalidNumberOfParameters(numberOfParameters, "WORKMANAGER_ADD"));
                    }
                    Address id = (Address)wois.readObject();
                    String address = (String)wois.readObject();
                    if (trace) {
                        log.tracef("%s: WORKMANAGER_ADD(%s, %s)", this.socket.getInetAddress(), id, address);
                    }
                    this.transport.localWorkManagerAdd(id, address);
                    response = ProtocolMessages.Response.OK_VOID;
                    break;
                }
                case WORKMANAGER_REMOVE: {
                    if (numberOfParameters != 1) {
                        throw new IllegalArgumentException(bundle.invalidNumberOfParameters(numberOfParameters, "WORKMANAGER_REMOVE"));
                    }
                    Address id = (Address)wois.readObject();
                    if (trace) {
                        log.tracef("%s: WORKMANAGER_REMOVE(%s)", this.socket.getInetAddress(), id);
                    }
                    this.transport.localWorkManagerRemove(id);
                    response = ProtocolMessages.Response.OK_VOID;
                    break;
                }
                case PING: {
                    if (numberOfParameters != 0) {
                        throw new IllegalArgumentException(bundle.invalidNumberOfParameters(numberOfParameters, "PING"));
                    }
                    if (trace) {
                        log.tracef("%s: PING()", this.socket.getInetAddress());
                    }
                    this.transport.localPing();
                    response = ProtocolMessages.Response.OK_VOID;
                    break;
                }
                case DO_WORK: {
                    if (numberOfParameters != 3) {
                        throw new IllegalArgumentException(bundle.invalidNumberOfParameters(numberOfParameters, "DO_WORK"));
                    }
                    Address id = (Address)wois.readObject();
                    ClassBundle cb = (ClassBundle)wois.readObject();
                    if (trace) {
                        log.tracef("DO_WORK/ClassBundle: %s", cb);
                    }
                    WorkClassLoader wcl = SecurityActions.createWorkClassLoader(cb);
                    wois.setWorkClassLoader(wcl);
                    DistributableWork work = (DistributableWork)wois.readObject();
                    if (trace) {
                        log.tracef("%s: DO_WORK(%s, %s)", this.socket.getInetAddress(), id, work);
                    }
                    this.transport.localDoWork(id, work);
                    response = ProtocolMessages.Response.OK_VOID;
                    break;
                }
                case START_WORK: {
                    if (numberOfParameters != 3) {
                        throw new IllegalArgumentException(bundle.invalidNumberOfParameters(numberOfParameters, "START_WORK"));
                    }
                    Address id = (Address)wois.readObject();
                    ClassBundle cb = (ClassBundle)wois.readObject();
                    if (trace) {
                        log.tracef("START_WORK/ClassBundle: %s", cb);
                    }
                    WorkClassLoader wcl = SecurityActions.createWorkClassLoader(cb);
                    wois.setWorkClassLoader(wcl);
                    DistributableWork work = (DistributableWork)wois.readObject();
                    if (trace) {
                        log.tracef("%s: START_WORK(%s, %s)", this.socket.getInetAddress(), id, work);
                    }
                    returnValue = Long.valueOf(this.transport.localStartWork(id, work));
                    response = ProtocolMessages.Response.OK_SERIALIZABLE;
                    break;
                }
                case SCHEDULE_WORK: {
                    if (numberOfParameters != 3) {
                        throw new IllegalArgumentException(bundle.invalidNumberOfParameters(numberOfParameters, "SCHEDULE_WORK"));
                    }
                    Address id = (Address)wois.readObject();
                    ClassBundle cb = (ClassBundle)wois.readObject();
                    if (trace) {
                        log.tracef("SCHEDULE_WORK/ClassBundle: %s", cb);
                    }
                    WorkClassLoader wcl = SecurityActions.createWorkClassLoader(cb);
                    wois.setWorkClassLoader(wcl);
                    DistributableWork work = (DistributableWork)wois.readObject();
                    if (trace) {
                        log.tracef("%s: SCHEDULE_WORK(%s, %s)", this.socket.getInetAddress(), id, work);
                    }
                    this.transport.localScheduleWork(id, work);
                    response = ProtocolMessages.Response.OK_VOID;
                    break;
                }
                case GET_SHORTRUNNING_FREE: {
                    if (numberOfParameters != 1) {
                        throw new IllegalArgumentException(bundle.invalidNumberOfParameters(numberOfParameters, "GET_SHORTRUNNING_FREE"));
                    }
                    Address id = (Address)wois.readObject();
                    if (trace) {
                        log.tracef("%s: GET_SHORTRUNNING_FREE(%s)", this.socket.getInetAddress(), id);
                    }
                    returnValue = Long.valueOf(this.transport.localGetShortRunningFree(id));
                    response = ProtocolMessages.Response.OK_SERIALIZABLE;
                    break;
                }
                case GET_LONGRUNNING_FREE: {
                    if (numberOfParameters != 1) {
                        throw new IllegalArgumentException(bundle.invalidNumberOfParameters(numberOfParameters, "GET_LONGRUNNING_FREE"));
                    }
                    Address id = (Address)wois.readObject();
                    if (trace) {
                        log.tracef("%s: GET_LONGRUNNING_FREE(%s)", this.socket.getInetAddress(), id);
                    }
                    returnValue = Long.valueOf(this.transport.localGetLongRunningFree(id));
                    response = ProtocolMessages.Response.OK_SERIALIZABLE;
                    break;
                }
                case UPDATE_SHORTRUNNING_FREE: {
                    if (numberOfParameters != 2) {
                        throw new IllegalArgumentException(bundle.invalidNumberOfParameters(numberOfParameters, "UPDATE_SHORTRUNNING_FREE"));
                    }
                    Address id = (Address)wois.readObject();
                    Long freeCount = (Long)wois.readObject();
                    if (trace) {
                        log.tracef("%s: UPDATE_SHORTRUNNING_FREE(%s, %d)", this.socket.getInetAddress(), id, freeCount);
                    }
                    this.transport.localUpdateShortRunningFree(id, freeCount);
                    response = ProtocolMessages.Response.OK_VOID;
                    break;
                }
                case UPDATE_LONGRUNNING_FREE: {
                    if (numberOfParameters != 2) {
                        throw new IllegalArgumentException(bundle.invalidNumberOfParameters(numberOfParameters, "UPDATE_LONGRUNNING_FREE"));
                    }
                    Address id = (Address)wois.readObject();
                    Long freeCount = (Long)wois.readObject();
                    if (trace) {
                        log.tracef("%s: UPDATE_LONGRUNNING_FREE(%s, %d)", this.socket.getInetAddress(), id, freeCount);
                    }
                    this.transport.localUpdateLongRunningFree(id, freeCount);
                    response = ProtocolMessages.Response.OK_VOID;
                    break;
                }
                case GET_DISTRIBUTED_STATISTICS: {
                    if (numberOfParameters != 1) {
                        throw new IllegalArgumentException(bundle.invalidNumberOfParameters(numberOfParameters, "GET_DISTRIBUTED_STATISTICS"));
                    }
                    Address id = (Address)wois.readObject();
                    if (trace) {
                        log.tracef("%s: GET_DISTRIBUTED_STATISTICS(%s)", this.socket.getInetAddress(), id);
                    }
                    returnValue = this.transport.localGetDistributedStatistics(id);
                    response = ProtocolMessages.Response.OK_SERIALIZABLE;
                    break;
                }
                case CLEAR_DISTRIBUTED_STATISTICS: {
                    if (numberOfParameters != 1) {
                        throw new IllegalArgumentException(bundle.invalidNumberOfParameters(numberOfParameters, "CLEAR_DISTRIBUTED_STATISTICS"));
                    }
                    Address id = (Address)wois.readObject();
                    if (trace) {
                        log.tracef("%s: CLEAR_DISTRIBUTED_STATISTICS(%s)", this.socket.getInetAddress(), id);
                    }
                    this.transport.localClearDistributedStatistics(id);
                    response = ProtocolMessages.Response.OK_VOID;
                    break;
                }
                case DELTA_DOWORK_ACCEPTED: {
                    if (numberOfParameters != 1) {
                        throw new IllegalArgumentException(bundle.invalidNumberOfParameters(numberOfParameters, "DELTA_DOWORK_ACCEPTED"));
                    }
                    Address id = (Address)wois.readObject();
                    if (trace) {
                        log.tracef("%s: DELTA_DOWORK_ACCEPTED(%s)", this.socket.getInetAddress(), id);
                    }
                    this.transport.localDeltaDoWorkAccepted(id);
                    response = ProtocolMessages.Response.OK_VOID;
                    break;
                }
                case DELTA_DOWORK_REJECTED: {
                    if (numberOfParameters != 1) {
                        throw new IllegalArgumentException(bundle.invalidNumberOfParameters(numberOfParameters, "DELTA_DOWORK_REJECTED"));
                    }
                    Address id = (Address)wois.readObject();
                    if (trace) {
                        log.tracef("%s: DELTA_DOWORK_REJECTED(%s)", this.socket.getInetAddress(), id);
                    }
                    this.transport.localDeltaDoWorkRejected(id);
                    response = ProtocolMessages.Response.OK_VOID;
                    break;
                }
                case DELTA_STARTWORK_ACCEPTED: {
                    if (numberOfParameters != 1) {
                        throw new IllegalArgumentException(bundle.invalidNumberOfParameters(numberOfParameters, "DELTA_STARTWORK_ACCEPTED"));
                    }
                    Address id = (Address)wois.readObject();
                    if (trace) {
                        log.tracef("%s: DELTA_STARTWORK_ACCEPTED(%s)", this.socket.getInetAddress(), id);
                    }
                    this.transport.localDeltaStartWorkAccepted(id);
                    response = ProtocolMessages.Response.OK_VOID;
                    break;
                }
                case DELTA_STARTWORK_REJECTED: {
                    if (numberOfParameters != 1) {
                        throw new IllegalArgumentException(bundle.invalidNumberOfParameters(numberOfParameters, "DELTA_STARTWORK_REJECTED"));
                    }
                    Address id = (Address)wois.readObject();
                    if (trace) {
                        log.tracef("%s: DELTA_STARTWORK_REJECTED(%s)", this.socket.getInetAddress(), id);
                    }
                    this.transport.localDeltaStartWorkRejected(id);
                    response = ProtocolMessages.Response.OK_VOID;
                    break;
                }
                case DELTA_SCHEDULEWORK_ACCEPTED: {
                    if (numberOfParameters != 1) {
                        throw new IllegalArgumentException(bundle.invalidNumberOfParameters(numberOfParameters, "DELTA_SCHEDULEWORK_ACCEPTED"));
                    }
                    Address id = (Address)wois.readObject();
                    if (trace) {
                        log.tracef("%s: DELTA_SCHEDULEWORK_ACCEPTED(%s)", this.socket.getInetAddress(), id);
                    }
                    this.transport.localDeltaScheduleWorkAccepted(id);
                    response = ProtocolMessages.Response.OK_VOID;
                    break;
                }
                case DELTA_SCHEDULEWORK_REJECTED: {
                    if (numberOfParameters != 1) {
                        throw new IllegalArgumentException(bundle.invalidNumberOfParameters(numberOfParameters, "DELTA_SCHEDULEWORK_REJECTED"));
                    }
                    Address id = (Address)wois.readObject();
                    if (trace) {
                        log.tracef("%s: DELTA_SCHEDULEWORK_REJECTED(%s)", this.socket.getInetAddress(), id);
                    }
                    this.transport.localDeltaScheduleWorkRejected(id);
                    response = ProtocolMessages.Response.OK_VOID;
                    break;
                }
                case DELTA_WORK_SUCCESSFUL: {
                    if (numberOfParameters != 1) {
                        throw new IllegalArgumentException(bundle.invalidNumberOfParameters(numberOfParameters, "DELTA_WORK_SUCCESSFUL"));
                    }
                    Address id = (Address)wois.readObject();
                    if (trace) {
                        log.tracef("%s: DELTA_WORK_SUCCESSFUL(%s)", this.socket.getInetAddress(), id);
                    }
                    this.transport.localDeltaWorkSuccessful(id);
                    response = ProtocolMessages.Response.OK_VOID;
                    break;
                }
                case DELTA_WORK_FAILED: {
                    if (numberOfParameters != 1) {
                        throw new IllegalArgumentException(bundle.invalidNumberOfParameters(numberOfParameters, "DELTA_WORK_FAILED"));
                    }
                    Address id = (Address)wois.readObject();
                    if (trace) {
                        log.tracef("%s: DELTA_WORK_FAILED(%s)", this.socket.getInetAddress(), id);
                    }
                    this.transport.localDeltaWorkFailed(id);
                    response = ProtocolMessages.Response.OK_VOID;
                    break;
                }
                default: {
                    if (!log.isDebugEnabled()) break;
                    log.debug("Unknown command received on socket Transport");
                }
            }
            if (response != null) {
                this.sendResponse(response, returnValue);
            } else {
                this.sendResponse(ProtocolMessages.Response.GENERIC_EXCEPTION, new Exception("Unknown command: " + commandOrdinalPosition));
            }
        }
        catch (WorkException we) {
            if (trace) {
                log.tracef("%s: WORK_EXCEPTION(%s)", this.socket.getInetAddress(), we.getMessage());
            }
            this.sendResponse(ProtocolMessages.Response.WORK_EXCEPTION, new Serializable[]{we});
        }
        catch (Throwable t) {
            if (trace) {
                log.tracef("%s: THROWABLE(%s)", this.socket.getInetAddress(), t.getMessage());
            }
            this.sendResponse(ProtocolMessages.Response.GENERIC_EXCEPTION, t);
        }
        finally {
            if (wois != null) {
                try {
                    wois.close();
                }
                catch (IOException we) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendResponse(ProtocolMessages.Response response, Serializable ... parameters) {
        if (trace) {
            log.tracef("Sending response: %s with %s", (Object)response, parameters != null ? Arrays.toString(parameters) : "null");
        }
        ObjectOutputStream oos = null;
        try {
            oos = new ObjectOutputStream(this.socket.getOutputStream());
            oos.writeInt(response.ordinal());
            oos.writeInt(response.getNumberOfParameter());
            if (response.getNumberOfParameter() > 0 && parameters != null) {
                for (Serializable o : parameters) {
                    oos.writeObject(o);
                }
            }
            oos.flush();
        }
        catch (Throwable t) {
            if (log.isDebugEnabled()) {
                log.debugf("Error sending response: %s", t.getMessage());
            }
        }
        finally {
            if (oos != null) {
                try {
                    oos.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

