/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.descriptor.metadata.codegen;

import com.sun.codemodel.ClassType;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JDocComment;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JType;
import com.sun.codemodel.JTypeVar;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.text.WordUtils;
import org.jboss.shrinkwrap.descriptor.api.Child;
import org.jboss.shrinkwrap.descriptor.metadata.Metadata;
import org.jboss.shrinkwrap.descriptor.metadata.MetadataElement;
import org.jboss.shrinkwrap.descriptor.metadata.MetadataEnum;
import org.jboss.shrinkwrap.descriptor.metadata.MetadataItem;

public class CodeGen {
    private final Metadata metadata;

    public CodeGen(Metadata metadata) {
        this.metadata = metadata;
    }

    public void generateEnums() throws JClassAlreadyExistsException, IOException {
        JCodeModel cm = new JCodeModel();
        for (MetadataEnum metadataEnum : this.metadata.getEnumList()) {
            String fqnEnum = metadataEnum.getPackageApi() + "." + CodeGen.getPascalizeCase(metadataEnum.getName());
            JDefinedClass dc = cm._class(fqnEnum, ClassType.ENUM);
            JDocComment javaDocComment = dc.javadoc();
            Map part = javaDocComment.addXdoclet("author");
            part.put("<a href", "'mailto:ralf.battenfeld@bluewin.ch'>Ralf Battenfeld</a>");
            for (String enumConstant : metadataEnum.getValueList()) {
                dc.enumConstant(CodeGen.getEnumConstantName(enumConstant));
            }
            JMethod toStringMethod = dc.method(1, String.class, "toString");
            toStringMethod.body()._return(JExpr.direct((String)"name().substring(1)"));
        }
        File file = new File("./src/test/java");
        file.mkdirs();
        cm.build(file);
    }

    public void generateInferfaces() throws JClassAlreadyExistsException, IOException, ClassNotFoundException {
        JCodeModel cm = new JCodeModel();
        JDefinedClass childInterface = cm._class("org.jboss.shrinkwrap.descriptor.api.ChildFFF", ClassType.INTERFACE);
        childInterface.generify("T");
        for (MetadataItem metadataClass : this.metadata.getClassList()) {
            String fqnInterface = metadataClass.getPackageApi() + "." + CodeGen.getPascalizeCase(metadataClass.getName());
            JDefinedClass dc = cm._class(fqnInterface, ClassType.INTERFACE);
            JClass child = cm.ref(Child.class);
            if (child.isParameterized()) {
                List types = child.getTypeParameters();
                for (JClass jclass : types) {
                    jclass.toString();
                }
            }
            dc._extends((JClass)childInterface);
            JTypeVar type = dc.generify("T");
            child.narrow((JClass)type);
            JClass erasureType = dc.erasure();
            List types = dc.getTypeParameters();
            for (JClass jclass : types) {
                child.narrow((JType)erasureType);
            }
            JDocComment javaDocComment = dc.javadoc();
            Map part = javaDocComment.addXdoclet("author");
            part.put("<a href", "'mailto:ralf.battenfeld@bluewin.ch'>Ralf Battenfeld</a>");
            for (MetadataElement element : metadataClass.getElements()) {
                String fqn;
                if (!this.isEnum(element.getType()) || (fqn = this.getFqnClass(element)) == null) continue;
                String localname = this.splitElementType(element.getType())[1];
                String argName = this.getCamelCase(localname);
                JClass refClass = cm.ref(fqn);
                JMethod setMethod = dc.method(1, (JType)dc, argName);
                setMethod.param((JType)refClass, argName);
            }
        }
        File file = new File("./src/test/java");
        file.mkdirs();
        cm.build(file);
    }

    public static String getPascalizeCase(String str) {
        return WordUtils.capitalize((String)str, (char[])new char[]{'_', '-'}).replaceAll("_", "").replaceAll("-", "");
    }

    private String getCamelCase(String value) {
        return WordUtils.uncapitalize((String)CodeGen.getPascalizeCase(value));
    }

    public static String getEnumConstantName(String enumConstant) {
        return "_" + enumConstant;
    }

    public String getFqnClass(MetadataElement element) {
        String namespace = this.splitElementType(element.getType())[0];
        String localname = this.splitElementType(element.getType())[1];
        for (MetadataEnum metadataEnum : this.metadata.getEnumList()) {
            if (!metadataEnum.getName().equals(localname) || !metadataEnum.getNamespace().equals(namespace)) continue;
            return metadataEnum.getPackageApi() + "." + CodeGen.getPascalizeCase(metadataEnum.getName());
        }
        for (MetadataItem metadataClass : this.metadata.getClassList()) {
            if (!metadataClass.getName().equals(localname) || !metadataClass.getNamespace().equals(namespace)) continue;
            return metadataClass.getPackageApi() + "." + CodeGen.getPascalizeCase(metadataClass.getName());
        }
        return null;
    }

    public String[] splitElementType(String elementType) {
        String[] items;
        if (elementType.contains(":") && (items = elementType.split(":", -1)).length == 2) {
            return items;
        }
        String[] dummyArray = new String[]{elementType, elementType};
        return dummyArray;
    }

    public boolean isEnum(String elementType) {
        String namespace = this.splitElementType(elementType)[0];
        String localname = this.splitElementType(elementType)[1];
        boolean isEnum = false;
        for (MetadataEnum metadataEnum : this.metadata.getEnumList()) {
            if (!metadataEnum.getName().equals(localname) || !metadataEnum.getNamespace().equals(namespace)) continue;
            isEnum = true;
            break;
        }
        return isEnum;
    }

    private void generateEnumMethods(JDefinedClass dc, MetadataElement element, boolean isInterface) {
    }
}

