/*
 * Decompiled with CFR 0.152.
 */
package org.ironjacamar.deployers.common;

import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.resource.spi.BootstrapContext;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.ResourceAdapterAssociation;
import javax.resource.spi.TransactionSupport;
import javax.validation.ConstraintViolationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.groups.Default;
import org.ironjacamar.common.api.metadata.Defaults;
import org.ironjacamar.common.api.metadata.common.Extension;
import org.ironjacamar.common.api.metadata.common.Security;
import org.ironjacamar.common.api.metadata.common.Timeout;
import org.ironjacamar.common.api.metadata.common.TransactionSupportEnum;
import org.ironjacamar.common.api.metadata.common.Validation;
import org.ironjacamar.common.api.metadata.common.XaPool;
import org.ironjacamar.common.api.metadata.resourceadapter.Activation;
import org.ironjacamar.common.api.metadata.spec.Activationspec;
import org.ironjacamar.common.api.metadata.spec.ConfigProperty;
import org.ironjacamar.common.api.metadata.spec.ConnectionDefinition;
import org.ironjacamar.common.api.metadata.spec.Connector;
import org.ironjacamar.common.api.metadata.spec.InboundResourceAdapter;
import org.ironjacamar.common.api.metadata.spec.MessageListener;
import org.ironjacamar.common.api.metadata.spec.RequiredConfigProperty;
import org.ironjacamar.common.api.metadata.spec.XsdString;
import org.ironjacamar.common.metadata.spec.ConfigPropertyImpl;
import org.ironjacamar.core.api.connectionmanager.ConnectionManager;
import org.ironjacamar.core.api.connectionmanager.ConnectionManagerConfiguration;
import org.ironjacamar.core.api.connectionmanager.ccm.CachedConnectionManager;
import org.ironjacamar.core.api.connectionmanager.pool.Pool;
import org.ironjacamar.core.api.connectionmanager.pool.PoolConfiguration;
import org.ironjacamar.core.api.deploymentrepository.AdminObject;
import org.ironjacamar.core.api.deploymentrepository.ConnectionFactory;
import org.ironjacamar.core.api.deploymentrepository.Deployment;
import org.ironjacamar.core.api.deploymentrepository.DeploymentRepository;
import org.ironjacamar.core.api.deploymentrepository.Recovery;
import org.ironjacamar.core.api.deploymentrepository.ResourceAdapter;
import org.ironjacamar.core.api.metadatarepository.Metadata;
import org.ironjacamar.core.api.metadatarepository.MetadataRepository;
import org.ironjacamar.core.bootstrapcontext.BootstrapContextCoordinator;
import org.ironjacamar.core.bootstrapcontext.CloneableBootstrapContext;
import org.ironjacamar.core.connectionmanager.ConnectionManagerFactory;
import org.ironjacamar.core.connectionmanager.pool.Capacity;
import org.ironjacamar.core.connectionmanager.pool.Janitor;
import org.ironjacamar.core.connectionmanager.pool.JanitorFactory;
import org.ironjacamar.core.connectionmanager.pool.PoolFactory;
import org.ironjacamar.core.connectionmanager.pool.capacity.CapacityFactory;
import org.ironjacamar.core.deploymentrepository.ActivationSpecImpl;
import org.ironjacamar.core.deploymentrepository.AdminObjectImpl;
import org.ironjacamar.core.deploymentrepository.ConnectionFactoryImpl;
import org.ironjacamar.core.deploymentrepository.DeploymentBuilder;
import org.ironjacamar.core.deploymentrepository.PoolImpl;
import org.ironjacamar.core.deploymentrepository.RecoveryImpl;
import org.ironjacamar.core.deploymentrepository.ResourceAdapterImpl;
import org.ironjacamar.core.metadatarepository.MetadataImpl;
import org.ironjacamar.core.recovery.DefaultRecoveryPlugin;
import org.ironjacamar.core.spi.bv.BeanValidation;
import org.ironjacamar.core.spi.classloading.ClassLoaderPlugin;
import org.ironjacamar.core.spi.naming.JndiStrategy;
import org.ironjacamar.core.spi.recovery.RecoveryPlugin;
import org.ironjacamar.core.spi.security.SubjectFactory;
import org.ironjacamar.core.spi.statistics.Statistics;
import org.ironjacamar.core.spi.statistics.StatisticsPlugin;
import org.ironjacamar.core.spi.transaction.TransactionIntegration;
import org.ironjacamar.core.spi.transaction.recovery.XAResourceRecovery;
import org.ironjacamar.core.util.Injection;
import org.ironjacamar.deployers.DeployersBundle;
import org.ironjacamar.deployers.DeployersLogger;
import org.ironjacamar.deployers.common.DeployException;
import org.ironjacamar.deployers.common.SecurityActions;
import org.ironjacamar.validator.Failure;
import org.ironjacamar.validator.FailureHelper;
import org.ironjacamar.validator.Key;
import org.ironjacamar.validator.Validate;
import org.ironjacamar.validator.ValidateClass;
import org.ironjacamar.validator.ValidatorException;
import org.jboss.logging.Messages;

public abstract class AbstractResourceAdapterDeployer {
    private static DeployersBundle bundle = (DeployersBundle)Messages.getBundle(DeployersBundle.class);
    protected final DeployersLogger log;
    protected DeploymentRepository deploymentRepository = null;
    protected MetadataRepository metadataRepository = null;
    protected BootstrapContextCoordinator bootstrapContextCoordinator = null;
    protected JndiStrategy jndiStrategy = null;
    protected TransactionIntegration transactionIntegration = null;
    protected CachedConnectionManager cachedConnectionManager = null;
    protected SubjectFactory subjectFactory = null;
    protected ClassLoaderPlugin classLoaderPlugin = null;
    protected BeanValidation beanValidation = null;
    protected String defaultPoolType = null;
    protected boolean archiveValidation = false;
    protected boolean archiveValidationFailOnWarn = false;
    protected boolean archiveValidationFailOnError = false;
    private List<Validate> validationObj = new ArrayList<Validate>();

    public AbstractResourceAdapterDeployer() {
        this.log = this.getLogger();
    }

    public void setDeploymentRepository(DeploymentRepository v) {
        this.deploymentRepository = v;
    }

    public void setMetadataRepository(MetadataRepository v) {
        this.metadataRepository = v;
    }

    public void setBootstrapContextCoordinator(BootstrapContextCoordinator v) {
        this.bootstrapContextCoordinator = v;
    }

    public void setJndiStrategy(JndiStrategy v) {
        this.jndiStrategy = v;
    }

    public void setTransactionIntegration(TransactionIntegration v) {
        this.transactionIntegration = v;
    }

    public void setSubjectFactory(SubjectFactory subjectFactory) {
        this.subjectFactory = subjectFactory;
    }

    public void setClassLoaderPlugin(ClassLoaderPlugin classLoaderPlugin) {
        this.classLoaderPlugin = classLoaderPlugin;
    }

    public void setCachedConnectionManager(CachedConnectionManager v) {
        this.cachedConnectionManager = v;
    }

    public void setBeanValidation(BeanValidation v) {
        this.beanValidation = v;
    }

    public void setDefaultPoolType(String v) {
        this.defaultPoolType = v;
    }

    public void setArchiveValidation(boolean archiveValidation) {
        this.archiveValidation = archiveValidation;
    }

    public void setArchiveValidationFailOnWarn(boolean archiveValidationFailOnWarn) {
        this.archiveValidationFailOnWarn = archiveValidationFailOnWarn;
    }

    public void setArchiveValidationFailOnError(boolean archiveValidationFailOnError) {
        this.archiveValidationFailOnError = archiveValidationFailOnError;
    }

    public Metadata registerMetadata(String name, Connector c, File archive) {
        MetadataImpl md = new MetadataImpl(name, c, archive);
        this.metadataRepository.registerMetadata((Metadata)md);
        return md;
    }

    public Deployment activate(Connector connector, Activation activation, String archiveName, File root, ClassLoader cl) throws DeployException {
        this.log.tracef("Connector=%s", connector);
        this.log.tracef("Activation=%s", this.stripPassword(activation.toString()));
        this.log.tracef("ArchiveName=%s", archiveName);
        this.log.tracef("Root=%s", root.getAbsolutePath());
        try {
            DeploymentBuilder builder = new DeploymentBuilder();
            TransactionSupportEnum transactionSupport = this.getTransactionSupport(connector, activation);
            Metadata md = this.metadataRepository.findByName(archiveName);
            builder.identifier(activation.getId());
            builder.name(md.getName());
            builder.metadata(connector);
            builder.activation(activation);
            builder.archive(md.getArchive());
            builder.classLoader(cl);
            builder.classLoaderPlugin(this.classLoaderPlugin);
            this.loadNativeLibraries(root);
            if (connector.getResourceadapter().getResourceadapterClass() != null) {
                CloneableBootstrapContext bootstrapContext = this.createBootstrapContext(connector, activation);
                this.createResourceAdapter(builder, connector.getResourceadapter().getResourceadapterClass(), connector.getResourceadapter().getConfigProperties(), activation.getConfigProperties(), transactionSupport, this.getProductName(connector), this.getProductVersion(connector), connector.getResourceadapter().getInboundResourceadapter(), bootstrapContext);
            }
            if (activation.getConnectionDefinitions() != null) {
                for (org.ironjacamar.common.api.metadata.resourceadapter.ConnectionDefinition cd : activation.getConnectionDefinitions()) {
                    this.createConnectionDefinition(builder, connector, cd, transactionSupport);
                }
            }
            if (activation.getAdminObjects() != null) {
                for (org.ironjacamar.common.api.metadata.resourceadapter.AdminObject ao : activation.getAdminObjects()) {
                    this.createAdminObject(builder, connector, ao);
                }
            }
            Deployment deployment = builder.build();
            Set<Failure> failures = new HashSet<Failure>();
            failures = this.validateArchive(this.validationObj, failures);
            if (this.archiveValidationFailOnWarn && (this.hasFailuresLevel(failures, 0) || this.hasFailuresLevel(failures, 1)) || this.archiveValidationFailOnError && this.hasFailuresLevel(failures, 1)) {
                org.ironjacamar.validator.Validator v = new org.ironjacamar.validator.Validator();
                throw new ValidatorException(this.printFailuresLog(v, failures, new FailureHelper[0]), failures, v.getResourceBundle());
            }
            if (failures != null && failures.size() > 0) {
                this.log.validationInvalidArchive(root.getName());
            }
            this.printFailuresLog(new org.ironjacamar.validator.Validator(), failures, new FailureHelper[0]);
            if (this.is16(deployment.getMetadata())) {
                this.verifyBeanValidation(deployment);
            }
            deployment.activate();
            if (!this.deploymentRepository.registerDeployment(deployment)) {
                throw new DeployException(bundle.unableToRegister(deployment.getIdentifier(), deployment.getName()));
            }
            this.log.deployed(archiveName);
            return deployment;
        }
        catch (DeployException de) {
            throw de;
        }
        catch (Exception e) {
            throw new DeployException(bundle.deploymentFailed(archiveName), e);
        }
    }

    private CloneableBootstrapContext createBootstrapContext(Connector connector, Activation activation) {
        CloneableBootstrapContext bootstrapContext;
        if (activation != null && activation.getBootstrapContext() != null && !activation.getBootstrapContext().trim().equals("")) {
            String bootstrapContextName = activation.getBootstrapContext();
            String bootstrapContextIdentifier = this.bootstrapContextCoordinator.createIdentifier(connector.getResourceadapter().getResourceadapterClass(), (Collection)connector.getResourceadapter().getConfigProperties(), bootstrapContextName);
            bootstrapContext = this.bootstrapContextCoordinator.createBootstrapContext(bootstrapContextIdentifier, bootstrapContextName);
        } else {
            bootstrapContext = this.bootstrapContextCoordinator.getDefaultBootstrapContext();
        }
        return bootstrapContext;
    }

    protected void createResourceAdapter(DeploymentBuilder builder, String raClz, Collection<ConfigProperty> configProperties, Map<String, String> overrides, TransactionSupportEnum transactionSupport, String productName, String productVersion, InboundResourceAdapter ira, CloneableBootstrapContext bootstrapContext) throws DeployException {
        try {
            Class<?> clz = Class.forName(raClz, true, builder.getClassLoader());
            javax.resource.spi.ResourceAdapter resourceAdapter = (javax.resource.spi.ResourceAdapter)clz.newInstance();
            this.validationObj.add((Validate)new ValidateClass(Key.RESOURCE_ADAPTER, clz, configProperties));
            Collection<org.ironjacamar.core.api.deploymentrepository.ConfigProperty> dcps = this.injectConfigProperties(resourceAdapter, configProperties, overrides, builder.getClassLoader());
            StatisticsPlugin statisticsPlugin = null;
            if (resourceAdapter instanceof Statistics) {
                statisticsPlugin = ((Statistics)resourceAdapter).getStatistics();
            }
            TransactionIntegration ti = null;
            if (this.isXA(transactionSupport)) {
                ti = this.transactionIntegration;
            }
            bootstrapContext.setResourceAdapter(resourceAdapter);
            builder.resourceAdapter((ResourceAdapter)new ResourceAdapterImpl(resourceAdapter, (BootstrapContext)bootstrapContext, dcps, statisticsPlugin, productName, productVersion, this.createInboundMapping(ira, builder.getClassLoader()), this.is16(builder.getMetadata()), this.beanValidation, builder.getActivation().getBeanValidationGroups(), ti));
        }
        catch (Throwable t) {
            throw new DeployException(bundle.unableToCreateResourceAdapter(raClz), t);
        }
    }

    protected void createConnectionDefinition(DeploymentBuilder builder, Connector connector, org.ironjacamar.common.api.metadata.resourceadapter.ConnectionDefinition cd, TransactionSupportEnum transactionSupport) throws DeployException {
        try {
            String janitorType;
            TransactionSupport.TransactionSupportLevel tsl;
            TransactionSupportEnum tse = transactionSupport;
            String mcfClass = this.findManagedConnectionFactory(cd.getClassName(), connector);
            Class<?> clz = Class.forName(mcfClass, true, builder.getClassLoader());
            ManagedConnectionFactory mcf = (ManagedConnectionFactory)clz.newInstance();
            Collection<ConfigProperty> configProperties = this.findConfigProperties(mcfClass, connector);
            this.validationObj.add((Validate)new ValidateClass(Key.MANAGED_CONNECTION_FACTORY, clz, configProperties));
            Collection<org.ironjacamar.core.api.deploymentrepository.ConfigProperty> dcps = this.injectConfigProperties(mcf, configProperties, cd.getConfigProperties(), builder.getClassLoader());
            if (mcf instanceof TransactionSupport && (tse = (tsl = ((TransactionSupport)mcf).getTransactionSupport()) == TransactionSupport.TransactionSupportLevel.NoTransaction ? TransactionSupportEnum.NoTransaction : (tsl == TransactionSupport.TransactionSupportLevel.LocalTransaction ? TransactionSupportEnum.LocalTransaction : TransactionSupportEnum.XATransaction)) != transactionSupport) {
                this.log.changedTransactionSupport(cd.getJndiName());
            }
            ConnectionManagerConfiguration cmc = new ConnectionManagerConfiguration();
            this.applyConnectionManagerConfiguration(cmc, cd);
            this.applyConnectionManagerConfiguration(cmc, cd.getSecurity());
            this.applyConnectionManagerConfiguration(cmc, cd.getTimeout());
            if (this.isXA(tse)) {
                this.applyConnectionManagerConfiguration(cmc, (XaPool)cd.getPool());
            }
            org.ironjacamar.core.connectionmanager.ConnectionManager cm = ConnectionManagerFactory.createConnectionManager((TransactionSupportEnum)tse, (ManagedConnectionFactory)mcf, (CachedConnectionManager)(cd.isUseCcm() != false ? this.cachedConnectionManager : null), (ConnectionManagerConfiguration)cmc, (TransactionIntegration)this.transactionIntegration);
            if (this.subjectFactory != null) {
                cm.setSubjectFactory(this.subjectFactory);
            }
            String poolType = cd.getPool() != null ? cd.getPool().getType() : null;
            String string = janitorType = cd.getPool() != null ? cd.getPool().getJanitor() : null;
            if (poolType == null || poolType.equals("")) {
                poolType = this.defaultPoolType;
            }
            PoolConfiguration pc = new PoolConfiguration();
            pc.setId(cd.getId() != null ? cd.getId() : cd.getJndiName());
            this.applyPoolConfiguration(pc, cd.getPool());
            this.applyPoolConfiguration(pc, cd.getTimeout());
            this.applyPoolConfiguration(pc, cd.getValidation());
            org.ironjacamar.core.connectionmanager.pool.Pool pool = PoolFactory.createPool((String)poolType, (org.ironjacamar.core.connectionmanager.ConnectionManager)cm, (PoolConfiguration)pc);
            cm.setPool(pool);
            Capacity capacity = CapacityFactory.create((org.ironjacamar.common.api.metadata.common.Capacity)(cd.getPool() != null ? cd.getPool().getCapacity() : null), (ClassLoaderPlugin)this.classLoaderPlugin);
            pool.setCapacity(capacity);
            PoolImpl dpool = new PoolImpl((Pool)pool, null, capacity.getIncrementer(), capacity.getDecrementer());
            Janitor janitor = JanitorFactory.createJanitor((String)janitorType);
            janitor.setPool(pool);
            pool.setJanitor(janitor);
            StatisticsPlugin statisticsPlugin = null;
            if (mcf instanceof Statistics) {
                statisticsPlugin = ((Statistics)mcf).getStatistics();
            }
            Recovery recovery = null;
            if (this.isXA(tse)) {
                recovery = this.createRecovery(mcf, cd);
            }
            if (builder.getResourceAdapter() != null) {
                this.associateResourceAdapter(builder.getResourceAdapter().getResourceAdapter(), mcf);
            }
            Object cf = mcf.createConnectionFactory((javax.resource.spi.ConnectionManager)cm);
            this.validationObj.add((Validate)new ValidateClass(Key.CONNECTION_FACTORY, cf.getClass()));
            builder.connectionFactory((ConnectionFactory)new ConnectionFactoryImpl(cd.getJndiName(), cf, dcps, cd, (ConnectionManager)cm, (org.ironjacamar.core.api.deploymentrepository.Pool)dpool, statisticsPlugin, recovery, this.jndiStrategy));
        }
        catch (Throwable t) {
            throw new DeployException(bundle.unableToCreateConnectionDefinition(cd.getId(), cd.getJndiName()), t);
        }
    }

    protected void createAdminObject(DeploymentBuilder builder, Connector connector, org.ironjacamar.common.api.metadata.resourceadapter.AdminObject ao) throws DeployException {
        try {
            String aoClass = this.findAdminObject(ao.getClassName(), connector);
            Class<?> clz = Class.forName(aoClass, true, builder.getClassLoader());
            Object adminObject = clz.newInstance();
            Collection<ConfigProperty> configProperties = this.findConfigProperties(aoClass, connector);
            Collection<org.ironjacamar.core.api.deploymentrepository.ConfigProperty> dcps = this.injectConfigProperties(adminObject, configProperties, ao.getConfigProperties(), builder.getClassLoader());
            this.validationObj.add((Validate)new ValidateClass(Key.ADMIN_OBJECT, clz, configProperties));
            StatisticsPlugin statisticsPlugin = null;
            if (adminObject instanceof Statistics) {
                statisticsPlugin = ((Statistics)adminObject).getStatistics();
            }
            if (builder.getResourceAdapter() != null) {
                this.associateResourceAdapter(builder.getResourceAdapter().getResourceAdapter(), adminObject);
            }
            builder.adminObject((AdminObject)new AdminObjectImpl(ao.getJndiName(), adminObject, dcps, ao, statisticsPlugin, this.jndiStrategy));
        }
        catch (Throwable t) {
            throw new DeployException(bundle.unableToCreateAdminObject(ao.getId(), ao.getJndiName()), t);
        }
    }

    private String findManagedConnectionFactory(String className, Connector connector) {
        for (ConnectionDefinition cd : connector.getResourceadapter().getOutboundResourceadapter().getConnectionDefinitions()) {
            if (!className.equals(cd.getManagedConnectionFactoryClass().getValue()) && !className.equals(cd.getConnectionFactoryInterface().getValue())) continue;
            return cd.getManagedConnectionFactoryClass().getValue();
        }
        return className;
    }

    private String findAdminObject(String className, Connector connector) {
        for (org.ironjacamar.common.api.metadata.spec.AdminObject ao : connector.getResourceadapter().getAdminObjects()) {
            if (!className.equals(ao.getAdminobjectClass().getValue()) && !className.equals(ao.getAdminobjectInterface().getValue())) continue;
            return ao.getAdminobjectClass().getValue();
        }
        return className;
    }

    private Collection<ConfigProperty> findConfigProperties(String className, Connector connector) {
        for (ConnectionDefinition cd : connector.getResourceadapter().getOutboundResourceadapter().getConnectionDefinitions()) {
            if (!className.equals(cd.getManagedConnectionFactoryClass().getValue()) && !className.equals(cd.getConnectionFactoryInterface().getValue())) continue;
            return cd.getConfigProperties();
        }
        return null;
    }

    private Collection<org.ironjacamar.core.api.deploymentrepository.ConfigProperty> injectConfigProperties(Object o, Collection<ConfigProperty> configProperties, Map<String, String> overrides, ClassLoader classLoader) throws Throwable {
        ArrayList<org.ironjacamar.core.deploymentrepository.ConfigPropertyImpl> dcps = null;
        if (configProperties != null && !configProperties.isEmpty()) {
            Injection injector = new Injection();
            dcps = new ArrayList<org.ironjacamar.core.deploymentrepository.ConfigPropertyImpl>(configProperties.size());
            for (ConfigProperty cp : configProperties) {
                String value;
                String name = cp.getConfigPropertyName().getValue();
                Class<?> type = Class.forName(cp.getConfigPropertyType().getValue(), true, classLoader);
                boolean readOnly = cp.getConfigPropertySupportsDynamicUpdates() != null ? cp.getConfigPropertySupportsDynamicUpdates() : true;
                boolean confidential = cp.getConfigPropertyConfidential() != null ? cp.getConfigPropertyConfidential() : false;
                boolean declared = true;
                String string = value = cp.isValueSet() ? cp.getConfigPropertyValue().getValue() : null;
                if (overrides != null) {
                    if (overrides.containsKey(cp.getConfigPropertyName().getValue())) {
                        value = overrides.get(cp.getConfigPropertyName().getValue());
                    } else {
                        String alternative = cp.getConfigPropertyName().getValue().substring(0, 1).toUpperCase();
                        if (cp.getConfigPropertyName().getValue().length() > 1) {
                            alternative = alternative + cp.getConfigPropertyName().getValue().substring(1);
                        }
                        if (overrides.containsKey(alternative)) {
                            value = overrides.get(alternative);
                        } else {
                            this.log.tracef("%s: Override for %s not found", o.getClass().getName(), cp.getConfigPropertyName().getValue());
                        }
                    }
                }
                if (value != null) {
                    try {
                        injector.inject(o, cp.getConfigPropertyName().getValue(), (Object)value, cp.getConfigPropertyType().getValue());
                    }
                    catch (Throwable t) {
                        type = this.convertType(type);
                        if (type != null) {
                            injector.inject(o, cp.getConfigPropertyName().getValue(), (Object)value, type.getName());
                        }
                        throw new DeployException(bundle.unableToInject(o.getClass().getName(), cp.getConfigPropertyName().getValue(), value.toString()), t);
                    }
                }
                dcps.add(new org.ironjacamar.core.deploymentrepository.ConfigPropertyImpl(o, name, type, (Object)value, readOnly, confidential, declared));
            }
        }
        return dcps;
    }

    private Class<?> convertType(Class<?> old) {
        if (Boolean.class.equals(old)) {
            return Boolean.TYPE;
        }
        if (Boolean.TYPE.equals(old)) {
            return Boolean.class;
        }
        if (Byte.class.equals(old)) {
            return Byte.TYPE;
        }
        if (Byte.TYPE.equals(old)) {
            return Byte.class;
        }
        if (Short.class.equals(old)) {
            return Short.TYPE;
        }
        if (Short.TYPE.equals(old)) {
            return Short.class;
        }
        if (Integer.class.equals(old)) {
            return Integer.TYPE;
        }
        if (Integer.TYPE.equals(old)) {
            return Integer.class;
        }
        if (Long.class.equals(old)) {
            return Long.TYPE;
        }
        if (Long.TYPE.equals(old)) {
            return Long.class;
        }
        if (Float.class.equals(old)) {
            return Float.TYPE;
        }
        if (Float.TYPE.equals(old)) {
            return Float.class;
        }
        if (Double.class.equals(old)) {
            return Double.TYPE;
        }
        if (Double.TYPE.equals(old)) {
            return Double.class;
        }
        if (Character.class.equals(old)) {
            return Character.TYPE;
        }
        if (Character.TYPE.equals(old)) {
            return Character.class;
        }
        return null;
    }

    private boolean isSupported(Class<?> t) {
        return Boolean.class.equals(t) || Boolean.TYPE.equals(t) || Byte.class.equals(t) || Byte.TYPE.equals(t) || Short.class.equals(t) || Short.TYPE.equals(t) || Integer.class.equals(t) || Integer.TYPE.equals(t) || Long.class.equals(t) || Long.TYPE.equals(t) || Float.class.equals(t) || Float.TYPE.equals(t) || Double.class.equals(t) || Double.TYPE.equals(t) || Character.class.equals(t) || Character.TYPE.equals(t) || String.class.equals(t);
    }

    protected void associateResourceAdapter(javax.resource.spi.ResourceAdapter resourceAdapter, Object object) throws DeployException {
        if (resourceAdapter != null && object != null && object instanceof ResourceAdapterAssociation) {
            try {
                ResourceAdapterAssociation raa = (ResourceAdapterAssociation)object;
                raa.setResourceAdapter(resourceAdapter);
            }
            catch (Throwable t) {
                throw new DeployException(bundle.unableToAssociate(object.getClass().getName()), t);
            }
        }
    }

    private TransactionSupportEnum getTransactionSupport(Connector connector, Activation activation) {
        if (activation.getTransactionSupport() != null) {
            return activation.getTransactionSupport();
        }
        if (connector.getResourceadapter().getOutboundResourceadapter() != null) {
            return connector.getResourceadapter().getOutboundResourceadapter().getTransactionSupport();
        }
        return TransactionSupportEnum.XATransaction;
    }

    private boolean isXA(TransactionSupportEnum tse) {
        return TransactionSupportEnum.XATransaction == tse;
    }

    private void applyConnectionManagerConfiguration(ConnectionManagerConfiguration cmc, org.ironjacamar.common.api.metadata.resourceadapter.ConnectionDefinition cd) {
        if (cd.getJndiName() != null) {
            cmc.setJndiName(cd.getJndiName());
        }
        if (cd.isSharable() != null) {
            cmc.setSharable(cd.isSharable().booleanValue());
        }
        if (cd.isEnlistment() != null) {
            cmc.setEnlistment(cd.isEnlistment().booleanValue());
        }
        if (cd.isConnectable() != null) {
            cmc.setConnectable(cd.isConnectable().booleanValue());
        }
        if (cd.isTracking() != null) {
            cmc.setTracking(cd.isTracking());
        }
    }

    private void applyConnectionManagerConfiguration(ConnectionManagerConfiguration cmc, Security s) {
        if (s != null && s.getSecurityDomain() != null) {
            cmc.setSecurityDomain(s.getSecurityDomain());
        }
    }

    private void applyConnectionManagerConfiguration(ConnectionManagerConfiguration cmc, XaPool xp) {
        if (xp != null) {
            if (xp.isIsSameRmOverride() != null) {
                cmc.setIsSameRMOverride(xp.isIsSameRmOverride());
            }
            if (xp.isPadXid() != null) {
                cmc.setPadXid(xp.isPadXid().booleanValue());
            }
            if (xp.isWrapXaResource() != null) {
                cmc.setWrapXAResource(xp.isWrapXaResource().booleanValue());
            }
        }
    }

    private void applyConnectionManagerConfiguration(ConnectionManagerConfiguration cmc, Timeout t) {
        if (t != null) {
            if (t.getAllocationRetry() != null) {
                cmc.setAllocationRetry(t.getAllocationRetry().intValue());
            }
            if (t.getAllocationRetryWaitMillis() != null) {
                cmc.setAllocationRetryWaitMillis(t.getAllocationRetryWaitMillis().longValue());
            }
            if (t.getXaResourceTimeout() != null) {
                cmc.setXAResourceTimeout(t.getXaResourceTimeout().intValue());
            }
        }
    }

    private void applyPoolConfiguration(PoolConfiguration pc, org.ironjacamar.common.api.metadata.common.Pool p) {
        if (p != null) {
            if (p.getMinPoolSize() != null) {
                pc.setMinSize(p.getMinPoolSize().intValue());
            }
            if (p.getInitialPoolSize() != null) {
                pc.setInitialSize(p.getInitialPoolSize().intValue());
            }
            if (p.getMaxPoolSize() != null) {
                pc.setMaxSize(p.getMaxPoolSize().intValue());
            }
            if (p.isPrefill() != null) {
                pc.setPrefill(p.isPrefill().booleanValue());
            }
            if (p.getFlushStrategy() != null) {
                pc.setFlushStrategy(p.getFlushStrategy());
            }
        }
    }

    private void applyPoolConfiguration(PoolConfiguration pc, Timeout t) {
        if (t != null) {
            if (t.getBlockingTimeoutMillis() != null) {
                pc.setBlockingTimeout(t.getBlockingTimeoutMillis().longValue());
            }
            if (t.getIdleTimeoutMinutes() != null) {
                pc.setIdleTimeoutMinutes(t.getIdleTimeoutMinutes().intValue());
            }
        }
    }

    private void applyPoolConfiguration(PoolConfiguration pc, Validation v) {
        if (v != null) {
            if (v.isValidateOnMatch() != null) {
                pc.setValidateOnMatch(v.isValidateOnMatch().booleanValue());
            }
            if (v.isBackgroundValidation() != null) {
                pc.setBackgroundValidation(v.isBackgroundValidation().booleanValue());
            }
            if (v.getBackgroundValidationMillis() != null) {
                pc.setBackgroundValidationMillis(v.getBackgroundValidationMillis().longValue());
            }
            if (v.isUseFastFail() != null) {
                pc.setUseFastFail(v.isUseFastFail().booleanValue());
            }
        }
    }

    private Recovery createRecovery(ManagedConnectionFactory mcf, org.ironjacamar.common.api.metadata.resourceadapter.ConnectionDefinition cd) throws Throwable {
        Boolean padXid = Defaults.PAD_XID;
        Boolean isSameRMOverride = Defaults.IS_SAME_RM_OVERRIDE;
        Boolean wrapXAResource = Defaults.WRAP_XA_RESOURCE;
        String securityDomain = null;
        DefaultRecoveryPlugin plugin = null;
        Collection<Object> dcps = null;
        if (this.transactionIntegration.getRecoveryRegistry() == null) {
            return null;
        }
        if (this.subjectFactory == null) {
            return null;
        }
        if (cd.getRecovery() != null && cd.getRecovery().isNoRecovery().booleanValue()) {
            return null;
        }
        if (cd.getRecovery() != null && cd.getRecovery().getCredential() != null) {
            securityDomain = cd.getRecovery().getCredential().getSecurityDomain();
        }
        if (securityDomain == null && cd.getSecurity() != null) {
            securityDomain = cd.getSecurity().getSecurityDomain();
        }
        if (securityDomain == null) {
            return null;
        }
        if (cd.getRecovery() != null && cd.getRecovery().getPlugin() != null) {
            Extension extension = cd.getRecovery().getPlugin();
            ArrayList<ConfigProperty> configProperties = new ArrayList<ConfigProperty>();
            for (Map.Entry property : extension.getConfigPropertiesMap().entrySet()) {
                ConfigPropertyImpl c = new ConfigPropertyImpl(null, new XsdString((String)property.getKey(), null), XsdString.NULL_XSDSTRING, new XsdString((String)property.getValue(), null), Boolean.FALSE, Boolean.FALSE, Boolean.FALSE, null, false, null, null, null, null);
                configProperties.add((ConfigProperty)c);
            }
            Class<?> clz = Class.forName(extension.getClassName(), true, mcf.getClass().getClassLoader());
            plugin = (RecoveryPlugin)clz.newInstance();
            dcps = this.injectConfigProperties(plugin, configProperties, null, plugin.getClass().getClassLoader());
        }
        if (plugin == null) {
            plugin = new DefaultRecoveryPlugin();
        }
        if (dcps == null) {
            dcps = new ArrayList(1);
        }
        if (cd.getPool() != null) {
            XaPool xaPool = (XaPool)cd.getPool();
            if (xaPool.isPadXid() != null) {
                padXid = xaPool.isPadXid();
            }
            if (xaPool.isIsSameRmOverride() != null) {
                isSameRMOverride = xaPool.isIsSameRmOverride();
            }
            if (xaPool.isWrapXaResource() != null) {
                wrapXAResource = xaPool.isWrapXaResource();
            }
        }
        XAResourceRecovery r = this.transactionIntegration.createXAResourceRecovery(mcf, padXid, isSameRMOverride, wrapXAResource, securityDomain, this.subjectFactory, (RecoveryPlugin)plugin, null);
        return new RecoveryImpl(plugin.getClass().getName(), dcps, r, cd.getJndiName(), this.transactionIntegration.getRecoveryRegistry());
    }

    private Map<String, ActivationSpecImpl> createInboundMapping(InboundResourceAdapter ira, ClassLoader cl) throws Exception {
        if (ira != null) {
            HashMap<String, ActivationSpecImpl> result = new HashMap<String, ActivationSpecImpl>();
            for (MessageListener ml : ira.getMessageadapter().getMessagelisteners()) {
                String type = ml.getMessagelistenerType().getValue();
                Activationspec as = ml.getActivationspec();
                String clzName = as.getActivationspecClass().getValue();
                Class<?> clz = Class.forName(clzName, true, cl);
                Map<String, Class<?>> configProperties = this.createPropertyMap(clz);
                HashSet<String> requiredConfigProperties = new HashSet<String>();
                if (as.getRequiredConfigProperties() != null) {
                    for (RequiredConfigProperty rcp : as.getRequiredConfigProperties()) {
                        requiredConfigProperties.add(rcp.getConfigPropertyName().getValue());
                    }
                }
                this.validationObj.add((Validate)new ValidateClass(Key.ACTIVATION_SPEC, clz, (Collection)as.getConfigProperties()));
                ActivationSpecImpl asi = new ActivationSpecImpl(clzName, configProperties, requiredConfigProperties);
                if (result.containsKey(type)) continue;
                result.put(type, asi);
            }
            return result;
        }
        return null;
    }

    private Map<String, Class<?>> createPropertyMap(Class<?> clz) throws Exception {
        HashMap result = new HashMap();
        for (Method m : clz.getMethods()) {
            if (!m.getName().startsWith("set") || !m.getReturnType().equals(Void.TYPE) || m.getParameterCount() != 1 || !this.isSupported(m.getParameterTypes()[0])) continue;
            result.put(m.getName().substring(3), m.getParameterTypes()[0]);
        }
        return result;
    }

    private String getProductName(Connector raXml) {
        if (raXml != null && !XsdString.isNull((XsdString)raXml.getEisType())) {
            return raXml.getEisType().getValue();
        }
        return "";
    }

    private String getProductVersion(Connector raXml) {
        if (raXml != null && !XsdString.isNull((XsdString)raXml.getResourceadapterVersion())) {
            return raXml.getResourceadapterVersion().getValue();
        }
        return "";
    }

    private String stripPassword(String str) {
        if (str.indexOf("<password>") == -1) {
            return str;
        }
        Pattern pattern = Pattern.compile("<password>[^<]*</password>");
        String[] strs = pattern.split(str);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < strs.length; ++i) {
            String s = strs[i];
            sb.append(s);
            if (i >= strs.length - 1) continue;
            sb.append("<password>****</password>");
        }
        return sb.toString();
    }

    private boolean is16(Connector connector) {
        return connector == null || connector.getVersion() == Connector.Version.V_16 || connector.getVersion() == Connector.Version.V_17;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyBeanValidation(Deployment deployment) throws DeployException {
        if (this.beanValidation != null) {
            try (ValidatorFactory vf = null;){
                Set f;
                Set f2;
                vf = this.beanValidation.getValidatorFactory();
                Validator v = vf.getValidator();
                List<String> l = deployment.getActivation().getBeanValidationGroups();
                if (l == null || l.isEmpty()) {
                    l = Arrays.asList(Default.class.getName());
                }
                ArrayList groups = new ArrayList();
                for (String clz : l) {
                    try {
                        groups.add(Class.forName(clz, true, deployment.getClassLoader()));
                    }
                    catch (ClassNotFoundException e) {
                        throw new DeployException(bundle.unableToLoadBeanValidationGroup(clz, deployment.getIdentifier()), e);
                    }
                }
                HashSet failures = new HashSet();
                if (deployment.getResourceAdapter() != null && !(f2 = v.validate((Object)deployment.getResourceAdapter().getResourceAdapter(), groups.toArray(new Class[groups.size()]))).isEmpty()) {
                    failures.addAll(f2);
                }
                if (deployment.getConnectionFactories() != null) {
                    for (ConnectionFactory cf : deployment.getConnectionFactories()) {
                        f = v.validate(cf.getConnectionFactory(), groups.toArray(new Class[groups.size()]));
                        if (f.isEmpty()) continue;
                        failures.addAll(f);
                    }
                }
                if (deployment.getAdminObjects() != null) {
                    for (AdminObject ao : deployment.getAdminObjects()) {
                        f = v.validate(ao.getAdminObject(), groups.toArray(new Class[groups.size()]));
                        if (f.isEmpty()) continue;
                        failures.addAll(f);
                    }
                }
                if (!failures.isEmpty()) {
                    throw new DeployException(bundle.violationOfValidationRule(deployment.getIdentifier()), (Throwable)new ConstraintViolationException(failures));
                }
            }
        }
    }

    private void loadNativeLibraries(File root) {
        if (root != null && root.exists()) {
            ArrayList<String> libs = new ArrayList<String>();
            if (root.isDirectory()) {
                if (root.listFiles() != null) {
                    for (File f : root.listFiles()) {
                        String fileName;
                        if (!f.isFile() || !(fileName = f.getName().toLowerCase(Locale.US)).endsWith(".a") && !fileName.endsWith(".so") && !fileName.endsWith(".dll")) continue;
                        libs.add(f.getAbsolutePath());
                    }
                } else {
                    this.log.debugf("Root is a directory, but there were an I/O error: %s", root.getAbsolutePath());
                }
            }
            if (libs.size() > 0) {
                for (String lib : libs) {
                    try {
                        SecurityActions.load(lib);
                        this.log.debugf("Loaded library: %s", lib);
                    }
                    catch (Throwable t) {
                        this.log.debugf("Unable to load library: %s", lib);
                    }
                }
            } else {
                this.log.debugf("No native libraries for %s", root.getAbsolutePath());
            }
        }
    }

    public Set<Failure> validateArchive(List<Validate> archiveValidationObjs, Set<Failure> failures) {
        if (!this.archiveValidation) {
            return null;
        }
        for (Validate validate : archiveValidationObjs) {
            if (validate instanceof Validate) continue;
            return null;
        }
        org.ironjacamar.validator.Validator validator = new org.ironjacamar.validator.Validator();
        List partialFailures = validator.validate(archiveValidationObjs);
        if (partialFailures != null) {
            if (failures == null) {
                failures = new HashSet<Failure>();
            }
            failures.addAll(partialFailures);
        }
        return failures;
    }

    protected boolean hasFailuresLevel(Collection<Failure> failures, int severity) {
        if (failures != null) {
            for (Failure failure : failures) {
                if (failure.getSeverity() != severity) continue;
                return true;
            }
        }
        return false;
    }

    public String printFailuresLog(org.ironjacamar.validator.Validator validator, Collection<Failure> failures, FailureHelper ... fhInput) {
        String errorText = "";
        FailureHelper fh = null;
        fh = fhInput.length == 0 ? new FailureHelper(failures) : fhInput[0];
        if (failures != null && failures.size() > 0) {
            errorText = fh.asText(validator.getResourceBundle());
        }
        return errorText;
    }

    protected abstract DeployersLogger getLogger();

    protected File getReportDirectory() {
        return new File(SecurityActions.getSystemProperty("ironjacamar.home"), "/log/");
    }
}

