/*
 * Decompiled with CFR 0.152.
 */
package net.socialchange.doctype;

import java.io.IOException;
import java.io.InputStream;
import net.socialchange.doctype.Doctype;
import net.socialchange.doctype.DoctypeImpl;

public class DoctypeParser {
    protected final int debug;
    private Doctype doctype;
    private String errMsg;

    public DoctypeParser() {
        this.debug = 0;
    }

    public DoctypeParser(int debugLevel) {
        this.debug = debugLevel;
    }

    public void parse(InputStream in) throws IOException {
        this.parse(in, null);
    }

    public void parse(InputStream in, StringBuffer buf) throws IOException {
        int STATE_Doctype = 100;
        int STATE_NAME = 110;
        int STATE_EXTID = 101;
        int STATE_SYS_LIT = 115;
        int STATE_PUB_LIT = 112;
        int STATE_INT_SUBSET = 105;
        int STATE_EXIT = 120;
        int STATE_FAIL = 102;
        boolean whitespace = false;
        boolean inQuote = false;
        boolean isSingleQuote = false;
        boolean inSubset = false;
        int state = 100;
        StringBuffer nameBuf = new StringBuffer();
        StringBuffer extidBuf = new StringBuffer(6);
        StringBuffer syslitBuf = new StringBuffer();
        StringBuffer publitBuf = new StringBuffer();
        StringBuffer subsetBuf = new StringBuffer();
        while (state != 120 && state != 102) {
            char e = (char)in.read();
            if ((short)e == -1) {
                this.errMsg = "Doctype decl parser reached end of stream";
                state = 102;
            }
            if (buf != null) {
                buf.append(e);
            }
            if (whitespace) {
                if (this.isWhitespace(e)) continue;
                whitespace = false;
            }
            switch (state) {
                case 100: {
                    if (!this.isWhitespace(e)) break;
                    if (this.debug > 1) {
                        this.log("Switched from STATE_Doctype to STATE_NAME");
                    }
                    whitespace = true;
                    state = 110;
                    break;
                }
                case 110: {
                    if (this.isWhitespace(e)) {
                        if (this.debug > 1) {
                            this.log("Switched from STATE_NAME to STATE_EXTID");
                        }
                        whitespace = true;
                        state = 101;
                        break;
                    }
                    nameBuf.append(e);
                    break;
                }
                case 101: {
                    if (this.isWhitespace(e)) {
                        whitespace = true;
                        String extid = extidBuf.toString();
                        if (this.debug > 1) {
                            this.log("We have accumulated extid " + extid);
                        }
                        if (extid.equals("PUBLIC")) {
                            if (this.debug > 1) {
                                this.log("Switched from STATE_EXTID to STATE_PUB_LIT");
                            }
                            state = 112;
                            break;
                        }
                        if (extid.equals("SYSTEM")) {
                            if (this.debug > 1) {
                                this.log("Switched from STATE_EXTID to STATE_SYS_LIT");
                            }
                            state = 115;
                            break;
                        }
                        this.errMsg = "Doctype decl parser read unknown external ID string " + extid + ". Should be SYSTEM or PUBLIC";
                        state = 102;
                        break;
                    }
                    extidBuf.append(e);
                    break;
                }
                case 112: {
                    if (e == '\"' && !inQuote) {
                        if (this.debug > 1) {
                            this.log("Entering \"");
                        }
                        inQuote = true;
                        isSingleQuote = false;
                        break;
                    }
                    if (e == '\'' && !inQuote) {
                        if (this.debug > 1) {
                            this.log("Entering '");
                        }
                        inQuote = true;
                        isSingleQuote = true;
                        break;
                    }
                    if (e == '\"' && inQuote && !isSingleQuote || e == '\'' && inQuote && isSingleQuote) {
                        if (this.debug > 1) {
                            this.log("Leaving " + e);
                        }
                        inQuote = false;
                        whitespace = true;
                        if (this.debug > 1) {
                            this.log("Switched from STATE_PUB_LIT to STATE_SYS_LIT");
                        }
                        state = 115;
                        break;
                    }
                    publitBuf.append(e);
                    break;
                }
                case 115: {
                    if (e == '\"' && !inQuote) {
                        if (this.debug > 1) {
                            this.log("Entering \"");
                        }
                        inQuote = true;
                        isSingleQuote = false;
                        break;
                    }
                    if (e == '\'' && !inQuote) {
                        if (this.debug > 1) {
                            this.log("Entering '");
                        }
                        inQuote = true;
                        isSingleQuote = true;
                        break;
                    }
                    if (e == '\"' && inQuote && !isSingleQuote || e == '\'' && inQuote && isSingleQuote) {
                        if (this.debug > 1) {
                            this.log("Leaving " + e);
                        }
                        inQuote = false;
                        whitespace = true;
                        if (this.debug > 1) {
                            this.log("Switched from STATE_SYS_LIT to STATE_INT_SUBSET");
                        }
                        state = 105;
                        break;
                    }
                    syslitBuf.append(e);
                    break;
                }
                case 105: {
                    if (!inSubset) {
                        if (e == '[') {
                            inSubset = true;
                            break;
                        }
                        if (e != '>') break;
                        state = 120;
                        if (this.debug <= 1) break;
                        this.log("Switched from STATE_INT_SUBSET to STATE_EXIT");
                        break;
                    }
                    if (e == ']') {
                        if (this.debug > 1) {
                            this.log("Leaving ]");
                        }
                        inSubset = false;
                        break;
                    }
                    subsetBuf.append(e);
                }
            }
        }
        String pubId = publitBuf.toString();
        String intSubset = subsetBuf.toString();
        boolean noPubId = pubId.length() == 0;
        boolean noIntSubset = intSubset.length() == 0;
        this.doctype = new DoctypeImpl(nameBuf.toString(), noPubId ? null : pubId, syslitBuf.toString(), noIntSubset ? null : intSubset);
    }

    public final Doctype getDoctype() {
        return this.doctype;
    }

    public String getErrorMessage() {
        return this.errMsg;
    }

    private final boolean isWhitespace(char c) {
        if (c > ' ') {
            return false;
        }
        return c == ' ' || c == '\n' || c == '\t' || c == '\r';
    }

    public void log(String s) {
        System.out.println(s);
    }

    public void log(int s) {
        System.out.print("" + (char)s);
    }
}

