/*
 * Decompiled with CFR 0.152.
 */
package org.ironjacamar.validator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.ironjacamar.validator.Failure;
import org.ironjacamar.validator.Rule;
import org.ironjacamar.validator.SecurityActions;
import org.ironjacamar.validator.Validate;
import org.ironjacamar.validator.rules.ao.AOConfigProperties;
import org.ironjacamar.validator.rules.ao.AOConstructor;
import org.ironjacamar.validator.rules.ao.AONull;
import org.ironjacamar.validator.rules.ao.AORAA;
import org.ironjacamar.validator.rules.as.AS;
import org.ironjacamar.validator.rules.as.ASConfigProperties;
import org.ironjacamar.validator.rules.as.ASConstructor;
import org.ironjacamar.validator.rules.as.ASNull;
import org.ironjacamar.validator.rules.cf.CFConstructor;
import org.ironjacamar.validator.rules.cf.CFNull;
import org.ironjacamar.validator.rules.cf.CFReferenceable;
import org.ironjacamar.validator.rules.cf.CFSerializable;
import org.ironjacamar.validator.rules.mc.MC;
import org.ironjacamar.validator.rules.mc.MCGetMetaData;
import org.ironjacamar.validator.rules.mcf.MCF;
import org.ironjacamar.validator.rules.mcf.MCFConfigProperties;
import org.ironjacamar.validator.rules.mcf.MCFConstructor;
import org.ironjacamar.validator.rules.mcf.MCFEquals;
import org.ironjacamar.validator.rules.mcf.MCFHashCode;
import org.ironjacamar.validator.rules.mcf.MCFNull;
import org.ironjacamar.validator.rules.ra.RA;
import org.ironjacamar.validator.rules.ra.RAConfigProperties;
import org.ironjacamar.validator.rules.ra.RAConstructor;
import org.ironjacamar.validator.rules.ra.RAEquals;
import org.ironjacamar.validator.rules.ra.RAHashCode;
import org.ironjacamar.validator.rules.ra.RANull;

public class Validator {
    private static final Rule[] CLASS_RULES = new Rule[]{new MCFNull(), new MCF(), new MCFConstructor(), new MCFHashCode(), new MCFEquals(), new MCFConfigProperties(), new MC(), new MCGetMetaData(), new RANull(), new RA(), new RAConstructor(), new RAHashCode(), new RAEquals(), new RAConfigProperties(), new CFConstructor(), new CFNull(), new CFSerializable(), new CFReferenceable(), new ASNull(), new AS(), new ASConstructor(), new ASConfigProperties(), new AONull(), new AOConstructor(), new AOConfigProperties(), new AORAA()};
    private static final Rule[] OBJECT_RULES = new Rule[]{new MCGetMetaData()};
    private static Rule[] allRules;

    public ResourceBundle getResourceBundle() {
        return ResourceBundle.getBundle("validator", Locale.US, SecurityActions.getClassLoader(Validator.class));
    }

    public List<Failure> validate(List<Validate> objects) {
        if (objects == null || objects.isEmpty()) {
            return null;
        }
        return this.execRulesOnValidates(objects);
    }

    private List<Failure> execRulesOnValidates(List<Validate> objects) {
        ResourceBundle resourceBundle = this.getResourceBundle();
        LinkedList<Failure> result = null;
        for (Rule rule : allRules) {
            for (Validate obj : objects) {
                List<Failure> failures = rule.validate(obj, resourceBundle);
                if (failures == null) continue;
                if (result == null) {
                    result = new LinkedList<Failure>();
                }
                result.addAll(failures);
            }
        }
        return result;
    }

    static {
        ArrayList<Rule> arrayList = new ArrayList<Rule>();
        arrayList.addAll(Arrays.asList(CLASS_RULES));
        arrayList.addAll(Arrays.asList(OBJECT_RULES));
        allRules = arrayList.toArray(new Rule[CLASS_RULES.length + OBJECT_RULES.length]);
    }
}

