/*
 * Decompiled with CFR 0.152.
 */
package org.ironjacamar.validator.ant;

import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.CommandlineJava;
import org.apache.tools.ant.types.Path;
import org.ironjacamar.validator.Validation;
import org.ironjacamar.validator.ant.SecurityActions;

public class ValidatorTask
extends Task {
    private String outputDir = ".";
    private String rarFile;
    private CommandlineJava cmdl = new CommandlineJava();

    public String getOutputDir() {
        return this.outputDir;
    }

    public void setOutputDir(String outputDir) {
        this.outputDir = outputDir;
    }

    public String getRarFile() {
        return this.rarFile;
    }

    public void setRarFile(String rarFile) {
        this.rarFile = rarFile;
    }

    public void setClasspath(Path s) {
        this.createClasspath().append(s);
    }

    public Path createClasspath() {
        return this.getCommandLine().createClasspath(this.getProject()).createPath();
    }

    public CommandlineJava getCommandLine() {
        return this.cmdl;
    }

    public void execute() throws BuildException {
        ClassLoader oldCL = SecurityActions.getThreadContextClassLoader();
        try {
            SecurityActions.setThreadContextClassLoader(SecurityActions.getClassLoader(ValidatorTask.class));
            Validation.validate(new File(this.getRarFile()).toURI().toURL(), this.getOutputDir(), this.getCommandLine().getClasspath().list());
        }
        catch (Throwable t) {
            throw new BuildException(t.getMessage(), t);
        }
        finally {
            SecurityActions.setThreadContextClassLoader(oldCL);
        }
    }
}

