/*
 * Decompiled with CFR 0.152.
 */
package org.ironjacamar.validator.rules;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.ironjacamar.common.api.metadata.spec.ConfigProperty;
import org.ironjacamar.validator.Failure;
import org.ironjacamar.validator.ValidateClass;
import org.ironjacamar.validator.rules.SecurityActions;

public class ConfigPropertiesHelper {
    public static final Set<Class> VALID_TYPES = new HashSet<Class>(9);
    public static final Set<Class> WARNING_TYPES;

    public static List<Failure> validateConfigPropertiesType(ValidateClass vo, String section, String failMsg) {
        ArrayList<Failure> failures = new ArrayList<Failure>(1);
        for (ConfigProperty configProperty : vo.getConfigProperties()) {
            try {
                ConfigPropertiesHelper.containGetOrIsMethod(vo, "get", configProperty, section, failMsg, failures);
            }
            catch (Throwable t) {
                try {
                    ConfigPropertiesHelper.containGetOrIsMethod(vo, "is", configProperty, section, failMsg, failures);
                }
                catch (Throwable throwable) {}
            }
        }
        if (failures.isEmpty()) {
            return null;
        }
        return failures;
    }

    private static void containGetOrIsMethod(ValidateClass vo, String getOrIs, ConfigProperty cpmd, String section, String failMsg, List<Failure> failures) throws NoSuchMethodException {
        Method method;
        String methodName = getOrIs + cpmd.getConfigPropertyName().getValue().substring(0, 1).toUpperCase(Locale.US);
        if (cpmd.getConfigPropertyName().getValue().length() > 1) {
            methodName = methodName + cpmd.getConfigPropertyName().getValue().substring(1);
        }
        if (!VALID_TYPES.contains((method = SecurityActions.getMethod(vo.getClazz(), methodName, null)).getReturnType())) {
            StringBuilder sb = new StringBuilder("Class: " + vo.getClazz().getName());
            sb = sb.append(" Property: " + cpmd.getConfigPropertyName().getValue());
            sb = sb.append(" Type: " + method.getReturnType().getName());
            Failure failure = WARNING_TYPES.contains(method.getReturnType()) ? new Failure(0, section, failMsg, sb.toString()) : new Failure(1, section, failMsg, sb.toString());
            failures.add(failure);
        }
    }

    static {
        VALID_TYPES.add(Boolean.class);
        VALID_TYPES.add(Byte.class);
        VALID_TYPES.add(Character.class);
        VALID_TYPES.add(Double.class);
        VALID_TYPES.add(Float.class);
        VALID_TYPES.add(Integer.class);
        VALID_TYPES.add(Long.class);
        VALID_TYPES.add(Short.class);
        VALID_TYPES.add(String.class);
        WARNING_TYPES = new HashSet<Class>(8);
        WARNING_TYPES.add(Boolean.TYPE);
        WARNING_TYPES.add(Byte.TYPE);
        WARNING_TYPES.add(Character.TYPE);
        WARNING_TYPES.add(Double.TYPE);
        WARNING_TYPES.add(Float.TYPE);
        WARNING_TYPES.add(Integer.TYPE);
        WARNING_TYPES.add(Long.TYPE);
        WARNING_TYPES.add(Short.TYPE);
    }
}

