/*
 * Decompiled with CFR 0.152.
 */
package org.ironjacamar.validator.rules.mc;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.resource.spi.ManagedConnection;
import org.ironjacamar.validator.Failure;
import org.ironjacamar.validator.Key;
import org.ironjacamar.validator.Rule;
import org.ironjacamar.validator.Validate;
import org.ironjacamar.validator.ValidateObject;
import org.ironjacamar.validator.rules.mc.SecurityActions;

public class MCGetMetaData
implements Rule {
    private static final String SECTION = "6.5.5.2";

    @Override
    public List<Failure> validate(Validate v, ResourceBundle rb) {
        if (v != null && Key.MANAGED_CONNECTION == v.getKey() && ManagedConnection.class.isAssignableFrom(v.getClazz())) {
            boolean error = false;
            ValidateObject vo = null;
            if (v instanceof ValidateObject) {
                vo = (ValidateObject)v;
            }
            if (vo == null) {
                error = true;
            } else {
                try {
                    Class<?> clz = vo.getClazz();
                    Method gmd = SecurityActions.getMethod(clz, "getMetaData", null);
                    Object md = gmd.invoke(vo.getObject(), (Object[])null);
                    if (md == null) {
                        error = true;
                    }
                }
                catch (Throwable clz) {
                    // empty catch block
                }
            }
            if (error) {
                ArrayList<Failure> failures = new ArrayList<Failure>(1);
                Failure failure = new Failure(1, SECTION, rb.getString("mc.MCGetMetaData"), vo.getClazz().getName());
                failures.add(failure);
                return failures;
            }
        }
        return null;
    }
}

