/*
 * Decompiled with CFR 0.152.
 */
package org.ironjacamar.validator.rules.mcf;

import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.resource.spi.ManagedConnectionFactory;
import org.ironjacamar.validator.Failure;
import org.ironjacamar.validator.Key;
import org.ironjacamar.validator.Rule;
import org.ironjacamar.validator.Validate;
import org.ironjacamar.validator.rules.mcf.SecurityActions;

public class MCFEquals
implements Rule {
    private static final String SECTION = "6.5.3.2";

    @Override
    public List<Failure> validate(Validate vo, ResourceBundle rb) {
        if (vo != null && Key.MANAGED_CONNECTION_FACTORY == vo.getKey() && vo.getClazz() != null && ManagedConnectionFactory.class.isAssignableFrom(vo.getClazz())) {
            boolean error = true;
            Class<?> clz = vo.getClazz();
            while (error && !clz.equals(Object.class)) {
                try {
                    SecurityActions.getDeclaredMethod(clz, "equals", Object.class);
                    error = false;
                }
                catch (Throwable t) {
                    clz = clz.getSuperclass();
                }
            }
            if (error) {
                ArrayList<Failure> failures = new ArrayList<Failure>(1);
                Failure failure = new Failure(1, SECTION, rb.getString("mcf.MCFEquals"), vo.getClazz().getName());
                failures.add(failure);
                return failures;
            }
        }
        return null;
    }
}

