/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.docant.task;

import org.apache.tools.ant.BuildException;
import org.jboss.docant.task.AbstractDocbookTask;
import org.jboss.jdocbook.profile.Profiler;
import org.jboss.jdocbook.profile.ProfilingSource;
import org.jboss.jdocbook.render.FormatOptions;
import org.jboss.jdocbook.render.Renderer;
import org.jboss.jdocbook.render.RenderingSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenerationTask
extends AbstractDocbookTask {
    private static final Logger log = LoggerFactory.getLogger(GenerationTask.class);

    @Override
    public void process() throws BuildException {
        if (!this.sourceDirectory.exists()) {
            log.info("sourceDirectory [" + this.sourceDirectory.getAbsolutePath() + "] did not exist");
            return;
        }
        Profiler profiler = this.getComponentRegistry().getProfiler();
        Renderer renderer = this.getComponentRegistry().getRenderer();
        for (AbstractDocbookTask.PublishingSource publishingSource : this.resolvePublishingSources()) {
            if (this.profiling.isEnabled()) {
                profiler.profile((ProfilingSource)publishingSource);
            }
            for (FormatOptions formatOptions : this.getFormatOptionsList()) {
                renderer.render((RenderingSource)publishingSource, formatOptions);
            }
        }
    }
}

