/*
 * Decompiled with CFR 0.152.
 */
package org.ironjacamar.sjc;

import com.github.fungal.api.Kernel;
import com.github.fungal.api.KernelFactory;
import com.github.fungal.api.configuration.DeploymentOrder;
import com.github.fungal.api.configuration.KernelConfiguration;
import com.github.fungal.api.events.EventListener;
import com.github.fungal.api.remote.Command;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import org.ironjacamar.sjc.PostClassLoaderEventListener;
import org.ironjacamar.sjc.PreClassLoaderEventListener;
import org.ironjacamar.sjc.SecurityActions;
import org.ironjacamar.sjc.Shutdown;

public class Main {
    private static final String DEFAULT_NAME = "ironjacamar";
    private static final String IRONJACAMAR_PROPERTIES = "ironjacamar.properties";
    private static Kernel kernel;
    private static Object logging;

    private Main() {
    }

    private static void boot(String[] args, ThreadGroup tg) {
        try {
            Properties properties = Main.loadProperties();
            ArrayList<String> order = new ArrayList<String>(5);
            order.add(".xml");
            order.add(".rar");
            order.add("-ra.xml");
            order.add("-ds.xml");
            order.add(".war");
            KernelConfiguration kernelConfiguration = new KernelConfiguration();
            String configurationName = Main.configurationString(properties, "name", DEFAULT_NAME);
            kernelConfiguration = kernelConfiguration.name(configurationName);
            kernelConfiguration = kernelConfiguration.classLoader(0);
            kernelConfiguration = kernelConfiguration.management(Main.configurationBoolean(properties, "management", true));
            kernelConfiguration = kernelConfiguration.parallelDeploy(Main.configurationBoolean(properties, "parallel.deploy", true));
            kernelConfiguration = kernelConfiguration.remoteAccess(Main.configurationBoolean(properties, "remote.access", true));
            kernelConfiguration = kernelConfiguration.remotePort(Main.configurationInteger(properties, "remote.port", 1202));
            kernelConfiguration = kernelConfiguration.eventListener((EventListener)new PreClassLoaderEventListener());
            kernelConfiguration = kernelConfiguration.eventListener((EventListener)new PostClassLoaderEventListener());
            kernelConfiguration = kernelConfiguration.command((Command)new Shutdown());
            kernelConfiguration = kernelConfiguration.deploymentOrder(new DeploymentOrder(order));
            kernelConfiguration = kernelConfiguration.remoteJmxAccess(Main.configurationBoolean(properties, "remote.jmx.access", true));
            kernelConfiguration = kernelConfiguration.usePlatformMBeanServer(Main.configurationBoolean(properties, "use.platform.mbeanserver", true));
            kernelConfiguration = kernelConfiguration.beanManagement(Main.configurationBoolean(properties, "bean.management", true));
            Main.applySystemProperties(properties);
            String home = SecurityActions.getSystemProperty(configurationName + ".home");
            if (home != null) {
                kernelConfiguration.home(new File(home).toURI().toURL());
            } else {
                home = new File(".").toURI().toURL().toString();
                File root = new File(new URI(home.substring(0, home.lastIndexOf("bin"))));
                kernelConfiguration.home(root.toURI().toURL());
            }
            if (args != null && args.length > 0) {
                for (int i = 0; i < args.length; ++i) {
                    if (!"-b".equals(args[i])) continue;
                    kernelConfiguration.bindAddress(args[++i]);
                }
            }
            if (tg != null) {
                kernelConfiguration.threadGroup(tg);
            }
            kernel = KernelFactory.create((KernelConfiguration)kernelConfiguration);
            kernel.startup();
            Main.initLogging(SecurityActions.getThreadContextClassLoader());
        }
        catch (Throwable t) {
            Main.error(t.getMessage(), t);
        }
    }

    private static void initLogging(ClassLoader cl) {
        try {
            Class<?> clz = Class.forName("org.jboss.logging.Logger", true, cl);
            Method mGetLogger = clz.getMethod("getLogger", String.class);
            logging = mGetLogger.invoke(null, "org.ironjacamar.sjc.Main");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void error(Object o, Throwable t) {
        if (logging != null) {
            try {
                Class<?> clz = logging.getClass();
                Method mError = clz.getMethod("error", Object.class, Throwable.class);
                mError.invoke(logging, o, t);
            }
            catch (Throwable throwable) {}
        } else {
            if (o != null) {
                System.out.println(o.toString());
            }
            if (t != null) {
                t.printStackTrace(System.out);
            }
        }
    }

    private static void warn(Object o) {
        if (logging != null) {
            try {
                Class<?> clz = logging.getClass();
                Method mWarn = clz.getMethod("warn", Object.class);
                mWarn.invoke(logging, o);
            }
            catch (Throwable throwable) {}
        } else if (o != null) {
            System.out.println(o.toString());
        }
    }

    private static void info(Object o) {
        if (logging != null) {
            try {
                Class<?> clz = logging.getClass();
                Method mInfo = clz.getMethod("info", Object.class);
                mInfo.invoke(logging, o);
            }
            catch (Throwable throwable) {}
        } else if (o != null) {
            System.out.println(o.toString());
        }
    }

    private static boolean isDebugEnabled() {
        if (logging != null) {
            try {
                Class<?> clz = logging.getClass();
                Method mIsDebugEnabled = clz.getMethod("isDebugEnabled", null);
                return (Boolean)mIsDebugEnabled.invoke(logging, (Object[])null);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return true;
    }

    private static void debug(Object o) {
        if (logging != null) {
            try {
                Class<?> clz = logging.getClass();
                Method mDebug = clz.getMethod("debug", Object.class);
                mDebug.invoke(logging, o);
            }
            catch (Throwable throwable) {}
        } else if (o != null) {
            System.out.println(o.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties loadProperties() {
        FileInputStream fis;
        File file;
        Properties properties = new Properties();
        boolean loaded = false;
        String sysProperty = SecurityActions.getSystemProperty("ironjacamar.options");
        if (sysProperty != null && !sysProperty.equals("") && (file = new File(sysProperty)).exists()) {
            fis = null;
            try {
                fis = new FileInputStream(file);
                properties.load(fis);
                loaded = true;
            }
            catch (Throwable throwable) {
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        if (!loaded && (file = new File(IRONJACAMAR_PROPERTIES)).exists()) {
            fis = null;
            try {
                fis = new FileInputStream(file);
                properties.load(fis);
                loaded = true;
            }
            catch (Throwable throwable) {
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        if (!loaded) {
            InputStream is = null;
            try {
                ClassLoader cl = Main.class.getClassLoader();
                is = cl.getResourceAsStream(IRONJACAMAR_PROPERTIES);
                properties.load(is);
                loaded = true;
            }
            catch (Throwable throwable) {
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return properties;
    }

    private static String configurationString(Properties properties, String key, String defaultValue) {
        if (properties != null) {
            return properties.getProperty(key, defaultValue);
        }
        return defaultValue;
    }

    private static boolean configurationBoolean(Properties properties, String key, boolean defaultValue) {
        if (properties != null && properties.containsKey(key)) {
            return Boolean.valueOf(properties.getProperty(key));
        }
        return defaultValue;
    }

    private static int configurationInteger(Properties properties, String key, int defaultValue) {
        if (properties != null && properties.containsKey(key)) {
            return Integer.valueOf(properties.getProperty(key));
        }
        return defaultValue;
    }

    private static void applySystemProperties(Properties properties) {
        if (properties != null) {
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                String key = (String)entry.getKey();
                if (!key.startsWith("system.property.")) continue;
                key = key.substring(16);
                SecurityActions.setSystemProperty(key, (String)entry.getValue());
            }
        }
    }

    public static void main(String[] args) {
        long l1 = System.currentTimeMillis();
        try {
            ThreadGroup threads = new ThreadGroup(DEFAULT_NAME);
            Main.boot(args, threads);
            LifeThread lifeThread = new LifeThread(threads);
            lifeThread.start();
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    long l1 = System.currentTimeMillis();
                    try {
                        if (kernel != null) {
                            kernel.shutdown();
                        }
                    }
                    catch (Throwable t) {
                        Main.error(t.getMessage(), t);
                    }
                    long l2 = System.currentTimeMillis();
                    Main.info("Server stopped in " + (l2 - l1) + "ms");
                }
            });
            long l2 = System.currentTimeMillis();
            Main.info("Server started in " + (l2 - l1) + "ms");
        }
        catch (Exception e) {
            Main.error("Exception during main()", e);
        }
    }

    private static class LifeThread
    extends Thread {
        private Object lock = new Object();

        LifeThread(ThreadGroup tg) {
            super(tg, "IronJacamarLifeThread");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = this.lock;
            synchronized (object) {
                try {
                    this.lock.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }
}

