/*
 * Decompiled with CFR 0.152.
 */
package org.ironjacamar.codegenerator;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.ironjacamar.codegenerator.AdminObjectType;
import org.ironjacamar.codegenerator.BaseProfile;
import org.ironjacamar.codegenerator.BasicType;
import org.ironjacamar.codegenerator.ConfigPropType;
import org.ironjacamar.codegenerator.Definition;
import org.ironjacamar.codegenerator.JCA10Profile;
import org.ironjacamar.codegenerator.JCA15Profile;
import org.ironjacamar.codegenerator.JCA16Profile;
import org.ironjacamar.codegenerator.JCA17Profile;
import org.ironjacamar.codegenerator.McfDef;
import org.ironjacamar.codegenerator.MethodForConnection;
import org.ironjacamar.codegenerator.MethodParam;
import org.ironjacamar.codegenerator.Utils;

public class Main {
    private static final int SUCCESS = 0;
    private static final int ERROR = 1;
    private static final int OTHER = 2;
    private static final String PACKAGE_NAME_PATTERN = "^[a-z|A-Z][\\w|\\.]*[\\w]$";
    private static final String CLASS_NAME_PATTERN = "^[a-z|A-Z][\\w]*";
    private static ResourceBundle rb = ResourceBundle.getBundle("codegenerator", Locale.getDefault());

    public static void main(String[] args) {
        String outputDir = "out";
        String defxml = null;
        int arg = 0;
        if (args.length > 0) {
            while (args.length > arg + 1) {
                if (args[arg].startsWith("-")) {
                    if (args[arg].equals("-o")) {
                        if (++arg >= args.length) {
                            Main.usage();
                            System.exit(2);
                        }
                        outputDir = args[arg];
                    } else if (args[arg].equals("-f")) {
                        if (++arg >= args.length) {
                            Main.usage();
                            System.exit(2);
                        }
                        defxml = args[arg];
                    }
                } else {
                    Main.usage();
                    System.exit(2);
                }
                ++arg;
            }
        }
        try {
            BaseProfile profile;
            File out = new File(outputDir);
            Utils.recursiveDelete(out);
            Definition def = defxml == null ? Main.inputFromCommandLine() : Main.inputFromXml(defxml);
            if (def == null) {
                System.exit(1);
            }
            def.setOutputDir(outputDir);
            switch (def.getVersion()) {
                case "1.7": {
                    profile = new JCA17Profile();
                    break;
                }
                case "1.6": {
                    profile = new JCA16Profile();
                    break;
                }
                case "1.5": {
                    profile = new JCA15Profile();
                    break;
                }
                default: {
                    profile = new JCA10Profile();
                }
            }
            profile.generate(def);
            if (def.getBuild().equals("ant")) {
                Main.copyAllJars(outputDir);
            }
            System.out.println(rb.getString("code.wrote"));
            System.exit(0);
        }
        catch (IOException | JAXBException e) {
            e.printStackTrace();
        }
    }

    private static Definition inputFromXml(String defxml) throws IOException, JAXBException {
        JAXBContext context = JAXBContext.newInstance((String)"org.ironjacamar.codegenerator");
        Unmarshaller unmarshaller = context.createUnmarshaller();
        return (Definition)unmarshaller.unmarshal(new File(defxml));
    }

    private static Definition inputFromCommandLine() throws IOException {
        String packageName;
        String version;
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        Definition def = new Definition();
        HashSet<String> classes = new HashSet<String>();
        do {
            System.out.print(rb.getString("profile.version") + " " + rb.getString("profile.version.values") + " [1.7]: ");
            version = in.readLine();
            if (version != null && !version.equals("")) continue;
            version = "1.7";
        } while (!version.equals("1.7") && !version.equals("1.6") && !version.equals("1.5") && !version.equals("1.0"));
        def.setVersion(version);
        def.setSupportOutbound(true);
        def.setSupportInbound(false);
        if (!version.equals("1.0")) {
            System.out.print(rb.getString("support.bound") + " " + rb.getString("support.bound.values") + " [O]: ");
            String bound = in.readLine();
            if (!(bound == null || bound.equals("") || bound.equals("O") || bound.equals("o") || bound.equals("Outbound"))) {
                if (bound.equals("I") || bound.equals("i") || bound.equals("Inbound")) {
                    def.setSupportOutbound(false);
                    def.setSupportInbound(true);
                } else if (bound.equals("B") || bound.equals("b") || bound.equals("Bidirectional")) {
                    def.setSupportOutbound(true);
                    def.setSupportInbound(true);
                }
            }
        }
        while (true) {
            System.out.print(rb.getString("package.name") + ": ");
            packageName = in.readLine();
            if (packageName.contains(".") && Pattern.matches(PACKAGE_NAME_PATTERN, packageName)) break;
            System.out.println(rb.getString("package.name.validated"));
        }
        def.setRaPackage(packageName);
        if (def.isSupportOutbound()) {
            System.out.print(rb.getString("support.transaction") + " " + rb.getString("support.transaction.values") + " [N]: ");
            String trans = in.readLine();
            if (trans == null || trans.equals("")) {
                def.setSupportTransaction("NoTransaction");
            } else if (trans.equals("L") || trans.equals("l") || trans.equals("LocalTransaction")) {
                def.setSupportTransaction("LocalTransaction");
            } else if (trans.equals("X") || trans.equals("x") || trans.equals("XATransaction")) {
                def.setSupportTransaction("XATransaction");
            } else {
                def.setSupportTransaction("NoTransaction");
            }
        }
        if (def.isSupportOutbound() && !version.equals("1.0")) {
            System.out.print(rb.getString("support.reauthentication") + " " + rb.getString("yesno") + " [N]: ");
            String reauth = in.readLine();
            if (reauth == null || reauth.equals("")) {
                def.setSupportReauthen(false);
            } else if (reauth.equals("Y") || reauth.equals("y") || reauth.equals("Yes")) {
                def.setSupportReauthen(true);
            } else {
                def.setSupportReauthen(false);
            }
        }
        if (version.equals("1.7") || version.equals("1.6")) {
            System.out.print(rb.getString("use.annotation") + " " + rb.getString("yesno") + " [Y]: ");
            String useAnnotation = in.readLine();
            if (useAnnotation == null) {
                def.setUseAnnotation(true);
            } else if (useAnnotation.equals("N") || useAnnotation.equals("n") || useAnnotation.equals("No")) {
                def.setUseAnnotation(false);
            } else {
                def.setUseAnnotation(true);
            }
        } else {
            def.setUseAnnotation(false);
        }
        if (def.isSupportOutbound() && !def.isSupportInbound() && (version.equals("1.7") || version.equals("1.6") || version.equals("1.5"))) {
            System.out.print(rb.getString("use.ra") + " " + rb.getString("yesno") + " [Y]: ");
            String useRa = in.readLine();
            if (useRa == null) {
                def.setUseRa(true);
            } else if (useRa.equals("N") || useRa.equals("n") || useRa.equals("No")) {
                def.setUseRa(false);
            } else {
                def.setUseRa(true);
            }
        } else if (version.equals("1.0")) {
            def.setUseRa(false);
        } else {
            def.setUseRa(true);
        }
        if (def.isUseRa() || def.isSupportInbound()) {
            block119: {
                String raClassName;
                while (true) {
                    System.out.print(rb.getString("ra.class.name"));
                    System.out.print(" [" + def.getRaClass() + "]: ");
                    raClassName = in.readLine();
                    if (raClassName == null || raClassName.equals("")) break block119;
                    if (Pattern.matches(CLASS_NAME_PATTERN, raClassName)) break;
                    System.out.println(rb.getString("class.name.validated"));
                }
                def.setRaClass(raClassName);
                classes.add(raClassName);
                Main.setDefaultValue(def, raClassName, "ResourceAdapter");
                Main.setDefaultValue(def, raClassName, "Ra");
            }
            System.out.print(rb.getString("ra.serial") + " " + rb.getString("yesno") + " [Y]: ");
            String raSerial = in.readLine();
            if (raSerial == null) {
                def.setRaSerial(true);
            } else if (raSerial.equals("N") || raSerial.equals("n") || raSerial.equals("No")) {
                def.setRaSerial(false);
            } else {
                def.setRaSerial(true);
            }
            List<ConfigPropType> raProps = Main.inputProperties("ra", in, false);
            def.setRaConfigProps(raProps);
        }
        if (def.isSupportOutbound()) {
            boolean moreMcf;
            ArrayList<McfDef> mcfDefs = new ArrayList<McfDef>();
            def.setMcfDefs(mcfDefs);
            int mcfID = 1;
            do {
                McfDef mcfdef = new McfDef(mcfID, def);
                String mcfClassName = "";
                do {
                    System.out.print(rb.getString("mcf.class.name"));
                    System.out.print(" [" + mcfdef.getMcfClass() + "]: ");
                    mcfClassName = in.readLine();
                    if (mcfClassName.equals("") || Pattern.matches(CLASS_NAME_PATTERN, mcfClassName)) continue;
                    System.out.println(rb.getString("class.name.validated"));
                } while ((classes.contains(mcfClassName) || !Pattern.matches(CLASS_NAME_PATTERN, mcfClassName)) && !mcfClassName.equals(""));
                classes.add(mcfClassName);
                if (!mcfClassName.equals("")) {
                    mcfdef.setMcfClass(mcfClassName);
                    Main.setDefaultValue(def, mcfClassName, "ManagedConnectionFactory");
                    Main.setDefaultValue(def, mcfClassName, "Mcf");
                }
                List<ConfigPropType> mcfProps = Main.inputProperties("mcf", in, false);
                mcfdef.setMcfConfigProps(mcfProps);
                if (def.isUseRa()) {
                    System.out.print(rb.getString("mcf.impl.raa") + " " + rb.getString("yesno") + " [Y]: ");
                    String raAssociation = in.readLine();
                    if (raAssociation == null || raAssociation.equals("")) {
                        mcfdef.setImplRaAssociation(true);
                    } else if (raAssociation.equals("Y") || raAssociation.equals("y") || raAssociation.equals("Yes")) {
                        mcfdef.setImplRaAssociation(true);
                    } else {
                        mcfdef.setImplRaAssociation(false);
                    }
                }
                String mcClassName = "";
                do {
                    System.out.print(rb.getString("mc.class.name"));
                    System.out.print(" [" + mcfdef.getMcClass() + "]: ");
                    mcClassName = in.readLine();
                    if (mcClassName.equals("") || Pattern.matches(CLASS_NAME_PATTERN, mcClassName)) continue;
                    System.out.println(rb.getString("class.name.validated"));
                } while ((classes.contains(mcClassName) || !Pattern.matches(CLASS_NAME_PATTERN, mcClassName)) && !mcClassName.equals(""));
                classes.add(mcClassName);
                if (mcClassName != null && !mcClassName.equals("")) {
                    mcfdef.setMcClass(mcClassName);
                }
                System.out.print(rb.getString("mcf.use.cci") + " " + rb.getString("yesno") + " [N]: ");
                String useCciConnection = in.readLine();
                if (useCciConnection == null) {
                    mcfdef.setUseCciConnection(false);
                } else if (useCciConnection.equals("Y") || useCciConnection.equals("y") || useCciConnection.equals("Yes")) {
                    mcfdef.setUseCciConnection(true);
                } else {
                    mcfdef.setUseCciConnection(false);
                }
                if (!mcfdef.isUseCciConnection()) {
                    String cfInterfaceName = "";
                    do {
                        System.out.print(rb.getString("cf.interface.name"));
                        System.out.print(" [" + mcfdef.getCfInterfaceClass() + "]: ");
                        cfInterfaceName = in.readLine();
                        if (cfInterfaceName.equals("") || Pattern.matches(CLASS_NAME_PATTERN, cfInterfaceName)) continue;
                        System.out.println(rb.getString("class.name.validated"));
                    } while ((classes.contains(cfInterfaceName) || !Pattern.matches(CLASS_NAME_PATTERN, cfInterfaceName)) && !cfInterfaceName.equals(""));
                    classes.add(cfInterfaceName);
                    if (cfInterfaceName != null && !cfInterfaceName.equals("")) {
                        mcfdef.setCfInterfaceClass(cfInterfaceName);
                    }
                    String cfClassName = "";
                    do {
                        System.out.print(rb.getString("cf.class.name"));
                        System.out.print(" [" + mcfdef.getCfClass() + "]: ");
                        cfClassName = in.readLine();
                        if (cfClassName.equals("") || Pattern.matches(CLASS_NAME_PATTERN, cfClassName)) continue;
                        System.out.println(rb.getString("class.name.validated"));
                    } while ((classes.contains(cfClassName) || !Pattern.matches(CLASS_NAME_PATTERN, cfClassName)) && !cfClassName.equals(""));
                    classes.add(cfClassName);
                    if (cfClassName != null && !cfClassName.equals("")) {
                        mcfdef.setCfClass(cfClassName);
                    }
                    String connInterfaceName = "";
                    do {
                        System.out.print(rb.getString("conn.interface.name"));
                        System.out.print(" [" + mcfdef.getConnInterfaceClass() + "]: ");
                        connInterfaceName = in.readLine();
                        if (connInterfaceName.equals("") || Pattern.matches(CLASS_NAME_PATTERN, connInterfaceName)) continue;
                        System.out.println(rb.getString("class.name.validated"));
                    } while ((classes.contains(connInterfaceName) || !Pattern.matches(CLASS_NAME_PATTERN, connInterfaceName)) && !connInterfaceName.equals(""));
                    classes.add(connInterfaceName);
                    if (connInterfaceName != null && !connInterfaceName.equals("")) {
                        mcfdef.setConnInterfaceClass(connInterfaceName);
                    }
                    String connImplName = "";
                    do {
                        System.out.print(rb.getString("conn.class.name"));
                        System.out.print(" [" + mcfdef.getConnImplClass() + "]: ");
                        connImplName = in.readLine();
                        if (connImplName.equals("") || Pattern.matches(CLASS_NAME_PATTERN, connImplName)) continue;
                        System.out.println(rb.getString("class.name.validated"));
                    } while ((classes.contains(connImplName) || !Pattern.matches(CLASS_NAME_PATTERN, connImplName)) && !connImplName.equals(""));
                    classes.add(connImplName);
                    if (connImplName != null && !connImplName.equals("")) {
                        mcfdef.setConnImplClass(connImplName);
                    }
                    System.out.print(rb.getString("connection.method.support") + " " + rb.getString("yesno") + " [N]: ");
                    String supportMethod = in.readLine();
                    if (supportMethod == null) {
                        mcfdef.setDefineMethodInConnection(false);
                    } else if (supportMethod.equals("Y") || supportMethod.equals("y") || supportMethod.equals("Yes")) {
                        mcfdef.setDefineMethodInConnection(true);
                    } else {
                        mcfdef.setDefineMethodInConnection(false);
                    }
                    if (mcfdef.isDefineMethodInConnection()) {
                        mcfdef.setMethods(Main.inputMethod(in));
                    }
                }
                mcfDefs.add(mcfdef);
                ++mcfID;
                moreMcf = false;
                if (!def.getVersion().equals("1.5") && !def.getVersion().equals("1.6") && !def.getVersion().equals("1.7")) continue;
                System.out.print(rb.getString("more.mcf") + " " + rb.getString("yesno") + " [N]: ");
                String inputMoreMcf = in.readLine();
                if (inputMoreMcf == null || !inputMoreMcf.equals("Y") && !inputMoreMcf.equals("y") && !inputMoreMcf.equals("Yes")) continue;
                moreMcf = true;
            } while (moreMcf);
        }
        if (def.isSupportInbound()) {
            String mlClassName = "";
            do {
                System.out.print(rb.getString("ml.interface.name"));
                System.out.print(" [" + def.getMlClass() + "]: ");
                mlClassName = in.readLine();
                if (mlClassName.equals("") || Pattern.matches(CLASS_NAME_PATTERN, mlClassName)) continue;
                System.out.println(rb.getString("class.name.validated"));
            } while ((classes.contains(mlClassName) || !Pattern.matches(CLASS_NAME_PATTERN, mlClassName)) && !mlClassName.equals(""));
            classes.add(mlClassName);
            boolean defaultPackage = true;
            if (mlClassName != null && !mlClassName.equals("")) {
                def.setMlClass(mlClassName);
                if (mlClassName.contains(".")) {
                    defaultPackage = false;
                } else {
                    Main.setDefaultValue(def, mlClassName, "MessageListener");
                    Main.setDefaultValue(def, mlClassName, "Ml");
                }
            }
            def.setDefaultPackageInbound(defaultPackage);
            String asClassName = "";
            do {
                System.out.print(rb.getString("as.class.name"));
                System.out.print(" [" + def.getAsClass() + "]: ");
                asClassName = in.readLine();
                if (asClassName.equals("") || Pattern.matches(CLASS_NAME_PATTERN, asClassName)) continue;
                System.out.println(rb.getString("class.name.validated"));
            } while ((classes.contains(asClassName) || !Pattern.matches(CLASS_NAME_PATTERN, asClassName)) && !asClassName.equals(""));
            classes.add(asClassName);
            if (asClassName != null && !asClassName.equals("")) {
                def.setAsClass(asClassName);
            }
            List<ConfigPropType> asProps = Main.inputProperties("as", in, true);
            def.setAsConfigProps(asProps);
            String actiClassName = "";
            do {
                System.out.print(rb.getString("acti.class.name"));
                System.out.print(" [" + def.getActivationClass() + "]: ");
                actiClassName = in.readLine();
                if (actiClassName.equals("") || Pattern.matches(CLASS_NAME_PATTERN, actiClassName)) continue;
                System.out.println(rb.getString("class.name.validated"));
            } while ((classes.contains(actiClassName) || !Pattern.matches(CLASS_NAME_PATTERN, actiClassName)) && !actiClassName.equals(""));
            classes.add(actiClassName);
            if (actiClassName != null && !actiClassName.equals("")) {
                def.setActivationClass(actiClassName);
            }
        }
        System.out.print(rb.getString("gen.adminobject") + " " + rb.getString("yesno") + " [N]: ");
        String genAo = in.readLine();
        if (genAo == null) {
            def.setGenAdminObject(false);
        } else if (genAo.equals("Y") || genAo.equals("y") || genAo.equals("Yes")) {
            def.setGenAdminObject(true);
        } else {
            def.setGenAdminObject(false);
        }
        if (def.isGenAdminObject()) {
            System.out.print(rb.getString("adminobject.raa") + " " + rb.getString("yesno") + " [Y]: ");
            String aoRaAssociation = in.readLine();
            if (aoRaAssociation == null || aoRaAssociation.equals("")) {
                def.setAdminObjectImplRaAssociation(true);
            } else if (aoRaAssociation.equals("Y") || aoRaAssociation.equals("y") || aoRaAssociation.equals("Yes")) {
                def.setAdminObjectImplRaAssociation(true);
            } else {
                def.setAdminObjectImplRaAssociation(false);
            }
        }
        int numOfAo = 0;
        while (numOfAo >= 0 && def.isGenAdminObject()) {
            String strOrder = numOfAo > 0 ? Integer.valueOf(numOfAo).toString() : "";
            AdminObjectType aoType = new AdminObjectType();
            String aoInterfaceName = "";
            do {
                System.out.print(rb.getString("adminobject.interface.name"));
                System.out.print(" [" + def.getDefaultValue() + strOrder + "AdminObject]: ");
                aoInterfaceName = in.readLine();
                if (aoInterfaceName.equals("") || Pattern.matches(CLASS_NAME_PATTERN, aoInterfaceName)) continue;
                System.out.println(rb.getString("class.name.validated"));
            } while ((classes.contains(aoInterfaceName) || !Pattern.matches(CLASS_NAME_PATTERN, aoInterfaceName)) && !aoInterfaceName.equals(""));
            classes.add(aoInterfaceName);
            if (aoInterfaceName != null && !aoInterfaceName.equals("")) {
                aoType.setAdminObjectInterface(aoInterfaceName);
            } else {
                aoType.setAdminObjectInterface(def.getDefaultValue() + strOrder + "AdminObject");
            }
            String aoClassName = "";
            do {
                System.out.print(rb.getString("adminobject.class.name"));
                System.out.print(" [" + def.getDefaultValue() + strOrder + "AdminObjectImpl]: ");
                aoClassName = in.readLine();
                if (aoClassName.equals("") || Pattern.matches(CLASS_NAME_PATTERN, aoClassName)) continue;
                System.out.println(rb.getString("class.name.validated"));
            } while ((classes.contains(aoClassName) || !Pattern.matches(CLASS_NAME_PATTERN, aoClassName)) && !aoClassName.equals(""));
            classes.add(aoClassName);
            if (aoClassName != null && !aoClassName.equals("")) {
                aoType.setAdminObjectClass(aoClassName);
            } else {
                aoType.setAdminObjectClass(def.getDefaultValue() + strOrder + "AdminObjectImpl");
            }
            List<ConfigPropType> aoProps = Main.inputProperties("adminobject", in, false);
            aoType.setAoConfigProps(aoProps);
            if (def.getAdminObjects() == null) {
                def.setAdminObjects(new ArrayList<AdminObjectType>());
            }
            def.getAdminObjects().add(aoType);
            System.out.print(rb.getString("gen.adminobject.other") + " " + rb.getString("yesno") + " [N]: ");
            String genAoAgain = in.readLine();
            if (genAoAgain == null) {
                numOfAo = -1;
                continue;
            }
            if (genAoAgain.equals("Y") || genAoAgain.equals("y") || genAoAgain.equals("Yes")) {
                ++numOfAo;
                continue;
            }
            numOfAo = -1;
        }
        if (!def.getVersion().equals("1.0") && def.isSupportOutbound() && !def.getMcfDefs().get(0).isUseCciConnection()) {
            System.out.print(rb.getString("gen.mbean") + " " + rb.getString("yesno") + " [Y]: ");
            String genMbean = in.readLine();
            if (genMbean == null) {
                def.setGenMbean(true);
            } else if (genMbean.equals("N") || genMbean.equals("n") || genMbean.equals("No")) {
                def.setGenMbean(false);
            } else {
                def.setGenMbean(true);
            }
            System.out.print(rb.getString("gen.eis") + " " + rb.getString("yesno") + " [N]: ");
            String genEis = in.readLine();
            if (genEis == null) {
                def.setSupportEis(false);
            } else if (genEis.equals("Y") || genEis.equals("y") || genEis.equals("Yes")) {
                def.setSupportEis(true);
            } else {
                def.setSupportEis(false);
            }
            if (def.isSupportEis()) {
                if (def.getMcfDefs().get(0).getMcfConfigProps() == null) {
                    def.getMcfDefs().get(0).setMcfConfigProps(new ArrayList<ConfigPropType>());
                }
                List<ConfigPropType> props = def.getMcfDefs().get(0).getMcfConfigProps();
                ConfigPropType host = new ConfigPropType("host", "String", "localhost", false);
                props.add(host);
                ConfigPropType port = new ConfigPropType("port", "Integer", "1400", false);
                props.add(port);
            }
        }
        System.out.print(rb.getString("support.jbosslogging") + " " + rb.getString("yesno") + " [N]: ");
        String supportJbossLogging = in.readLine();
        if (supportJbossLogging == null) {
            def.setSupportJbossLogging(false);
        } else if (supportJbossLogging.equals("Y") || supportJbossLogging.equals("y") || supportJbossLogging.equals("Yes")) {
            def.setSupportJbossLogging(true);
        } else {
            def.setSupportJbossLogging(false);
        }
        System.out.print(rb.getString("build.env") + " " + rb.getString("build.env.values"));
        System.out.print(" [" + def.getBuild() + "]: ");
        String buildEnv = in.readLine();
        if (buildEnv != null && !buildEnv.equals("")) {
            if (buildEnv.equalsIgnoreCase("i") || buildEnv.equalsIgnoreCase("ant+ivy") || buildEnv.equalsIgnoreCase("ivy")) {
                def.setBuild("ivy");
            } else if (buildEnv.equalsIgnoreCase("m") || buildEnv.equalsIgnoreCase("maven")) {
                def.setBuild("maven");
            } else if (buildEnv.equalsIgnoreCase("g") || buildEnv.equalsIgnoreCase("gradle")) {
                def.setBuild("gradle");
            } else {
                def.setBuild("ant");
            }
        } else {
            def.setBuild("ant");
        }
        return def;
    }

    private static void setDefaultValue(Definition def, String className, String stringValue) {
        if (className.endsWith(stringValue)) {
            def.setDefaultValue(className.substring(0, className.length() - stringValue.length()));
        }
    }

    private static void copyAllJars(String outputDir) throws IOException {
        File out = new File(outputDir);
        String targetPath = out.getAbsolutePath() + File.separatorChar + "lib";
        File current = new File(".");
        String path = current.getCanonicalPath();
        String libPath = path + File.separatorChar + ".." + File.separatorChar + ".." + File.separatorChar + "lib";
        Utils.copyFolder(libPath, targetPath, "jar", false);
    }

    private static List<ConfigPropType> inputProperties(String classname, BufferedReader in, boolean supportRequired) throws IOException {
        ArrayList<ConfigPropType> props = new ArrayList<ConfigPropType>();
        HashSet<String> propsNamesSet = new HashSet<String>();
        while (true) {
            String value;
            String type;
            String name;
            System.out.println(rb.getString(classname + ".config.properties") + " " + rb.getString("confirm.quit") + ": ");
            do {
                System.out.print("    " + rb.getString("config.properties.name") + ": ");
                name = in.readLine();
                if (name == null || name.equals("")) break;
                if (propsNamesSet.contains(name)) {
                    System.out.println("    " + rb.getString("config.properties.name.repeat"));
                }
                if (Pattern.matches(CLASS_NAME_PATTERN, name) && !BasicType.isBasicType(name) && !BasicType.isPrimitiveType(name)) continue;
                System.out.println("    " + rb.getString("config.properties.name.validated"));
            } while (propsNamesSet.contains(name) || !Pattern.matches(CLASS_NAME_PATTERN, name) || BasicType.isBasicType(name) || BasicType.isPrimitiveType(name));
            if (name == null || name.equals("")) break;
            propsNamesSet.add(name);
            while (true) {
                System.out.print("    " + rb.getString("config.properties.type") + ": ");
                type = in.readLine();
                if (BasicType.isBasicType(type)) break;
                System.out.print(rb.getString("config.properties.type.tip") + ": [");
                System.out.println(BasicType.allBasicType() + "]");
            }
            while (true) {
                System.out.print("    " + rb.getString("config.properties.value") + ": ");
                value = in.readLine();
                if (type.equals("String")) break;
                try {
                    Class<?> cs = Class.forName("java.lang." + type);
                    Method m = cs.getMethod("valueOf", String.class);
                    m.invoke(cs, value);
                }
                catch (Exception e) {
                    System.out.println("    " + rb.getString("config.properties.value.valid"));
                    continue;
                }
                break;
            }
            boolean required = false;
            if (supportRequired) {
                System.out.print("    " + rb.getString("config.properties.required") + " " + rb.getString("yesno") + " [N]: ");
                String propRequired = in.readLine();
                required = propRequired == null ? false : propRequired.equals("Y") || propRequired.equals("y") || propRequired.equals("Yes");
            }
            System.out.println();
            String lowerCaseFirstLetterName = name.substring(0, 1).toLowerCase(Locale.US);
            if (name.length() > 1) {
                lowerCaseFirstLetterName = lowerCaseFirstLetterName + name.substring(1);
            }
            ConfigPropType config = new ConfigPropType(lowerCaseFirstLetterName, type, value, required);
            props.add(config);
        }
        return props;
    }

    private static List<MethodForConnection> inputMethod(BufferedReader in) throws IOException {
        ArrayList<MethodForConnection> methods = new ArrayList<MethodForConnection>();
        HashSet<String> setMethodsSig = new HashSet<String>();
        while (true) {
            System.out.print("    " + rb.getString("connection.method.name") + " " + rb.getString("confirm.quit") + ": ");
            String methodName = in.readLine();
            if (methodName == null || methodName.equals("")) break;
            MethodForConnection method = new MethodForConnection();
            method.setMethodName(methodName);
            System.out.print("    " + rb.getString("connection.method.return") + ": ");
            String methodReturn = in.readLine();
            if (methodReturn != null && !methodReturn.equals("")) {
                method.setReturnType(methodReturn);
            }
            while (true) {
                System.out.print("    " + rb.getString("connection.method.param.name") + " " + rb.getString("confirm.quit") + ": ");
                String paramName = in.readLine();
                if (paramName == null || paramName.equals("")) break;
                String paramType = null;
                while (true) {
                    System.out.print("    " + rb.getString("connection.method.param.type") + ": ");
                    paramType = in.readLine();
                    if (paramType != null && !paramType.equals("") && (!paramType.contains(".") ? BasicType.isBasicType(paramType) || BasicType.isPrimitiveType(paramType) : paramType.indexOf(".") != 0)) break;
                    System.out.print(rb.getString("config.properties.type.tip") + ": [");
                    System.out.println(BasicType.allType() + "]");
                }
                MethodParam param = method.newParam(paramName, paramType);
                method.getParams().add(param);
            }
            if (setMethodsSig.contains(method.toString())) {
                System.out.println("    " + rb.getString("connection.method.repeat"));
                continue;
            }
            while (true) {
                System.out.print("    " + rb.getString("connection.method.exception") + ": ");
                String exceptions = in.readLine();
                if (exceptions == null || exceptions.equals("")) break;
                method.getExceptionType().add(exceptions);
            }
            methods.add(method);
            setMethodsSig.add(method.toString());
        }
        return methods;
    }

    private static void usage() {
        System.out.println("Usage: codegenerator [-o directory]");
    }
}

