/*
 * Decompiled with CFR 0.152.
 */
package org.ironjacamar.codegenerator;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;

public class Utils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFileIntoString(URL input) throws IOException {
        InputStream stream = null;
        InputStreamReader reader = null;
        try {
            stream = input.openStream();
            reader = new InputStreamReader(stream);
            String string = Utils.readStreamIntoString(reader);
            return string;
        }
        finally {
            if (reader != null) {
                reader.close();
            }
            if (stream != null) {
                stream.close();
            }
        }
    }

    private static String readStreamIntoString(Reader reader) throws IOException {
        int l;
        StringBuilder s = new StringBuilder();
        char[] a = new char[65536];
        while ((l = reader.read(a)) != -1) {
            if (l <= 0) {
                throw new IOException();
            }
            s.append(a, 0, l);
        }
        return s.toString();
    }

    public static FileWriter createSrcFile(String name, String packageName, String outDir) throws IOException {
        String directory = "src" + File.separatorChar + "main" + File.separatorChar + "java";
        return Utils.createPackageFile(name, packageName, directory, outDir);
    }

    public static FileWriter createTestFile(String name, String packageName, String outDir) throws IOException {
        String directory = "src" + File.separatorChar + "test" + File.separatorChar + "java";
        return Utils.createPackageFile(name, packageName, directory, outDir);
    }

    private static FileWriter createPackageFile(String name, String packageName, String directory, String outDir) throws IOException {
        File path;
        if (packageName != null && !packageName.trim().equals("")) {
            directory = directory + File.separatorChar + packageName.replace('.', File.separatorChar);
        }
        if (!(path = new File(outDir, directory)).exists() && !path.mkdirs()) {
            throw new IOException("outdir can't be created");
        }
        File file = new File(path.getAbsolutePath() + File.separatorChar + name);
        if (file.exists() && !file.delete()) {
            throw new IOException("there is exist file, please check");
        }
        return new FileWriter(file);
    }

    public static FileWriter createFile(String name, String outDir) throws IOException {
        File path = new File(outDir);
        if (!path.exists() && !path.mkdirs()) {
            throw new IOException("outdir can't be created");
        }
        File file = new File(path.getAbsolutePath() + File.separatorChar + name);
        if (file.exists() && !file.delete()) {
            throw new IOException("there is exist file, please check");
        }
        return new FileWriter(file);
    }

    public static void recursiveDelete(File f) throws IOException {
        if (f != null && f.exists()) {
            File[] files = f.listFiles();
            if (files != null) {
                for (int i = 0; i < files.length; ++i) {
                    if (files[i].isDirectory()) {
                        Utils.recursiveDelete(files[i]);
                        continue;
                    }
                    if (files[i].delete()) continue;
                    throw new IOException("Could not delete " + files[i]);
                }
            }
            if (!f.delete()) {
                throw new IOException("Could not delete " + f);
            }
        }
    }

    public static void copyFolder(String sourcePath, String targetPath, final String filterName, boolean recursive) throws IOException {
        File path = new File(targetPath);
        if (!path.exists() && !path.mkdirs()) {
            throw new IOException("outdir can't be created");
        }
        File a = new File(sourcePath);
        String[] fileNames = a.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String fname) {
                if (new File(dir, fname).isDirectory()) {
                    return true;
                }
                return fname.endsWith(filterName);
            }
        });
        File jarFile = null;
        if (fileNames != null) {
            for (String fileName : fileNames) {
                jarFile = new File(sourcePath + File.separator + fileName);
                if (jarFile.isFile()) {
                    Utils.copyFile(jarFile, targetPath);
                }
                if (!recursive || !jarFile.isDirectory()) continue;
                Utils.copyFolder(sourcePath + File.separator + fileName, targetPath + File.separator + fileName, filterName, recursive);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyFile(File sourceFile, String targetPath) throws FileNotFoundException, IOException {
        FileInputStream from = null;
        FileOutputStream to = null;
        try {
            int bytesRead;
            from = new FileInputStream(sourceFile);
            to = new FileOutputStream(targetPath + File.separator + sourceFile.getName());
            byte[] buffer = new byte[4096];
            while ((bytesRead = from.read(buffer)) != -1) {
                to.write(buffer, 0, bytesRead);
            }
        }
        finally {
            if (from != null) {
                try {
                    from.close();
                }
                catch (IOException iOException) {}
            }
            if (to != null) {
                try {
                    to.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

