/*
 * Decompiled with CFR 0.152.
 */
package org.ironjacamar.codegenerator.code;

import java.io.IOException;
import java.io.Writer;
import java.util.Locale;
import org.ironjacamar.codegenerator.BaseGen;
import org.ironjacamar.codegenerator.Definition;
import org.ironjacamar.codegenerator.MethodForConnection;
import org.ironjacamar.codegenerator.MethodParam;

public abstract class AbstractCodeGen
extends BaseGen {
    private int numOfMcf = 0;

    public void generate(Definition def, Writer out) throws IOException {
        this.writeHeader(def, out);
        this.writeImport(def, out);
        this.writeClassComment(def, out);
        this.writeClassBody(def, out);
    }

    void writeClassComment(Definition def, Writer out) throws IOException {
        out.write("/**\n");
        out.write(" * " + this.getClassName(def));
        this.writeEol(out);
        out.write(" *\n");
        out.write(" * @version $Revision: $\n");
        out.write(" */\n");
    }

    public abstract String getClassName(Definition var1);

    protected void writeSimpleMethodSignature(Writer out, int indent, String javadoc, String signature) throws IOException {
        this.writeWithIndent(out, indent, "/**\n");
        this.writeIndent(out, indent);
        out.write(javadoc);
        this.writeEol(out);
        this.writeWithIndent(out, indent, " */\n");
        this.writeIndent(out, indent);
        out.write(signature);
    }

    protected void writeMethodSignature(Writer out, int indent, MethodForConnection method) throws IOException {
        this.writeWithIndent(out, indent, "/**\n");
        this.writeWithIndent(out, indent, " * " + method.getMethodName());
        this.writeEol(out);
        for (MethodParam param : method.getParams()) {
            this.writeIndent(out, indent);
            out.write(" * @param " + param.getName() + " " + param.getName());
            this.writeEol(out);
        }
        if (!method.getReturnType().equals("void")) {
            this.writeIndent(out, indent);
            out.write(" * @return " + method.getReturnType());
            this.writeEol(out);
        }
        for (String ex : method.getExceptionType()) {
            this.writeIndent(out, indent);
            out.write(" * @throws " + ex + " " + ex);
            this.writeEol(out);
        }
        this.writeWithIndent(out, indent, " */\n");
        this.writeWithIndent(out, indent, "public " + method.getReturnType() + " " + method.getMethodName() + "(");
        int paramSize = method.getParams().size();
        for (int i = 0; i < paramSize; ++i) {
            MethodParam param = method.getParams().get(i);
            out.write(param.getType());
            out.write(" ");
            out.write(param.getName());
            if (i + 1 >= paramSize) continue;
            out.write(", ");
        }
        out.write(")");
        int exceptionSize = method.getExceptionType().size();
        for (int i = 0; i < exceptionSize; ++i) {
            if (i == 0) {
                out.write(" throws ");
            }
            String ex = method.getExceptionType().get(i);
            out.write(ex);
            if (i + 1 >= exceptionSize) continue;
            out.write(", ");
        }
    }

    public abstract void writeImport(Definition var1, Writer var2) throws IOException;

    public abstract void writeClassBody(Definition var1, Writer var2) throws IOException;

    void writeLeftCurlyBracket(Writer out, int indent) throws IOException {
        this.writeEol(out);
        this.writeWithIndent(out, indent, "{\n");
    }

    void writeRightCurlyBracket(Writer out, int indent) throws IOException {
        this.writeEol(out);
        this.writeWithIndent(out, indent, "}\n");
    }

    void writeDefaultConstructor(Definition def, Writer out, int indent) throws IOException {
        this.writeWithIndent(out, indent, "/**\n");
        this.writeWithIndent(out, indent, " * Default constructor\n");
        this.writeWithIndent(out, indent, " */\n");
        this.writeWithIndent(out, indent, "public " + this.getClassName(def) + "()");
        this.writeLeftCurlyBracket(out, indent);
        this.writeRightCurlyBracket(out, indent);
        this.writeEol(out);
    }

    String upcaseFirst(String name) {
        StringBuilder sb = new StringBuilder();
        sb.append(name.substring(0, 1).toUpperCase(Locale.ENGLISH));
        sb.append(name.substring(1));
        return sb.toString();
    }

    void writeHashCode(Definition def, Writer out, int indent) throws IOException {
        this.writeWithIndent(out, indent, "/** \n");
        this.writeWithIndent(out, indent, " * Returns a hash code value for the object.\n");
        this.writeWithIndent(out, indent, " * @return A hash code value for this object.\n");
        this.writeWithIndent(out, indent, " */\n");
        this.writeWithIndent(out, indent, "@Override\n");
        this.writeWithIndent(out, indent, "public int hashCode()");
        this.writeLeftCurlyBracket(out, indent);
        this.writeWithIndent(out, indent + 1, "return 42;");
        this.writeRightCurlyBracket(out, indent);
        this.writeEol(out);
    }

    void writeEquals(Definition def, Writer out, int indent) throws IOException {
        this.writeWithIndent(out, indent, "/** \n");
        this.writeWithIndent(out, indent, " * Indicates whether some other object is equal to this one.\n");
        this.writeWithIndent(out, indent, " * @param other The reference object with which to compare.\n");
        this.writeWithIndent(out, indent, " * @return true If this object is the same as the obj argument, false otherwise.\n");
        this.writeWithIndent(out, indent, " */\n");
        this.writeWithIndent(out, indent, "@Override\n");
        this.writeWithIndent(out, indent, "public boolean equals(Object other)");
        this.writeLeftCurlyBracket(out, indent);
        this.writeWithIndent(out, indent + 1, "if (other == null)\n");
        this.writeWithIndent(out, indent + 2, "return false;\n");
        this.writeWithIndent(out, indent + 1, "return getClass().equals(other.getClass());");
        this.writeRightCurlyBracket(out, indent);
        this.writeEol(out);
    }

    public void setNumOfMcf(int numOfMcf) {
        this.numOfMcf = numOfMcf;
    }

    public int getNumOfMcf() {
        return this.numOfMcf;
    }

    protected String getSelfClassName(Definition def) {
        return this.getClassName(def) + ".class.getName()";
    }

    protected void importLogging(Definition def, Writer out) throws IOException {
        if (def.isSupportJbossLogging()) {
            out.write("import org.jboss.logging.Logger;");
            this.writeEol(out);
            this.writeEol(out);
        } else {
            out.write("import java.util.logging.Logger;");
            this.writeEol(out);
            this.writeEol(out);
        }
    }

    protected void writeLogging(Definition def, Writer out, int indent, String level, String content, String ... params) throws IOException {
        this.writeIndent(out, indent);
        if (def.isSupportJbossLogging()) {
            int i;
            out.write("log.trace");
            int size = params.length;
            if (size > 0) {
                out.write("f");
            }
            out.write("(\"" + content + "(");
            for (i = 0; i < size; ++i) {
                out.write("%s");
                if (i >= size - 1) continue;
                out.write(", ");
            }
            out.write(")\"");
            for (i = 0; i < size; ++i) {
                out.write(", ");
                out.write(params[i]);
            }
            out.write(");");
        } else {
            out.write("log.finest(\"" + content + "()\");");
        }
        this.writeEol(out);
    }

    protected void writeLogWriter(Definition def, Writer out, int indent) throws IOException {
        this.writeWithIndent(out, indent, "/**\n");
        this.writeWithIndent(out, indent, " * Gets the log writer for this ManagedConnection instance.\n");
        this.writeWithIndent(out, indent, " *\n");
        this.writeWithIndent(out, indent, " * @return Character output stream associated with this Managed-Connection instance\n");
        this.writeWithIndent(out, indent, " * @throws ResourceException generic exception if operation fails\n");
        this.writeWithIndent(out, indent, " */\n");
        this.writeWithIndent(out, indent, "public PrintWriter getLogWriter() throws ResourceException");
        this.writeLeftCurlyBracket(out, indent);
        this.writeLogging(def, out, indent + 1, "trace", "getLogWriter", new String[0]);
        this.writeWithIndent(out, indent + 1, "return logwriter;");
        this.writeRightCurlyBracket(out, indent);
        this.writeEol(out);
        this.writeWithIndent(out, indent, "/**\n");
        this.writeWithIndent(out, indent, " * Sets the log writer for this ManagedConnection instance.\n");
        this.writeWithIndent(out, indent, " *\n");
        this.writeWithIndent(out, indent, " * @param out Character Output stream to be associated\n");
        this.writeWithIndent(out, indent, " * @throws ResourceException  generic exception if operation fails\n");
        this.writeWithIndent(out, indent, " */\n");
        this.writeWithIndent(out, indent, "public void setLogWriter(PrintWriter out) throws ResourceException");
        this.writeLeftCurlyBracket(out, indent);
        this.writeLogging(def, out, indent + 1, "trace", "setLogWriter", "out");
        this.writeWithIndent(out, indent + 1, "logwriter = out;");
        this.writeRightCurlyBracket(out, indent);
        this.writeEol(out);
    }
}

