/*
 * Decompiled with CFR 0.152.
 */
package org.ironjacamar.codegenerator.code;

import java.io.IOException;
import java.io.Writer;
import org.ironjacamar.codegenerator.Definition;
import org.ironjacamar.codegenerator.code.AbstractCodeGen;

public class ActivationCodeGen
extends AbstractCodeGen {
    @Override
    public void writeClassBody(Definition def, Writer out) throws IOException {
        out.write("public class " + this.getClassName(def));
        this.writeLeftCurlyBracket(out, 0);
        this.writeEol(out);
        int indent = 1;
        this.writeWithIndent(out, indent, "/** The resource adapter */\n");
        this.writeWithIndent(out, indent, "private " + def.getRaClass() + " ra;\n\n");
        this.writeWithIndent(out, indent, "/** Activation spec */\n");
        this.writeWithIndent(out, indent, "private " + def.getAsClass() + " spec;\n\n");
        this.writeWithIndent(out, indent, "/** The message endpoint factory */\n");
        this.writeWithIndent(out, indent, "private MessageEndpointFactory endpointFactory;\n\n");
        this.writeWithIndent(out, indent, "/**\n");
        this.writeWithIndent(out, indent, " * Default constructor\n");
        this.writeWithIndent(out, indent, " * @exception ResourceException Thrown if an error occurs\n");
        this.writeWithIndent(out, indent, " */\n");
        this.writeWithIndent(out, indent, "public " + this.getClassName(def) + "() throws ResourceException");
        this.writeLeftCurlyBracket(out, indent);
        this.writeWithIndent(out, indent + 1, "this(null, null, null);");
        this.writeRightCurlyBracket(out, indent);
        this.writeEol(out);
        this.writeWithIndent(out, indent, "/**\n");
        this.writeWithIndent(out, indent, " * Constructor\n");
        this.writeWithIndent(out, indent, " * @param ra " + def.getRaClass());
        this.writeEol(out);
        this.writeWithIndent(out, indent, " * @param endpointFactory MessageEndpointFactory\n");
        this.writeWithIndent(out, indent, " * @param spec " + def.getAsClass());
        this.writeEol(out);
        this.writeWithIndent(out, indent, " * @exception ResourceException Thrown if an error occurs\n");
        this.writeWithIndent(out, indent, " */\n");
        this.writeWithIndent(out, indent, "public " + this.getClassName(def) + "(" + def.getRaClass() + " ra, \n");
        this.writeWithIndent(out, indent + 1, "MessageEndpointFactory endpointFactory,\n");
        this.writeWithIndent(out, indent + 1, def.getAsClass() + " spec) throws ResourceException\n");
        this.writeLeftCurlyBracket(out, indent);
        this.writeWithIndent(out, indent + 1, "this.ra = ra;\n");
        this.writeWithIndent(out, indent + 1, "this.endpointFactory = endpointFactory;\n");
        this.writeWithIndent(out, indent + 1, "this.spec = spec;");
        this.writeRightCurlyBracket(out, indent);
        this.writeEol(out);
        this.writeGetAs(def, out, indent);
        this.writeMef(def, out, indent);
        this.writeStartStop(def, out, indent);
        this.writeRightCurlyBracket(out, 0);
    }

    @Override
    public void writeImport(Definition def, Writer out) throws IOException {
        out.write("package " + def.getRaPackage() + ".inflow;\n\n");
        out.write("import " + def.getRaPackage() + "." + def.getRaClass() + ";\n\n");
        out.write("import javax.resource.ResourceException;\n");
        out.write("import javax.resource.spi.endpoint.MessageEndpointFactory;\n\n");
    }

    @Override
    public String getClassName(Definition def) {
        return def.getActivationClass();
    }

    private void writeGetAs(Definition def, Writer out, int indent) throws IOException {
        this.writeWithIndent(out, indent, "/**\n");
        this.writeWithIndent(out, indent, " * Get activation spec class\n");
        this.writeWithIndent(out, indent, " * @return Activation spec\n");
        this.writeWithIndent(out, indent, " */\n");
        this.writeWithIndent(out, indent, "public " + def.getAsClass() + " getActivationSpec()");
        this.writeLeftCurlyBracket(out, indent);
        this.writeWithIndent(out, indent + 1, "return spec;");
        this.writeRightCurlyBracket(out, indent);
        this.writeEol(out);
    }

    private void writeMef(Definition def, Writer out, int indent) throws IOException {
        this.writeWithIndent(out, indent, "/**\n");
        this.writeWithIndent(out, indent, " * Get message endpoint factory\n");
        this.writeWithIndent(out, indent, " * @return Message endpoint factory\n");
        this.writeWithIndent(out, indent, " */\n");
        this.writeWithIndent(out, indent, "public MessageEndpointFactory getMessageEndpointFactory()");
        this.writeLeftCurlyBracket(out, indent);
        this.writeWithIndent(out, indent + 1, "return endpointFactory;");
        this.writeRightCurlyBracket(out, indent);
        this.writeEol(out);
    }

    private void writeStartStop(Definition def, Writer out, int indent) throws IOException {
        this.writeWithIndent(out, indent, "/**\n");
        this.writeWithIndent(out, indent, " * Start the activation\n");
        this.writeWithIndent(out, indent, " * @throws ResourceException Thrown if an error occurs\n");
        this.writeWithIndent(out, indent, " */\n");
        this.writeWithIndent(out, indent, "public void start() throws ResourceException");
        this.writeLeftCurlyBracket(out, indent);
        this.writeRightCurlyBracket(out, indent);
        this.writeEol(out);
        this.writeWithIndent(out, indent, "/**\n");
        this.writeWithIndent(out, indent, " * Stop the activation\n");
        this.writeWithIndent(out, indent, " */\n");
        this.writeWithIndent(out, indent, "public void stop()");
        this.writeLeftCurlyBracket(out, indent);
        this.writeRightCurlyBracket(out, indent);
        this.writeEol(out);
    }
}

