/*
 * Decompiled with CFR 0.152.
 */
package org.ironjacamar.codegenerator.code;

import java.io.IOException;
import java.io.Writer;
import java.util.List;
import org.ironjacamar.codegenerator.ConfigPropType;
import org.ironjacamar.codegenerator.Definition;
import org.ironjacamar.codegenerator.code.PropsCodeGen;

public class AoImplCodeGen
extends PropsCodeGen {
    int numOfAo = 0;

    public AoImplCodeGen() {
    }

    public AoImplCodeGen(int num) {
        this.numOfAo = num;
    }

    public int getNumOfAo() {
        return this.numOfAo;
    }

    public void setNumOfAo(int numOfAo) {
        this.numOfAo = numOfAo;
    }

    @Override
    public void writeClassBody(Definition def, Writer out) throws IOException {
        if (def.isUseAnnotation()) {
            out.write("@AdministeredObject(adminObjectInterfaces = { ");
            out.write(def.getAdminObjects().get(this.numOfAo).getAdminObjectInterface());
            out.write(".class })\n");
        }
        out.write("public class " + this.getClassName(def) + " implements " + def.getAdminObjects().get(this.numOfAo).getAdminObjectInterface());
        if (def.isAdminObjectImplRaAssociation()) {
            out.write(",\n");
            this.writeIndent(out, 1);
            out.write("ResourceAdapterAssociation, Referenceable, Serializable");
        }
        this.writeLeftCurlyBracket(out, 0);
        int indent = 1;
        this.writeIndent(out, indent);
        out.write("/** Serial version uid */\n");
        this.writeIndent(out, indent);
        out.write("private static final long serialVersionUID = 1L;\n\n");
        if (def.isAdminObjectImplRaAssociation()) {
            this.writeWithIndent(out, indent, "/** The resource adapter */\n");
            this.writeIndent(out, indent);
            if (def.isRaSerial()) {
                out.write("private ResourceAdapter ra;\n\n");
            } else {
                out.write("private transient ResourceAdapter ra;\n\n");
            }
            this.writeWithIndent(out, indent, "/** Reference */\n");
            this.writeWithIndent(out, indent, "private Reference reference;\n\n");
        }
        this.writeConfigPropsDeclare(def, out, indent);
        this.writeDefaultConstructor(def, out, indent);
        this.writeConfigProps(def, out, indent);
        if (def.isAdminObjectImplRaAssociation()) {
            this.writeResourceAdapter(def, out, indent);
            this.writeReference(def, out, indent);
        }
        this.writeHashCode(def, out, indent);
        this.writeEquals(def, out, indent);
        this.writeRightCurlyBracket(out, 0);
    }

    @Override
    public void writeImport(Definition def, Writer out) throws IOException {
        out.write("package " + def.getRaPackage() + ";\n\n");
        if (def.isAdminObjectImplRaAssociation()) {
            out.write("import java.io.Serializable;\n\n");
            out.write("import javax.naming.NamingException;\n");
            out.write("import javax.naming.Reference;\n\n");
            out.write("import javax.resource.Referenceable;\n");
        }
        if (def.isUseAnnotation()) {
            out.write("import javax.resource.spi.AdministeredObject;\n");
            out.write("import javax.resource.spi.ConfigProperty;\n");
        }
        if (def.isAdminObjectImplRaAssociation()) {
            out.write("import javax.resource.spi.ResourceAdapter;\n");
            out.write("import javax.resource.spi.ResourceAdapterAssociation;\n");
        }
        this.writeEol(out);
    }

    @Override
    public String getClassName(Definition def) {
        return def.getAdminObjects().get(this.numOfAo).getAdminObjectClass();
    }

    @Override
    public List<ConfigPropType> getConfigProps(Definition def) {
        return def.getAdminObjects().get(this.numOfAo).getAoConfigProps();
    }

    private void writeResourceAdapter(Definition def, Writer out, int indent) throws IOException {
        this.writeIndent(out, indent);
        out.write("/**\n");
        this.writeIndent(out, indent);
        out.write(" * Get the resource adapter\n");
        this.writeIndent(out, indent);
        out.write(" *\n");
        this.writeIndent(out, indent);
        out.write(" * @return The handle\n");
        this.writeIndent(out, indent);
        out.write(" */\n");
        this.writeIndent(out, indent);
        out.write("public ResourceAdapter getResourceAdapter()");
        this.writeLeftCurlyBracket(out, indent);
        this.writeWithIndent(out, indent + 1, "return ra;");
        this.writeRightCurlyBracket(out, indent);
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("/**\n");
        this.writeIndent(out, indent);
        out.write(" * Set the resource adapter\n");
        this.writeIndent(out, indent);
        out.write(" *\n");
        this.writeIndent(out, indent);
        out.write(" * @param ra The handle\n");
        this.writeIndent(out, indent);
        out.write(" */\n");
        this.writeIndent(out, indent);
        out.write("public void setResourceAdapter(ResourceAdapter ra)");
        this.writeLeftCurlyBracket(out, indent);
        this.writeWithIndent(out, indent + 1, "this.ra = ra;");
        this.writeRightCurlyBracket(out, indent);
        this.writeEol(out);
    }

    private void writeReference(Definition def, Writer out, int indent) throws IOException {
        this.writeIndent(out, indent);
        out.write("/**\n");
        this.writeIndent(out, indent);
        out.write(" * Get the Reference instance.\n");
        this.writeIndent(out, indent);
        out.write(" *\n");
        this.writeIndent(out, indent);
        out.write(" * @return Reference instance\n");
        this.writeIndent(out, indent);
        out.write(" * @exception NamingException Thrown if a reference can't be obtained\n");
        this.writeIndent(out, indent);
        out.write(" */\n");
        this.writeIndent(out, indent);
        out.write("@Override\n");
        this.writeIndent(out, indent);
        out.write("public Reference getReference() throws NamingException");
        this.writeLeftCurlyBracket(out, indent);
        this.writeWithIndent(out, indent + 1, "return reference;");
        this.writeRightCurlyBracket(out, indent);
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("/**\n");
        this.writeIndent(out, indent);
        out.write(" * Set the Reference instance.\n");
        this.writeIndent(out, indent);
        out.write(" *\n");
        this.writeIndent(out, indent);
        out.write(" * @param reference A Reference instance\n");
        this.writeIndent(out, indent);
        out.write(" */\n");
        this.writeIndent(out, indent);
        out.write("@Override\n");
        this.writeIndent(out, indent);
        out.write("public void setReference(Reference reference)");
        this.writeLeftCurlyBracket(out, indent);
        this.writeWithIndent(out, indent + 1, "this.reference = reference;");
        this.writeRightCurlyBracket(out, indent);
        this.writeEol(out);
    }
}

