/*
 * Decompiled with CFR 0.152.
 */
package org.ironjacamar.codegenerator.code;

import java.io.IOException;
import java.io.Writer;
import java.util.List;
import org.ironjacamar.codegenerator.ConfigPropType;
import org.ironjacamar.codegenerator.Definition;
import org.ironjacamar.codegenerator.code.AbstractCodeGen;

public class AoInterfaceCodeGen
extends AbstractCodeGen {
    int numOfAo = 0;

    public AoInterfaceCodeGen() {
    }

    public AoInterfaceCodeGen(int num) {
        this.numOfAo = num;
    }

    public int getNumOfAo() {
        return this.numOfAo;
    }

    public void setNumOfAo(int numOfAo) {
        this.numOfAo = numOfAo;
    }

    @Override
    public void writeClassBody(Definition def, Writer out) throws IOException {
        out.write("public interface " + this.getClassName(def));
        if (def.isAdminObjectImplRaAssociation()) {
            out.write(" extends Referenceable, Serializable");
        }
        this.writeLeftCurlyBracket(out, 0);
        this.writeEol(out);
        int indent = 1;
        this.writeConfigProps(def, out, indent);
        this.writeRightCurlyBracket(out, 0);
    }

    @Override
    public void writeImport(Definition def, Writer out) throws IOException {
        out.write("package " + def.getRaPackage() + ";\n\n");
        if (def.isAdminObjectImplRaAssociation()) {
            out.write("import java.io.Serializable;\n\n");
            out.write("import javax.resource.Referenceable;\n");
        }
        this.writeEol(out);
    }

    @Override
    public String getClassName(Definition def) {
        return def.getAdminObjects().get(this.numOfAo).getAdminObjectInterface();
    }

    private void writeConfigProps(Definition def, Writer out, int indent) throws IOException {
        for (int i = 0; i < this.getConfigProps(def).size(); ++i) {
            String name = this.getConfigProps(def).get(i).getName();
            String upcaseName = this.upcaseFirst(name);
            this.writeWithIndent(out, indent, "/** \n");
            this.writeWithIndent(out, indent, " * Set " + name);
            this.writeEol(out);
            this.writeWithIndent(out, indent, " * @param " + name + " The value\n");
            this.writeWithIndent(out, indent, " */\n");
            this.writeWithIndent(out, indent, "public void set" + upcaseName + "(" + this.getConfigProps(def).get(i).getType() + " " + name + ");\n\n");
            this.writeWithIndent(out, indent, "/** \n");
            this.writeWithIndent(out, indent, " * Get " + name);
            this.writeEol(out);
            this.writeWithIndent(out, indent, " * @return The value\n");
            this.writeWithIndent(out, indent, " */\n");
            this.writeWithIndent(out, indent, "public " + this.getConfigProps(def).get(i).getType() + " get" + upcaseName + "();\n\n");
        }
    }

    public List<ConfigPropType> getConfigProps(Definition def) {
        return def.getAdminObjects().get(this.numOfAo).getAoConfigProps();
    }
}

